/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v389.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v388.serializer.EventSerializer_v388;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.event.EventData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.event.EventDataType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.event.ExtractHoneyEventData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.event.PlayerDiedEventData;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;

public class EventSerializer_v389
extends EventSerializer_v388 {
    public static final EventSerializer_v389 INSTANCE = new EventSerializer_v389();

    protected EventSerializer_v389() {
        this.readers.put(EventDataType.EXTRACT_HONEY, (b, h) -> ExtractHoneyEventData.INSTANCE);
        this.writers.put(EventDataType.EXTRACT_HONEY, (b, h, e) -> {});
        this.writers.put(EventDataType.PLAYER_DIED, this::writePlayerDied);
        this.readers.put(EventDataType.PLAYER_DIED, this::readPlayerDied);
    }

    @Override
    protected PlayerDiedEventData readPlayerDied(ByteBuf buffer, BedrockCodecHelper helper) {
        int attackerEntityId = VarInts.readInt(buffer);
        int attackerVariant = VarInts.readInt(buffer);
        int entityDamageCause = VarInts.readInt(buffer);
        boolean inRaid = buffer.readBoolean();
        return new PlayerDiedEventData(attackerEntityId, attackerVariant, entityDamageCause, inRaid);
    }

    @Override
    protected void writePlayerDied(ByteBuf buffer, BedrockCodecHelper helper, EventData eventData) {
        PlayerDiedEventData event = (PlayerDiedEventData)eventData;
        VarInts.writeInt(buffer, event.getAttackerEntityId());
        VarInts.writeInt(buffer, event.getAttackerVariant());
        VarInts.writeInt(buffer, event.getEntityDamageCause());
        buffer.writeBoolean(event.isInRaid());
    }
}

