/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v407.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseContainer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseSlot;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemStackResponsePacket;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ItemStackResponseSerializer_v407
implements BedrockPacketSerializer<ItemStackResponsePacket> {
    public static final ItemStackResponseSerializer_v407 INSTANCE = new ItemStackResponseSerializer_v407();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ItemStackResponsePacket packet) {
        helper.writeArray(buffer, packet.getEntries(), (buf, response) -> {
            buf.writeBoolean(response.isSuccess());
            VarInts.writeInt(buffer, response.getRequestId());
            if (!response.isSuccess()) {
                return;
            }
            helper.writeArray((ByteBuf)buf, response.getContainers(), (buf2, containerEntry) -> {
                helper.writeContainerSlotType((ByteBuf)buf2, containerEntry.getContainer());
                helper.writeArray((ByteBuf)buf2, containerEntry.getItems(), this::writeItemEntry);
            });
        });
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ItemStackResponsePacket packet) {
        List<ItemStackResponse> entries = packet.getEntries();
        helper.readArray(buffer, entries, buf -> {
            boolean success = buf.readBoolean();
            int requestId = VarInts.readInt(buf);
            if (!success) {
                return new ItemStackResponse(success, requestId, Collections.emptyList());
            }
            ArrayList<ItemStackResponseContainer> containerEntries = new ArrayList<ItemStackResponseContainer>();
            helper.readArray((ByteBuf)buf, containerEntries, buf2 -> {
                ContainerSlotType container = helper.readContainerSlotType((ByteBuf)buf2);
                ArrayList<ItemStackResponseSlot> itemEntries = new ArrayList<ItemStackResponseSlot>();
                helper.readArray((ByteBuf)buf2, itemEntries, byteBuf -> this.readItemEntry((ByteBuf)byteBuf, helper));
                return new ItemStackResponseContainer(container, itemEntries, null);
            });
            return new ItemStackResponse(success, requestId, containerEntries);
        });
    }

    protected ItemStackResponseSlot readItemEntry(ByteBuf buffer, BedrockCodecHelper helper) {
        return new ItemStackResponseSlot(buffer.readUnsignedByte(), buffer.readUnsignedByte(), buffer.readUnsignedByte(), VarInts.readInt(buffer), "", 0, "");
    }

    protected void writeItemEntry(ByteBuf buffer, BedrockCodecHelper helper, ItemStackResponseSlot itemEntry) {
        buffer.writeByte(itemEntry.getSlot());
        buffer.writeByte(itemEntry.getHotbarSlot());
        buffer.writeByte(itemEntry.getCount());
        VarInts.writeInt(buffer, itemEntry.getStackNetworkId());
    }

    protected ItemStackResponseSerializer_v407() {
    }
}

