/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v419.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v407.serializer.ItemStackResponseSerializer_v407;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseContainer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseStatus;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemStackResponsePacket;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ItemStackResponseSerializer_v419
extends ItemStackResponseSerializer_v407 {
    public static final ItemStackResponseSerializer_v419 INSTANCE = new ItemStackResponseSerializer_v419();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ItemStackResponsePacket packet) {
        helper.writeArray(buffer, packet.getEntries(), (buf, response) -> {
            buf.writeByte(response.getResult().ordinal());
            VarInts.writeInt(buffer, response.getRequestId());
            if (response.getResult() != ItemStackResponseStatus.OK) {
                return;
            }
            helper.writeArray((ByteBuf)buf, response.getContainers(), helper::writeItemStackResponseContainer);
        });
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ItemStackResponsePacket packet) {
        List<ItemStackResponse> entries = packet.getEntries();
        helper.readArray(buffer, entries, buf -> {
            ItemStackResponseStatus result = ItemStackResponseStatus.values()[buf.readByte()];
            int requestId = VarInts.readInt(buf);
            if (result != ItemStackResponseStatus.OK) {
                return new ItemStackResponse(result, requestId, Collections.emptyList());
            }
            ArrayList<ItemStackResponseContainer> containerEntries = new ArrayList<ItemStackResponseContainer>();
            helper.readArray((ByteBuf)buf, containerEntries, helper::readItemStackResponseContainer);
            return new ItemStackResponse(result, requestId, containerEntries);
        });
    }
}

