/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v776.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.SimpleItemDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemVersion;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemComponentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import org.cloudburstmc.nbt.NbtMap;

public class ItemComponentSerializer_v776
implements BedrockPacketSerializer<ItemComponentPacket> {
    public static final ItemComponentSerializer_v776 INSTANCE = new ItemComponentSerializer_v776();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ItemComponentPacket packet) {
        helper.writeArray(buffer, packet.getItems(), (buf, packetHelper, item) -> {
            packetHelper.writeString((ByteBuf)buf, item.getIdentifier());
            buf.writeShortLE(item.getRuntimeId());
            buf.writeBoolean(item.isComponentBased());
            VarInts.writeInt(buffer, item.getVersion().ordinal());
            if (item.getComponentData() != null) {
                packetHelper.writeTag((ByteBuf)buf, item.getComponentData());
            } else {
                packetHelper.writeTag((ByteBuf)buf, NbtMap.EMPTY);
            }
        });
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ItemComponentPacket packet) {
        helper.readArray(buffer, packet.getItems(), (buf, packetHelper) -> {
            String name = packetHelper.readString((ByteBuf)buf);
            short itemId = buf.readShortLE();
            boolean componentBased = buf.readBoolean();
            int version = VarInts.readInt(buffer);
            NbtMap data = packetHelper.readTag((ByteBuf)buf, NbtMap.class);
            return new SimpleItemDefinition(name, itemId, ItemVersion.from(version), componentBased, data);
        });
    }

    protected ItemComponentSerializer_v776() {
    }
}

