/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.utils;

import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeMap;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;

public final class HashUtils {
    private static final int FNV1_32_INIT = -2128831035;
    private static final int FNV1_PRIME_32 = 16777619;

    public static int computeBlockStateHash(String identifier, NbtMap propertyValues) {
        if (identifier.equals("minecraft:unknown")) {
            return -2;
        }
        TreeMap states = new TreeMap(propertyValues.getCompound("states", propertyValues));
        NbtMap mappedFullState = NbtMap.builder().putString("name", identifier).putCompound("states", NbtMap.fromMap(states)).build();
        return HashUtils.fnv1a_32_nbt(mappedFullState);
    }

    public static int computeBlockStateHash(NbtMap propertyValues) {
        String identifier = propertyValues.getString("name");
        return HashUtils.computeBlockStateHash(identifier, propertyValues);
    }

    public static int fnv1a_32_nbt(NbtMap tag) {
        byte[] bytes;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             NBTOutputStream outputStream = NbtUtils.createWriterLE((OutputStream)stream);){
            outputStream.writeTag((Object)tag);
            bytes = stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return HashUtils.fnv1a_32(bytes);
    }

    public static int fnv1a_32(byte[] data) {
        int hash = -2128831035;
        for (byte datum : data) {
            hash ^= datum & 0xFF;
            hash *= 16777619;
        }
        return hash;
    }

    @Generated
    private HashUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

