/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import lombok.NonNull;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ItemComponentPacket;
import org.geysermc.geyser.session.UpstreamSession;
import oxy.geyser.reversion.GeyserReversion;
import oxy.geyser.reversion.session.GeyserTranslatedUser;
import oxy.geyser.reversion.util.RegistryUtil;

public final class TranslatorSendListener
extends UpstreamSession {
    private final GeyserTranslatedUser user;
    private final UpstreamSession oldSession;

    public TranslatorSendListener(GeyserTranslatedUser user, BedrockServerSession session, UpstreamSession oldSession) {
        super(session);
        this.oldSession = oldSession;
        this.user = user;
    }

    public void disconnect(String reason) {
        this.oldSession.disconnect(reason);
    }

    public void sendPacket(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (packet instanceof ItemComponentPacket) {
            RegistryUtil.onItemComponent(this.user, (ItemComponentPacket)packet);
        }
        if (this.user != null) {
            BedrockPacket translated = this.translate(packet);
            if (translated != null) {
                super.sendPacket(translated);
            }
            return;
        }
        super.sendPacket(packet);
    }

    public void sendPacketImmediately(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (this.user != null) {
            BedrockPacket translated = this.translate(packet);
            if (translated != null) {
                super.sendPacketImmediately(translated);
            }
            return;
        }
        super.sendPacketImmediately(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BedrockPacket translate(BedrockPacket packet) {
        ByteBuf input = Unpooled.buffer();
        ByteBuf output = Unpooled.buffer();
        try {
            this.user.encodeServer(packet, input);
            int oldId = this.user.getCloudburstServerCodec().getPacketDefinition(packet.getClass()).getId();
            Integer newId = this.user.translateClientbound(input, output, oldId);
            if (newId == null) {
                BedrockPacket bedrockPacket = null;
                return bedrockPacket;
            }
            BedrockPacket bedrockPacket = this.user.decodeClient(output, newId);
            return bedrockPacket;
        }
        catch (Exception exception) {
            if (GeyserReversion.CONFIG.debugMode()) {
                GeyserReversion.LOGGER.severe("Failed to translate " + String.valueOf(packet.getPacketType()) + " (clientbound)!", (Throwable)exception);
            }
        }
        finally {
            input.release();
            output.release();
        }
        return null;
    }

    public int getProtocolVersion() {
        return this.user == null ? super.getProtocolVersion() : GeyserReversion.OLDEST_GEYSER_CODEC.getProtocolVersion();
    }
}

