/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.transformer.impl.redirect;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.tree.AbstractInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.InsnList;
import oxy.geyser.reversion.shaded.asm.tree.MethodInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.asm.tree.VarInsnNode;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;

@ParametersAreNonnullByDefault
public interface IRedirectTarget {
    public void inject(ClassNode var1, MethodNode var2, ClassNode var3, MethodNode var4, AbstractInsnNode var5, List<MethodInsnNode> var6);

    default public InsnList[] getLoadStoreOpcodes(@Nullable String owner, String desc, int freeVarIndex) {
        Type[] argumentTypes;
        InsnList storeOpcodes = new InsnList();
        InsnList loadOpcodes = new InsnList();
        if (owner != null) {
            Type ownerType = Types.type(owner);
            storeOpcodes.add(new VarInsnNode(ASMUtils.getStoreOpcode(ownerType), freeVarIndex));
            loadOpcodes.add(new VarInsnNode(ASMUtils.getLoadOpcode(ownerType), freeVarIndex));
            freeVarIndex += ownerType.getSize();
        }
        for (Type argumentType : argumentTypes = Types.argumentTypes(desc)) {
            int storeOpcode = ASMUtils.getStoreOpcode(argumentType);
            int loadOpcode = ASMUtils.getLoadOpcode(argumentType);
            storeOpcodes.add(new VarInsnNode(storeOpcode, freeVarIndex));
            loadOpcodes.add(new VarInsnNode(loadOpcode, freeVarIndex));
            freeVarIndex += argumentType.getSize();
        }
        InsnList reversedStoreOpcodes = new InsnList();
        for (int i = storeOpcodes.size() - 1; i >= 0; --i) {
            reversedStoreOpcodes.add(storeOpcodes.get(i));
        }
        return new InsnList[]{reversedStoreOpcodes, loadOpcodes};
    }
}

