/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.util;

import java.io.File;
import org.geysermc.geyser.api.extension.Extension;
import oxy.geyser.reversion.GeyserReversion;
import oxy.geyser.reversion.shaded.reflect.ClassLoaders;

public class ClassLoaderPriorityUtil {
    public static void loadOverridingJars(Extension extension) {
        File jarsFolder = new File(extension.dataFolder().toFile(), "jars");
        if (!jarsFolder.exists()) {
            jarsFolder.mkdir();
            return;
        }
        if (jarsFolder.isDirectory()) {
            for (File file : jarsFolder.listFiles()) {
                try {
                    if (!file.getName().endsWith(".jar")) continue;
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(ClassLoaderPriorityUtil.class.getClassLoader());
                    ClassLoaders.loadToFront(file.toURI().toURL());
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    GeyserReversion.LOGGER.warning("Loaded overriding jar " + file.getName());
                }
                catch (Throwable e) {
                    GeyserReversion.LOGGER.error("Failed to load overriding jar " + file.getName(), e);
                }
            }
        }
    }
}

