/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.bedrock.session.StepFullBedrockSession;
import net.raphimc.minecraftauth.step.msa.StepMsaDeviceCode;
import net.raphimc.minecraftauth.util.logging.ILogger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.util.MinecraftAuthLogger;

public class PendingBedrockAuthentication {
    public static final HttpClient AUTH_CLIENT = PendingMicrosoftAuthentication.AUTH_CLIENT;
    public static final BiFunction<Boolean, Integer, StepFullBedrockSession> AUTH_FLOW = (offlineAccess, timeoutSec) -> MinecraftAuth.builder().withClientId("0000000048183522").withScope("service::user.auth.xboxlive.com::MBI_SSL").deviceCode().withDeviceToken("Android").sisuTitleAuthentication("https://multiplayer.minecraft.net/").buildMinecraftBedrockChainStep(true, false);
    private final LoadingCache<String, AuthenticationTask> authentications = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AuthenticationTask>(){

        public AuthenticationTask load(@NonNull String userKey) {
            return new AuthenticationTask(userKey, 120);
        }
    });

    public AuthenticationTask getOrCreateTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.get((Object)userKey);
    }

    public class AuthenticationTask {
        private static final Executor DELAYED_BY_ONE_SECOND = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
        private final int timeoutSec;
        private CompletableFuture<StepChainResult> authentication;
        private final String userKey;

        public AuthenticationTask(String userKey, int timeoutSec) {
            this.userKey = userKey;
            this.timeoutSec = timeoutSec;
        }

        public void cleanup() {
            GeyserLogger logger = GeyserImpl.getInstance().getLogger();
            if (logger.isDebug()) {
                logger.debug("Cleaning up authentication task for " + this.userKey);
            }
            PendingBedrockAuthentication.this.authentications.invalidate((Object)this.userKey);
        }

        public void resetRunningFlow() {
            if (this.authentication == null) {
                return;
            }
            this.authentication.cancel(true);
        }

        public CompletableFuture<StepChainResult> performLoginAttempt(Consumer<StepMsaDeviceCode.MsaDeviceCode> deviceCodeConsumer) {
            this.authentication = CompletableFuture.supplyAsync(() -> {
                try {
                    StepFullBedrockSession step = AUTH_FLOW.apply(false, this.timeoutSec);
                    return new StepChainResult(step, (StepFullBedrockSession.FullBedrockSession)step.getFromInput((ILogger)MinecraftAuthLogger.INSTANCE, AUTH_CLIENT, (AbstractStep.InitialInput)new StepMsaDeviceCode.MsaDeviceCodeCallback(deviceCodeConsumer)));
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }, DELAYED_BY_ONE_SECOND).whenComplete((r, ex) -> CompletableFuture.delayedExecutor(this.timeoutSec, TimeUnit.SECONDS).execute(this::cleanup));
            return this.authentication;
        }

        @Generated
        public CompletableFuture<StepChainResult> getAuthentication() {
            return this.authentication;
        }
    }

    public record StepChainResult(StepFullBedrockSession step, StepFullBedrockSession.FullBedrockSession session) {
    }
}

