/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gooddrink.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mcreator.gooddrink.GoodDrinkModPlayerAnimationAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerAnimationRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private String master = null;

    public PlayerAnimationRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float f) {
        super(context, entityModel, f);
    }

    @Inject(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private void hideBonesInFirstPerson(AbstractClientPlayer entity, float f, float g, PoseStack poseStack, MultiBufferSource bufferSource, int light, CallbackInfo ci) {
        if (this.master == null) {
            if (!GoodDrinkModPlayerAnimationAPI.animations.isEmpty()) {
                this.master = "good_drink";
            } else {
                return;
            }
        }
        if (!this.master.equals("good_drink")) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (entity.getPersistentData().getBoolean("FirstPersonAnimation") && mc.options.getCameraType().isFirstPerson() && entity == mc.player) {
            ((PlayerModel)this.model).head.visible = false;
            ((PlayerModel)this.model).body.visible = false;
            ((PlayerModel)this.model).leftLeg.visible = false;
            ((PlayerModel)this.model).rightLeg.visible = false;
            ((PlayerModel)this.model).rightArm.visible = false;
            ((PlayerModel)this.model).leftArm.visible = false;
            ((PlayerModel)this.model).hat.visible = false;
            ((PlayerModel)this.model).leftSleeve.visible = false;
            ((PlayerModel)this.model).rightSleeve.visible = false;
            ((PlayerModel)this.model).leftPants.visible = false;
            ((PlayerModel)this.model).rightPants.visible = false;
            ((PlayerModel)this.model).jacket.visible = false;
            ((PlayerModel)this.model).rightArm.visible = true;
            ((PlayerModel)this.model).rightSleeve.visible = true;
            ((PlayerModel)this.model).leftArm.visible = true;
            ((PlayerModel)this.model).leftSleeve.visible = true;
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/player/PlayerRenderer;setupRotations(Lnet/minecraft/client/player/AbstractClientPlayer;Lcom/mojang/blaze3d/vertex/PoseStack;FFFF)V"}, at={@At(value="RETURN")})
    private void setupRotations(AbstractClientPlayer player, PoseStack poseStack, float f, float bodyYaw, float deltaTick, float g, CallbackInfo ci) {
        Vec3 rotation;
        Vec3 position;
        if (this.master == null) {
            if (!GoodDrinkModPlayerAnimationAPI.animations.isEmpty()) {
                this.master = "good_drink";
            } else {
                return;
            }
        }
        if (!this.master.equals("good_drink")) {
            return;
        }
        GoodDrinkModPlayerAnimationAPI.PlayerAnimation animation = GoodDrinkModPlayerAnimationAPI.active_animations.get(player);
        if (animation == null) {
            return;
        }
        GoodDrinkModPlayerAnimationAPI.PlayerBone bone = animation.bones.get("body");
        if (bone == null) {
            return;
        }
        float animationProgress = player.getPersistentData().getFloat("PlayerAnimationProgress");
        Vec3 scale = GoodDrinkModPlayerAnimationAPI.PlayerBone.interpolate(bone.scales, animationProgress);
        if (scale != null) {
            poseStack.scale((float)scale.x, (float)scale.y, (float)scale.z);
        }
        if ((position = GoodDrinkModPlayerAnimationAPI.PlayerBone.interpolate(bone.positions, animationProgress)) != null) {
            poseStack.translate((float)(-position.x) * 0.1f, (float)(position.y * (double)0.1f) + 0.7f, (float)position.z * 0.1f);
        }
        if ((rotation = GoodDrinkModPlayerAnimationAPI.PlayerBone.interpolate(bone.rotations, animationProgress)) != null) {
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)rotation.z));
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(-rotation.y)));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)(-rotation.x)));
        }
        if (position != null) {
            poseStack.translate(0.0f, -0.7f, 0.0f);
        }
    }
}

