/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class AdvancementManager {
    private static final Map<ResourceLocation, Advancement> CUSTOM_ADVANCEMENTS = new HashMap<ResourceLocation, Advancement>();

    public static void init(MinecraftServer server) {
        CUSTOM_ADVANCEMENTS.clear();
        AdvancementManager.preload(server, "root");
        AdvancementManager.preload(server, "sacrifice");
        AdvancementManager.preload(server, "impossible");
        AdvancementManager.preload(server, "taste_of_blood");
        AdvancementManager.preload(server, "go_fish");
        AdvancementManager.preload(server, "potato");
        AdvancementManager.preload(server, "c20_5");
        AdvancementManager.preload(server, "fiend");
        AdvancementManager.preload(server, "fiend2");
        AdvancementManager.preload(server, "stratum");
        AdvancementManager.preload(server, "omega12");
        AdvancementManager.preload(server, "no9");
        AdvancementManager.preload(server, "slimeball");
        AdvancementManager.preload(server, "sulfuric");
        AdvancementManager.preload(server, "inferno");
        AdvancementManager.preload(server, "red_room");
        AdvancementManager.preload(server, "hidden");
        AdvancementManager.preload(server, "horizons_start");
        AdvancementManager.preload(server, "horizons_end");
        AdvancementManager.preload(server, "horizons_bonus");
        AdvancementManager.preload(server, "boss_creeper");
        AdvancementManager.preload(server, "boss_meltdown");
        AdvancementManager.preload(server, "boss_mask_man");
        AdvancementManager.preload(server, "boss_worm");
        AdvancementManager.preload(server, "boss_ufo");
        AdvancementManager.preload(server, "rad_poison");
        AdvancementManager.preload(server, "rad_death");
        AdvancementManager.preload(server, "some_wounds");
        AdvancementManager.preload(server, "digamma_see");
        AdvancementManager.preload(server, "digamma_feel");
        AdvancementManager.preload(server, "digamma_know");
        AdvancementManager.preload(server, "digamma_kauai_moho");
        AdvancementManager.preload(server, "digamma_up_on_top");
        AdvancementManager.preload(server, "burner_press");
        AdvancementManager.preload(server, "blast_furnace");
        AdvancementManager.preload(server, "assembly");
        AdvancementManager.preload(server, "selenium");
        AdvancementManager.preload(server, "chem_plant");
        AdvancementManager.preload(server, "concrete");
        AdvancementManager.preload(server, "polymer");
        AdvancementManager.preload(server, "desh");
        AdvancementManager.preload(server, "tantalum");
        AdvancementManager.preload(server, "gas_cent");
        AdvancementManager.preload(server, "centrifuge");
        AdvancementManager.preload(server, "foeq");
        AdvancementManager.preload(server, "soyuz");
        AdvancementManager.preload(server, "space");
        AdvancementManager.preload(server, "schrab");
        AdvancementManager.preload(server, "acidizer");
        AdvancementManager.preload(server, "radium");
        AdvancementManager.preload(server, "technetium");
        AdvancementManager.preload(server, "zirnox_boom");
        AdvancementManager.preload(server, "chicago_pile");
        AdvancementManager.preload(server, "silex");
        AdvancementManager.preload(server, "watz");
        AdvancementManager.preload(server, "watz_boom");
        AdvancementManager.preload(server, "rbmk");
        AdvancementManager.preload(server, "rbmk_boom");
        AdvancementManager.preload(server, "bismuth");
        AdvancementManager.preload(server, "breeding");
        AdvancementManager.preload(server, "fusion");
        AdvancementManager.preload(server, "meltdown");
        AdvancementManager.preload(server, "red_balloons");
        AdvancementManager.preload(server, "manhattan");
    }

    private static void preload(MinecraftServer server, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)path);
        Advancement advancement = server.m_129889_().m_136041_(id);
        if (advancement != null) {
            CUSTOM_ADVANCEMENTS.put(id, advancement);
        } else {
            System.err.println("[AdvancementManager] Could not find advancement: " + String.valueOf(id));
        }
    }

    public static void grant(ServerPlayer player, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)path);
        Advancement advancement = CUSTOM_ADVANCEMENTS.get(id);
        if (advancement == null) {
            System.err.println("[AdvancementManager] Advancement not loaded: " + String.valueOf(id));
            return;
        }
        AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
        if (!progress.m_8193_()) {
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criterion);
            }
        }
    }

    public static boolean hasAdvancement(ServerPlayer player, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)path);
        Advancement advancement = CUSTOM_ADVANCEMENTS.get(id);
        if (advancement == null) {
            return false;
        }
        AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
        return progress.m_8193_();
    }
}

