/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech;

import com.hbm.nucleartech.HBM;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue LOG_DIRT_BLOCK = BUILDER.comment("Whether to log the dirt block on common setup").define("logDirtBlock", true);
    private static final ForgeConfigSpec.IntValue MAGIC_NUMBER = BUILDER.comment("A magic number").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION = BUILDER.comment("What you want the introduction message to be for the magic number").define("magicNumberIntroduction", (Object)"The magic number is... ");
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
    private static final ForgeConfigSpec.IntValue CONCURRENT_CHUNK_THREADS = BUILDER.comment("Number of concurrent threads to use for chunk processing. Set to 0 to use half of available processors.").defineInRange("concurrentChunkThreads", 0, 0, 32);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean logDirtBlock;
    public static int magicNumber;
    public static String magicNumberIntroduction;
    public static Set<Item> items;
    public static int concurrentChunkThreads;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.m_135820_((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
        magicNumber = (Integer)MAGIC_NUMBER.get();
        magicNumberIntroduction = (String)MAGIC_NUMBER_INTRODUCTION.get();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        concurrentChunkThreads = (Integer)CONCURRENT_CHUNK_THREADS.get() > 0 ? (Integer)CONCURRENT_CHUNK_THREADS.get() : Math.max(1, availableProcessors / 2);
        items = ((List)ITEM_STRINGS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)itemName))).collect(Collectors.toSet());
        HBM.LOGGER.info("Config loaded - Using {} concurrent chunk processing threads", (Object)concurrentChunkThreads);
    }
}

