/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech;

import com.hbm.nucleartech.AdvancementManager;
import com.hbm.nucleartech.Config;
import com.hbm.nucleartech.block.RegisterBlocks;
import com.hbm.nucleartech.block.entity.RegisterBlockEntities;
import com.hbm.nucleartech.block.entity.client.BurnerPressRenderer;
import com.hbm.nucleartech.block.entity.client.ShredderRenderer;
import com.hbm.nucleartech.entity.HbmEntities;
import com.hbm.nucleartech.entity.client.NuclearCreeperRenderer;
import com.hbm.nucleartech.handler.HazmatRegistry;
import com.hbm.nucleartech.handler.RadiationSystemNT;
import com.hbm.nucleartech.item.RegisterCreativeTabs;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.item.custom.GeigerCounterItem;
import com.hbm.nucleartech.network.HbmPacketHandler;
import com.hbm.nucleartech.particle.RegisterParticles;
import com.hbm.nucleartech.recipe.RegisterRecipes;
import com.hbm.nucleartech.screen.BurnerPressScreen;
import com.hbm.nucleartech.screen.RegisterMenuTypes;
import com.hbm.nucleartech.screen.ShredderScreen;
import com.hbm.nucleartech.sound.RegisterSounds;
import com.hbm.nucleartech.util.ArmorUtil;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="hbm")
public class HBM {
    public static final String MOD_ID = "hbm";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static File configDir;
    public static File configHbmDir;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER;
    private static int messageID;
    private static final RandomSource RANDOM;

    public HBM() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        GeckoLib.initialize();
        RegisterCreativeTabs.register(modEventBus);
        RegisterItems.register(modEventBus);
        RegisterBlocks.register(modEventBus);
        RegisterParticles.register(modEventBus);
        HbmEntities.register(modEventBus);
        RegisterBlockEntities.register(modEventBus);
        RegisterMenuTypes.register(modEventBus);
        RegisterRecipes.register(modEventBus);
        RegisterSounds.SOUNDS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        configDir = FMLPaths.CONFIGDIR.get().toFile();
        configHbmDir = new File(configDir.getAbsolutePath() + File.separatorChar + "hbmConfig");
        if (!configHbmDir.exists()) {
            configHbmDir.mkdir();
        }
        HbmPacketHandler.register();
        HazmatRegistry.registerHazmats();
        ArmorUtil.register();
        GeigerCounterItem.initSoundMap();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        AdvancementManager.init(event.getServer());
        RadiationSystemNT.init(event.getServer());
    }

    public static int random(int min, int max) {
        return RANDOM.m_188503_(max - min + 1) + min;
    }

    static {
        PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)MOD_ID), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        messageID = 0;
        RANDOM = RandomSource.m_216327_();
    }

    @Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)HbmEntities.NUCLEAR_CREEPER.get()), NuclearCreeperRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)RegisterBlockEntities.BURNER_PRESS_ENTITY.get()), BurnerPressRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)RegisterBlockEntities.SHREDDER_ENTITY.get()), ShredderRenderer::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RegisterMenuTypes.BURNER_PRESS_MENU.get()), BurnerPressScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RegisterMenuTypes.SHREDDER_MENU.get()), ShredderScreen::new);
        }
    }
}

