/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.block.entity;

import com.hbm.nucleartech.block.entity.RegisterBlockEntities;
import com.hbm.nucleartech.item.custom.base.StampItem;
import com.hbm.nucleartech.network.HbmPacketHandler;
import com.hbm.nucleartech.network.packet.ClientboundBurnerPressPacket;
import com.hbm.nucleartech.recipe.PressRecipe;
import com.hbm.nucleartech.screen.BurnerPressMenu;
import com.hbm.nucleartech.sound.RegisterSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class BurnerPressEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider {
    public static final String STAMP_ANIM = "animation.burner_press.stamp";
    public static final String LIFT_ANIM = "animation.burner_press.lift";
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public Player lastInteractedPlayer = null;
    public ItemStack lastInteractedPlayerHeldItem = null;
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, null) == 0) {
                return false;
            }
            if (slot == 1 && !(stack.m_41720_() instanceof StampItem)) {
                return false;
            }
            if (slot == 3) {
                return false;
            }
            return slot != LOCKED_SLOT && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == LOCKED_SLOT) {
                return ItemStack.f_41583_;
            }
            BurnerPressEntity.this.m_6596_();
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == LOCKED_SLOT) {
                return stack;
            }
            if (slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, null) == 0) {
                return stack;
            }
            if (slot == 1 && !(stack.m_41720_() instanceof StampItem)) {
                return stack;
            }
            if (slot == 3) {
                return stack;
            }
            BurnerPressEntity.this.m_6596_();
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BurnerPressEntity.this.m_6596_();
        }
    };
    private static final int FUEL_SLOT = 0;
    private static final int STAMP_SLOT = 1;
    private static final int INPUT_SLOT = 2;
    private static final int OUTPUT_SLOT = 3;
    private static int LOCKED_SLOT = -1;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    public int progress = 0;
    public int maxProgress = 80;
    public static final int staticMaxProgress = 80;
    public int heat = 0;
    public int maxHeat = 7200;
    public float speedMod = 1.0f;
    public float displaySpeed = 1.0f;
    public int fuel = 0;
    public int maxFuel = 0;
    public boolean stamping = false;
    public boolean stamped = false;
    private ItemStack displayStack = ItemStack.f_41583_;

    public BurnerPressEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegisterBlockEntities.BURNER_PRESS_ENTITY.get(), pPos, pBlockState);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> BurnerPressEntity.this.progress;
                    case 1 -> BurnerPressEntity.this.maxProgress;
                    case 2 -> BurnerPressEntity.this.heat;
                    case 3 -> BurnerPressEntity.this.maxHeat;
                    case 4 -> BurnerPressEntity.this.fuel;
                    case 5 -> BurnerPressEntity.this.maxFuel;
                    case 6 -> (int)BurnerPressEntity.this.speedMod;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        BurnerPressEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        BurnerPressEntity.this.maxProgress = pValue;
                        break;
                    }
                    case 2: {
                        BurnerPressEntity.this.heat = pValue;
                        break;
                    }
                    case 3: {
                        BurnerPressEntity.this.maxHeat = pValue;
                        break;
                    }
                    case 4: {
                        BurnerPressEntity.this.fuel = pValue;
                        break;
                    }
                    case 5: {
                        BurnerPressEntity.this.maxFuel = pValue;
                        break;
                    }
                    case 6: {
                        BurnerPressEntity.this.speedMod = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 7;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.hbm.burner_press");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new BurnerPressMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("burner_press.progress", this.progress);
        pTag.m_128405_("burner_press.max_progress", this.maxProgress);
        pTag.m_128405_("burner_press.heat", this.heat);
        pTag.m_128405_("burner_press.max_heat", this.maxHeat);
        pTag.m_128405_("burner_press.fuel", this.fuel);
        pTag.m_128405_("burner_press.max_fuel", this.maxFuel);
        pTag.m_128350_("burner_press.speed_mod", this.speedMod);
        pTag.m_128350_("burner_press.display_speed", this.displaySpeed);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("burner_press.progress");
        this.maxProgress = pTag.m_128451_("burner_press.max_progress");
        this.heat = pTag.m_128451_("burner_press.heat");
        this.maxHeat = pTag.m_128451_("burner_press.max_heat");
        this.fuel = pTag.m_128451_("burner_press.fuel");
        this.maxFuel = pTag.m_128451_("burner_press.max_fuel");
        this.speedMod = pTag.m_128457_("burner_press.speed_mod");
        this.displaySpeed = pTag.m_128457_("burner_press.display_speed");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "stamp_c", 0, state -> {
            BlockEntity e = (BlockEntity)state.getData(DataTickets.BLOCK_ENTITY);
            if (e instanceof BurnerPressEntity) {
                BurnerPressEntity burnerPress = (BurnerPressEntity)e;
                float targetSpeed = burnerPress.speedMod;
                float lerpFactor = 0.5f;
                float oldDS = burnerPress.displaySpeed;
                float diff = oldDS - targetSpeed;
                if (Mth.m_14154_((float)diff) > 0.25f) {
                    targetSpeed = diff >= 0.0f ? oldDS - 0.25f : oldDS + 0.25f;
                }
                burnerPress.displaySpeed = this.simpleLerp(lerpFactor, oldDS, targetSpeed);
                if (Mth.m_14154_((float)diff) < 0.5f) {
                    burnerPress.displaySpeed = targetSpeed;
                }
                if (burnerPress.stamping && !burnerPress.stamped) {
                    state.setAnimation(RawAnimation.begin().thenPlay(STAMP_ANIM));
                } else {
                    state.setAnimation(RawAnimation.begin().thenPlay(LIFT_ANIM));
                }
                state.setControllerSpeed(burnerPress.displaySpeed);
                if (burnerPress.displaySpeed == 1.0f) {
                    return PlayState.STOP;
                }
                return PlayState.CONTINUE;
            }
            System.err.println("not correct entity");
            return PlayState.STOP;
        })});
    }

    float simpleLerp(float factor, float start, float end) {
        return start + (end - start) * factor;
    }

    float seekDecimal(float input) {
        return input - (float)((int)input);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 3, 1));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.hasEnergy()) {
            this.incrementHeat();
        } else if (this.hasFuel()) {
            this.consumeFuel();
        } else {
            this.decrementHeat();
        }
        this.updateSpeedModifier();
        this.lockInputSlot(this.hasRecipe() && this.hasHeat() && this.hasUsableStamp());
        this.placeInputModelOnPress();
        if (this.hasRecipe() && this.inSolidProgress() && this.hasUsableStamp() && this.hasHeat()) {
            this.increaseProgress();
            this.stamping = true;
            if (!this.inSolidProgress()) {
                this.stamped = true;
                this.lockInputSlot(false);
                this.m_58904_().m_5594_(null, this.f_58858_, (SoundEvent)RegisterSounds.PRESS_OPERATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.craftItem();
                this.damageStamp(pPos);
                this.lockInputSlot(this.hasRecipe() && this.hasHeat() && this.hasUsableStamp());
            }
        } else if (this.hasRecipe() && !this.inSolidProgress() && this.hasHeat()) {
            this.increaseProgress();
            this.stamping = true;
            if (this.hasProgressFinished()) {
                this.resetProgress(false);
            }
        } else {
            this.resetProgress(true);
        }
        ClientboundBurnerPressPacket packet = new ClientboundBurnerPressPacket(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_(), this.stamping, this.progress, this.maxProgress, this.heat, this.maxHeat, this.fuel, this.maxFuel, this.speedMod, this.stamped, this.displayStack);
        HbmPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(pPos)), (Object)packet);
        BurnerPressEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void placeInputModelOnPress() {
        ItemStack input = this.itemHandler.getStackInSlot(2);
        if (!input.m_41619_()) {
            this.displayStack = input.m_41777_();
            this.displayStack.m_41764_(1);
        } else {
            this.displayStack = ItemStack.f_41583_;
        }
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public void setDisplayStack(ItemStack stack) {
        this.displayStack = stack;
    }

    private void updateSpeedModifier() {
        this.speedMod = (float)(this.getHeatGaugeProgress() - 1) / 2.5f;
        if (!(this.hasRecipe() && this.hasUsableStamp() && this.hasHeat())) {
            this.speedMod = 1.0f;
        }
        this.speedMod = Mth.m_14036_((float)this.speedMod, (float)1.0f, (float)4.4f);
        this.maxProgress = (int)Mth.m_14036_((float)(80.0f / this.speedMod), (float)0.0f, (float)80.0f);
    }

    private void damageStamp(BlockPos pos) {
        ItemStack stack = this.itemHandler.getStackInSlot(1);
        stack.m_220157_(1, this.f_58857_.f_46441_, null);
        if (stack.m_41773_() >= stack.m_41776_()) {
            this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean hasUsableStamp() {
        boolean result = this.itemHandler.getStackInSlot(1).m_41720_() instanceof StampItem;
        return result;
    }

    private void resetProgress(boolean lerp) {
        if (lerp) {
            this.progress = (int)Mth.m_14179_((float)0.05f, (float)this.progress, (float)0.0f);
            this.progress = (float)this.progress <= 1.0f ? 0 : this.progress;
        } else {
            this.progress = 0;
        }
        this.stamping = false;
        this.stamped = false;
    }

    private void craftItem() {
        Optional<PressRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.itemHandler.extractItem(2, 1, false);
        this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(3).m_41613_() + result.m_41613_()));
    }

    private boolean hasProgressFinished() {
        boolean result = this.progress >= this.maxProgress;
        return result;
    }

    private void increaseProgress() {
        ++this.progress;
    }

    private void lockInputSlot(boolean lock) {
        LOCKED_SLOT = lock ? 2 : -1;
    }

    private boolean inSolidProgress() {
        boolean result = (float)this.progress <= (float)this.maxProgress / 2.0f;
        return result;
    }

    private boolean hasRecipe() {
        Optional<PressRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(null);
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<PressRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)PressRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        boolean result = this.itemHandler.getStackInSlot(3).m_41619_() || this.itemHandler.getStackInSlot(3).m_150930_(item);
        return result;
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        boolean result = this.itemHandler.getStackInSlot(3).m_41613_() + count <= this.itemHandler.getStackInSlot(3).m_41741_();
        return result;
    }

    private void decrementHeat() {
        this.heat -= 14;
        this.heat = Mth.m_14045_((int)this.heat, (int)0, (int)this.maxHeat);
    }

    private void consumeFuel() {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        this.itemHandler.extractItem(0, 1, false);
        this.fuel = ForgeHooks.getBurnTime((ItemStack)item, null);
        this.maxFuel = ForgeHooks.getBurnTime((ItemStack)item, null);
    }

    private boolean hasFuel() {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        boolean hasFuel = ForgeHooks.getBurnTime((ItemStack)item, null) != 0;
        return hasFuel;
    }

    private void incrementHeat() {
        this.heat += 14;
        this.fuel -= 10;
        this.heat = Mth.m_14045_((int)this.heat, (int)0, (int)this.maxHeat);
        this.fuel = Mth.m_14045_((int)this.fuel, (int)0, (int)Integer.MAX_VALUE);
    }

    private boolean hasEnergy() {
        return this.fuel > 0;
    }

    private boolean hasHeat() {
        boolean result = this.getHeatGaugeProgress() >= 4;
        return result;
    }

    private int getHeatGaugeProgress() {
        int idxSize = 12;
        if (this.heat <= 0 || this.maxHeat <= 0) {
            return 0;
        }
        return this.heat * idxSize / this.maxHeat;
    }
}

