/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.block.entity;

import com.hbm.nucleartech.HBM;
import com.hbm.nucleartech.block.custom.base.BaseHbmBlockEntity;
import com.hbm.nucleartech.block.entity.RegisterBlockEntities;
import com.hbm.nucleartech.capability.HbmCapabilities;
import com.hbm.nucleartech.capability.energy.WattHourStorage;
import com.hbm.nucleartech.datagen.ModRecipeProvider;
import com.hbm.nucleartech.interfaces.IEnergyItem;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.item.custom.BatteryItem;
import com.hbm.nucleartech.item.custom.BladeItem;
import com.hbm.nucleartech.item.custom.SelfChargingBatteryItem;
import com.hbm.nucleartech.network.HbmPacketHandler;
import com.hbm.nucleartech.network.packet.ClientboundShredderPacket;
import com.hbm.nucleartech.recipe.ShredderRecipe;
import com.hbm.nucleartech.screen.ShredderMenu;
import com.hbm.nucleartech.sound.RegisterSounds;
import com.hbm.nucleartech.util.FloatingLong;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ShredderEntity
extends BaseHbmBlockEntity
implements GeoBlockEntity,
MenuProvider {
    public static final String ANIM = "animation.shredder.";
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final ItemStackHandler itemHandler = new ItemStackHandler(30){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (!(slot != 0 || ShredderEntity.isEnergyItem(stack) && ShredderEntity.canExtract(stack))) {
                return false;
            }
            if (slot == 1 && !(stack.m_41720_() instanceof BladeItem)) {
                return false;
            }
            if (slot == 2 && !(stack.m_41720_() instanceof BladeItem)) {
                return false;
            }
            for (int oS : OUTPUT_SLOT) {
                if (slot != oS) continue;
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ShredderEntity.this.m_6596_();
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!(slot != 0 || ShredderEntity.isEnergyItem(stack) && ShredderEntity.canExtract(stack))) {
                return stack;
            }
            if (slot == 1 && !(stack.m_41720_() instanceof BladeItem)) {
                return stack;
            }
            if (slot == 2 && !(stack.m_41720_() instanceof BladeItem)) {
                return stack;
            }
            for (int oS : OUTPUT_SLOT) {
                if (slot != oS) continue;
                return stack;
            }
            ShredderEntity.this.m_6596_();
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ShredderEntity.this.m_6596_();
        }
    };
    private static final int POWER_SLOT = 0;
    private static final int LEFT_BLADE_SLOT = 1;
    private static final int RIGHT_BLADE_SLOT = 2;
    private static final int[] INPUT_SLOT = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] OUTPUT_SLOT = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    public int progress = 0;
    public int soundProgress = 0;
    public int maxProgress = 60;
    public FloatingLong currentPowerConsumption = FloatingLong.ZERO;
    public int scaledEnergyProgress = 0;
    public boolean shred = false;
    public int leftBIdx = 0;
    public int rightBIdx = 0;
    public int leftDur = 0;
    public int rightDur = 0;
    public int leftMaxDur = 0;
    public int rightMaxDur = 0;
    public FloatingLong storedWattHoursClient = FloatingLong.ZERO;

    public ShredderEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegisterBlockEntities.SHREDDER_ENTITY.get(), pPos, pBlockState, FloatingLong.create(5000.0), FloatingLong.create(100.0).multiply(3.6), FloatingLong.create(1000.0).multiply(3.6), FloatingLong.ZERO);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> ShredderEntity.this.progress;
                    case 1 -> ShredderEntity.this.scaledEnergyProgress;
                    case 2 -> ShredderEntity.this.leftDur;
                    case 3 -> ShredderEntity.this.rightDur;
                    case 4 -> ShredderEntity.this.leftMaxDur;
                    case 5 -> ShredderEntity.this.rightMaxDur;
                    case 6 -> ShredderEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        ShredderEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        ShredderEntity.this.scaledEnergyProgress = pValue;
                        break;
                    }
                    case 2: {
                        ShredderEntity.this.leftDur = pValue;
                        break;
                    }
                    case 3: {
                        ShredderEntity.this.rightDur = pValue;
                        break;
                    }
                    case 4: {
                        ShredderEntity.this.leftMaxDur = pValue;
                        break;
                    }
                    case 5: {
                        ShredderEntity.this.rightMaxDur = pValue;
                        break;
                    }
                    case 6: {
                        ShredderEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 7;
            }
        };
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.hbm.shredder");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ShredderMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("shredder.progress", this.progress);
        pTag.m_128405_("shredder.scaled_energy", this.scaledEnergyProgress);
        pTag.m_128379_("shredder.shred", this.shred);
        pTag.m_128405_("shredder.left_b_idx", this.leftBIdx);
        pTag.m_128405_("shredder.right_b_idx", this.rightBIdx);
        pTag.m_128405_("shredder.left_dur", this.leftDur);
        pTag.m_128405_("shredder.right_dur", this.rightDur);
        pTag.m_128405_("shredder.left_max_dur", this.leftMaxDur);
        pTag.m_128405_("shredder.right_max_dur", this.rightMaxDur);
        pTag.m_128405_("shredder.max_progress", this.maxProgress);
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("shredder.progress");
        this.scaledEnergyProgress = pTag.m_128451_("shredder.scaled_energy");
        this.shred = pTag.m_128471_("shredder.shred");
        this.leftBIdx = pTag.m_128451_("shredder.left_b_idx");
        this.rightBIdx = pTag.m_128451_("shredder.right_b_idx");
        this.leftDur = pTag.m_128451_("shredder.left_dur");
        this.rightDur = pTag.m_128451_("shredder.right_dur");
        this.leftMaxDur = pTag.m_128451_("shredder.left_max_dur");
        this.rightMaxDur = pTag.m_128451_("shredder.right_max_dur");
        this.maxProgress = pTag.m_128451_("shredder.max_progress");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shred_c", 0, state -> {
            BlockEntity e = (BlockEntity)state.getData(DataTickets.BLOCK_ENTITY);
            if (e instanceof ShredderEntity) {
                ShredderEntity shredder = (ShredderEntity)e;
                state.setAnimation(RawAnimation.begin().thenLoop(ANIM + shredder.leftBIdx + shredder.rightBIdx));
                state.setControllerSpeed(shredder.shred ? 1.0f : 0.0f);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        int n;
        int n2;
        BladeItem bladeItem;
        Item item;
        if (this.canConsumePower() && this.hasPower()) {
            this.consumePower();
        }
        boolean check = this.hasBlades();
        if (this.hasItems() && this.hasEnergy() && check) {
            if (!this.hasProgressFinished() && this.progress == 0) {
                this.soundProgress = 0;
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)RegisterSounds.SHREDDER_OPERATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.increaseSoundProgress();
            this.increaseProgress();
            this.consumeEnergy();
            this.shred = true;
            if (this.hasProgressFinished()) {
                this.craftItems();
                this.damageBlades(this.f_58858_);
                this.resetProgress(false);
            }
        } else {
            this.increaseSoundProgress();
            this.resetProgress(true);
        }
        if ((item = this.itemHandler.getStackInSlot(1).m_41720_()) instanceof BladeItem) {
            bladeItem = (BladeItem)item;
            n2 = bladeItem.getIdx();
        } else {
            n2 = 0;
        }
        this.leftBIdx = n2;
        item = this.itemHandler.getStackInSlot(2).m_41720_();
        if (item instanceof BladeItem) {
            bladeItem = (BladeItem)item;
            n = bladeItem.getIdx();
        } else {
            n = 0;
        }
        this.rightBIdx = n;
        ClientboundShredderPacket packet = new ClientboundShredderPacket(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_(), this.leftBIdx, this.rightBIdx, this.shred, this.leftDur, this.leftMaxDur, this.rightDur, this.rightMaxDur, this.getEnergy(), this.currentPowerConsumption);
        HbmPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(pPos)), (Object)packet);
        this.updateScaledEnergyProgress();
        ShredderEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void increaseSoundProgress() {
        ++this.soundProgress;
        if (this.soundProgress > 120) {
            this.shred = false;
            this.soundProgress = 0;
        }
    }

    private void updateScaledEnergyProgress() {
        FloatingLong energy = this.getEnergy();
        FloatingLong maxEnergy = this.getMaxEnergy();
        FloatingLong size = FloatingLong.create(88.0);
        this.scaledEnergyProgress = energy.compareTo(FloatingLong.ZERO) <= 0 ? 0 : size.divide(maxEnergy).multiply(energy).intValue();
    }

    private void damageBlades(BlockPos pos) {
        ItemStack left = this.itemHandler.getStackInSlot(1);
        ItemStack right = this.itemHandler.getStackInSlot(2);
        left.m_220157_(1, this.f_58857_.f_46441_, null);
        right.m_220157_(1, this.f_58857_.f_46441_, null);
        if (left.m_41773_() >= left.m_41776_() && !left.m_41720_().equals(RegisterItems.DESH_BLADE.get())) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (right.m_41773_() >= right.m_41776_() && !right.m_41720_().equals(RegisterItems.DESH_BLADE.get())) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.leftDur = left.m_41720_().equals(RegisterItems.DESH_BLADE.get()) ? -2 : left.m_41773_();
        this.rightDur = right.m_41720_().equals(RegisterItems.DESH_BLADE.get()) ? -2 : right.m_41773_();
    }

    private boolean hasBlades() {
        ItemStack leftStack = this.itemHandler.getStackInSlot(1);
        ItemStack rightStack = this.itemHandler.getStackInSlot(2);
        boolean leftBladeExists = leftStack.m_41720_() instanceof BladeItem;
        boolean rightBladeExists = rightStack.m_41720_() instanceof BladeItem;
        boolean leftIsDesh = leftBladeExists && leftStack.m_41720_().equals(RegisterItems.DESH_BLADE.get());
        boolean rightIsDesh = rightBladeExists && rightStack.m_41720_().equals(RegisterItems.DESH_BLADE.get());
        boolean leftBladeIsBroken = false;
        boolean rightBladeIsBroken = false;
        if (leftBladeExists) {
            this.leftDur = leftStack.m_41773_();
            this.leftMaxDur = leftStack.m_41776_();
            leftBladeIsBroken = this.leftDur >= this.leftMaxDur;
        } else {
            this.leftDur = -1;
            this.leftMaxDur = 0;
        }
        if (rightBladeExists) {
            this.rightDur = rightStack.m_41773_();
            this.rightMaxDur = rightStack.m_41776_();
            rightBladeIsBroken = this.rightDur >= this.rightMaxDur;
        } else {
            this.rightDur = -1;
            this.rightMaxDur = 0;
        }
        this.leftDur = leftIsDesh ? -2 : this.leftDur;
        this.rightDur = rightIsDesh ? -2 : this.rightDur;
        boolean result = !(!leftBladeExists || leftBladeIsBroken && !leftIsDesh || !rightBladeExists || rightBladeIsBroken && !rightIsDesh);
        return result;
    }

    private void resetProgress(boolean resetPower) {
        this.progress = 0;
        if (resetPower) {
            this.currentPowerConsumption = FloatingLong.ZERO;
        }
    }

    private void craftItems() {
        for (int i = 0; i < INPUT_SLOT.length; ++i) {
            this.craftItem(i);
        }
    }

    private void craftItem(int slot) {
        ModRecipeProvider.MetaData md;
        ItemStack input = this.itemHandler.getStackInSlot(INPUT_SLOT[slot]);
        if (input.m_41619_()) {
            return;
        }
        Optional<ShredderRecipe> recipe = this.getRecipe(INPUT_SLOT[slot]);
        NonNullList results = recipe.isPresent() ? recipe.get().getResults() : NonNullList.m_122780_((int)1, (Object)Pair.of((Object)((Item)RegisterItems.PLACEHOLDER.get()), (Object)new ModRecipeProvider.MetaData(1, 1, 100)));
        boolean skippedImportantResult = false;
        for (Pair result : results) {
            ItemStack checkStack;
            md = (ModRecipeProvider.MetaData)result.right();
            if (md == null || md.getChance() != 100 || md.getMinCount() <= 0 || this.findSlot(checkStack = new ItemStack((ItemLike)result.left(), md.getMaxCount())) != -1) continue;
            skippedImportantResult = true;
            break;
        }
        if (skippedImportantResult) {
            return;
        }
        this.itemHandler.extractItem(INPUT_SLOT[slot], 1, false);
        for (Pair result : results) {
            ItemStack stack;
            int outSlot;
            int maxC;
            int minC;
            int produced;
            md = (ModRecipeProvider.MetaData)result.right();
            if (md == null || HBM.random(1, 100) > md.getChance() || (produced = (minC = Math.max(0, md.getMinCount())) == (maxC = Math.max(minC, md.getMaxCount())) ? minC : HBM.random(minC, maxC)) <= 0 || (outSlot = this.findSlot(stack = new ItemStack((ItemLike)result.left(), produced))) == -1) continue;
            ItemStack existing = this.itemHandler.getStackInSlot(outSlot);
            this.itemHandler.setStackInSlot(outSlot, new ItemStack((ItemLike)stack.m_41720_(), existing.m_41613_() + stack.m_41613_()));
        }
    }

    private int findSlot(ItemStack check) {
        for (int slot : OUTPUT_SLOT) {
            if (!this.canInsertAmountIntoOutputSlot(check.m_41613_(), slot) || !this.canInsertItemIntoOutputSlot(check.m_41720_(), slot)) continue;
            return slot;
        }
        return -1;
    }

    private boolean hasProgressFinished() {
        boolean result = this.progress >= this.maxProgress;
        return result;
    }

    private void increaseProgress() {
        ++this.progress;
    }

    private boolean hasItems() {
        int DEFAULT_TICKS = 120;
        FloatingLong DEFAULT_POWER = FloatingLong.create(1.0);
        int maxTicksFound = 0;
        FloatingLong maxPowerFound = FloatingLong.ZERO;
        ArrayList<Integer> nonEmptyInputs = new ArrayList<Integer>(INPUT_SLOT.length);
        for (int slot : INPUT_SLOT) {
            if (this.itemHandler.getStackInSlot(slot).m_41619_()) continue;
            nonEmptyInputs.add(slot);
        }
        Object object = nonEmptyInputs.iterator();
        while (object.hasNext()) {
            int slot = (Integer)object.next();
            Optional<ShredderRecipe> recipeOpt = this.getRecipe(slot);
            if (!recipeOpt.isPresent()) continue;
            ShredderRecipe recipe = recipeOpt.get();
            maxTicksFound = Math.max(maxTicksFound, recipe.getTicks());
            maxPowerFound = WattHourStorage.Max(maxPowerFound, recipe.getPowerConsumption());
        }
        if (maxTicksFound == 0) {
            maxTicksFound = 120;
        }
        if (maxPowerFound.compareTo(FloatingLong.ZERO) <= 0) {
            maxPowerFound = DEFAULT_POWER;
        }
        boolean foundAnyFit = false;
        int outSlots = OUTPUT_SLOT.length;
        Iterator iterator = nonEmptyInputs.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            Optional<ShredderRecipe> recipeOpt = this.getRecipe(slot);
            NonNullList results = recipeOpt.isPresent() ? recipeOpt.get().getResults() : NonNullList.m_122780_((int)1, (Object)Pair.of((Object)((Item)RegisterItems.PLACEHOLDER.get()), (Object)new ModRecipeProvider.MetaData(1, 1, 100)));
            HashMap<Item, Integer> wantedCounts = new HashMap<Item, Integer>();
            for (Pair r : results) {
                int want;
                ModRecipeProvider.MetaData md = (ModRecipeProvider.MetaData)r.right();
                if (md == null || md.getChance() < 100 || md.getMinCount() <= 0 || (want = md.getMaxCount()) <= 0) continue;
                wantedCounts.merge((Item)r.left(), want, Integer::sum);
            }
            if (wantedCounts.isEmpty()) {
                foundAnyFit = true;
                break;
            }
            Item[] slotItem = new Item[outSlots];
            int[] slotFree = new int[outSlots];
            for (int i = 0; i < outSlots; ++i) {
                int outIdx = OUTPUT_SLOT[i];
                ItemStack s = this.itemHandler.getStackInSlot(outIdx);
                if (s.m_41619_()) {
                    slotItem[i] = null;
                    slotFree[i] = 0;
                    continue;
                }
                slotItem[i] = s.m_41720_();
                slotFree[i] = s.m_41741_() - s.m_41613_();
            }
            boolean allFit = true;
            for (Map.Entry e : wantedCounts.entrySet()) {
                Item wantItem = (Item)e.getKey();
                int remain = (Integer)e.getValue();
                for (int i = 0; i < outSlots && remain > 0; ++i) {
                    if (slotItem[i] == null || !slotItem[i].equals(wantItem)) continue;
                    int used = Math.min(slotFree[i], remain);
                    int n = i;
                    slotFree[n] = slotFree[n] - used;
                    remain -= used;
                }
                int wantMax = new ItemStack((ItemLike)wantItem).m_41741_();
                for (int i = 0; i < outSlots && remain > 0; ++i) {
                    if (slotItem[i] != null) continue;
                    int used = Math.min(wantMax, remain);
                    slotItem[i] = wantItem;
                    slotFree[i] = wantMax - used;
                    remain -= used;
                }
                if (remain <= 0) continue;
                allFit = false;
                break;
            }
            if (!allFit) continue;
            foundAnyFit = true;
            break;
        }
        this.maxProgress = maxTicksFound;
        this.currentPowerConsumption = maxPowerFound;
        return foundAnyFit;
    }

    private Optional<ShredderRecipe> getRecipe(int slot) {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, this.itemHandler.getStackInSlot(slot));
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ShredderRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item, int idx) {
        boolean result = this.itemHandler.getStackInSlot(idx).m_41619_() || this.itemHandler.getStackInSlot(idx).m_150930_(item);
        return result;
    }

    private boolean canInsertAmountIntoOutputSlot(int count, int idx) {
        boolean result = this.itemHandler.getStackInSlot(idx).m_41613_() + count <= this.itemHandler.getStackInSlot(idx).m_41741_();
        return result;
    }

    private boolean canConsumePower() {
        return this.getEnergy().compareTo(this.getMaxEnergy()) < 0;
    }

    @Override
    public String formatWattHoursStored() {
        int unitIndex;
        FloatingLong value = this.storedWattHoursClient;
        if (value.compareTo(FloatingLong.create(1000)) < 0) {
            return String.format("%.1f", Float.valueOf(value.floatValue())) + "Wh";
        }
        String[] units = new String[]{"Wh", "kWh", "MWh", "GWh", "TWh", "PWh", "EWh", "ZWh", "YWh", "RWh", "QWh", "?Wh"};
        for (unitIndex = 0; value.compareTo(FloatingLong.create(1000)) >= 0 && unitIndex < units.length - 1; ++unitIndex) {
            value = value.divide(1000.0);
        }
        String formatted = String.format("%.1f", Float.valueOf(value.floatValue()));
        return formatted + units[unitIndex];
    }

    @Override
    public String formatWattsDischarge() {
        int unitIndex;
        FloatingLong value = WattHourStorage.translateWattHours(this.currentPowerConsumption);
        if (value.compareTo(FloatingLong.create(1000)) < 0) {
            return String.format("%.1f", Float.valueOf(value.floatValue())) + "W";
        }
        String[] units = new String[]{"W", "kW", "MW", "GW", "TW", "PW", "EW", "ZW", "YW", "RW", "QW", "?W"};
        for (unitIndex = 0; value.compareTo(FloatingLong.create(1000)) >= 0 && unitIndex < units.length - 1; ++unitIndex) {
            value = value.divide(1000.0);
        }
        String formatted = String.format("%.1f", Float.valueOf(value.floatValue()));
        return formatted + units[unitIndex];
    }

    private void consumePower() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!ShredderEntity.isEnergyItem(stack) || !ShredderEntity.canExtract(stack)) {
            return;
        }
        if (ShredderEntity.isBatteryItem(stack) || ShredderEntity.isSelfChargingBatteryItem(stack)) {
            FloatingLong canExtractAmount = ShredderEntity.drainEnergy(stack, FloatingLong.create(String.format("%e", Double.MAX_VALUE)), true);
            FloatingLong wouldAccept = this.insertEnergy(canExtractAmount, true);
            FloatingLong actuallyInserted = this.insertEnergy(wouldAccept, false);
            FloatingLong actuallyDrained = ShredderEntity.drainEnergy(stack, actuallyInserted, false);
            System.err.println("consumePower: canExtract=" + String.valueOf(canExtractAmount) + " wouldAccept=" + String.valueOf(wouldAccept) + " inserted=" + String.valueOf(actuallyInserted) + " drained=" + String.valueOf(actuallyDrained) + " storedEnergy=" + String.valueOf(this.getEnergy()));
        } else if (ShredderEntity.isEnergyItem(stack)) {
            FloatingLong canExtractAmountFE = ShredderEntity.drainEnergy(stack, FloatingLong.create(String.format("%e", Double.MAX_VALUE)), true);
            FloatingLong canExtractAmountWh = canExtractAmountFE.divide(WATT_HOUR_TO_FE);
            FloatingLong wouldAcceptWh = this.insertEnergy(canExtractAmountWh, true);
            FloatingLong actuallyInsertedWh = this.insertEnergy(wouldAcceptWh, false);
            FloatingLong actuallyInsertedFE = actuallyInsertedWh.multiply(WATT_HOUR_TO_FE);
            FloatingLong wouldDrainFE = ShredderEntity.drainEnergy(stack, actuallyInsertedFE, true);
            FloatingLong actuallyDrainedFE = ShredderEntity.drainEnergy(stack, wouldDrainFE, false);
            System.err.println("consumePower: canExtractFE=" + String.valueOf(canExtractAmountFE) + " canExtractWh=" + String.valueOf(canExtractAmountWh) + " wouldAcceptWh=" + String.valueOf(wouldAcceptWh) + " insertedWh=" + String.valueOf(actuallyInsertedWh) + " insertedFE=" + String.valueOf(actuallyInsertedFE) + " wouldDrainFE=" + String.valueOf(wouldDrainFE) + " drainedFE=" + String.valueOf(actuallyDrainedFE) + " storedEnergyWh=" + String.valueOf(this.getEnergy()));
        }
        this.updatePowerSlot();
    }

    private void updatePowerSlot() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_41619_()) {
            return;
        }
        stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).ifPresent(cap -> {
            CompoundTag capTag = new CompoundTag();
            capTag.m_128359_("Stored", cap.getWattageStored().toString());
            stack.m_41784_().m_128365_("WattHourStorage", (Tag)capTag);
        });
        this.itemHandler.setStackInSlot(0, stack.m_41777_());
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    private boolean hasPower() {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        boolean hasPower = ShredderEntity.isEnergyItem(item) && ShredderEntity.canExtract(item);
        return hasPower;
    }

    public static boolean isEnergyItem(ItemStack stack) {
        return stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).isPresent() || stack.m_41720_() instanceof IEnergyItem || stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static boolean isBatteryItem(ItemStack stack) {
        return stack.m_41720_() instanceof BatteryItem;
    }

    public static boolean isSelfChargingBatteryItem(ItemStack stack) {
        return stack.m_41720_() instanceof SelfChargingBatteryItem;
    }

    public static FloatingLong drainEnergy(ItemStack stack, FloatingLong amount, boolean simulate) {
        if (ShredderEntity.isBatteryItem(stack)) {
            return BatteryItem.removeEnergy(stack, amount, simulate);
        }
        if (ShredderEntity.isSelfChargingBatteryItem(stack)) {
            return ((SelfChargingBatteryItem)stack.m_41720_()).getDischargeRate() != Double.POSITIVE_INFINITY ? FloatingLong.create(((SelfChargingBatteryItem)stack.m_41720_()).getDischargeRate()) : FloatingLong.create(String.format("%e", Double.MAX_VALUE));
        }
        if (stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            AtomicInteger extracted = new AtomicInteger(0);
            stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
                try {
                    int toExtract = Math.max(0, amount.intValue());
                    extracted.set(cap.extractEnergy(toExtract, simulate));
                }
                catch (Exception e) {
                    extracted.set(cap.extractEnergy(Integer.MAX_VALUE, simulate));
                }
            });
            FloatingLong atomicToFloatingLong = FloatingLong.create(extracted.get());
            return atomicToFloatingLong;
        }
        return FloatingLong.ZERO;
    }

    public static boolean canExtract(ItemStack stack) {
        if (ShredderEntity.isBatteryItem(stack)) {
            return BatteryItem.canExtract(stack);
        }
        if (ShredderEntity.isSelfChargingBatteryItem(stack)) {
            return true;
        }
        if (stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::canExtract).orElse(false);
        }
        return false;
    }

    private boolean hasEnergy() {
        return this.getEnergy().compareTo(FloatingLong.ZERO) > 0;
    }

    private void consumeEnergy() {
        this.extractEnergy(this.currentPowerConsumption.multiply(3.6), false);
    }
}

