/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.capability;

import com.hbm.nucleartech.HBM;
import com.hbm.nucleartech.capability.entity.LivingEntityCapability;
import com.hbm.nucleartech.interfaces.IEntityCapabilityBase;
import com.hbm.nucleartech.interfaces.IWattHourStorage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HbmCapabilities {
    public static final Capability<LivingEntityCapability> LIVING_ENTITY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LivingEntityCapability>(){});
    public static final Capability<IWattHourStorage> WATT_HOUR_STORAGE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IWattHourStorage>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        HBM.addNetworkMessage(LivingCapabilitiesSyncMessage.class, LivingCapabilitiesSyncMessage::buffer, LivingCapabilitiesSyncMessage::new, LivingCapabilitiesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(LivingEntityCapability.class);
    }

    public static LivingEntityCapability getData(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return (LivingEntityCapability)player.getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)entity;
            return (LivingEntityCapability)mob.getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability());
        }
        return null;
    }

    public static class LivingCapabilitiesSyncMessage {
        private final LivingEntityCapability data;

        public LivingCapabilitiesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new LivingEntityCapability();
            this.data.readNBT(buffer.m_130260_());
        }

        public LivingCapabilitiesSyncMessage(LivingEntityCapability data) {
            this.data = data;
        }

        public static void buffer(LivingCapabilitiesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data.writeNBT());
        }

        public static void handler(LivingCapabilitiesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    LivingEntityCapability capability = (LivingEntityCapability)Minecraft.m_91087_().f_91074_.getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability());
                    capability.setValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH, message.data.getValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH));
                    capability.setValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE, message.data.getValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE));
                    capability.setValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION, message.data.getValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION));
                    capability.setValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE, message.data.getValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE));
                    capability.setValue(IEntityCapabilityBase.Type.RADIATION, message.data.getValue(IEntityCapabilityBase.Type.RADIATION));
                    capability.setValue(IEntityCapabilityBase.Type.NEUTRON, message.data.getValue(IEntityCapabilityBase.Type.NEUTRON));
                    capability.setValue(IEntityCapabilityBase.Type.DIGAMMA, message.data.getValue(IEntityCapabilityBase.Type.DIGAMMA));
                    capability.setValue(IEntityCapabilityBase.Type.ASBESTOS, message.data.getValue(IEntityCapabilityBase.Type.ASBESTOS));
                    capability.setValue(IEntityCapabilityBase.Type.BLACKLUNG, message.data.getValue(IEntityCapabilityBase.Type.BLACKLUNG));
                    capability.setValue(IEntityCapabilityBase.Type.RADENV, message.data.getValue(IEntityCapabilityBase.Type.RADENV));
                    capability.setValue(IEntityCapabilityBase.Type.RADBUF, message.data.getValue(IEntityCapabilityBase.Type.RADBUF));
                    capability.setValue(IEntityCapabilityBase.Type.BOMB_TIMER, message.data.getValue(IEntityCapabilityBase.Type.BOMB_TIMER));
                    capability.setValue(IEntityCapabilityBase.Type.CONTAGION, message.data.getValue(IEntityCapabilityBase.Type.CONTAGION));
                    capability.setValue(IEntityCapabilityBase.Type.OIL, message.data.getValue(IEntityCapabilityBase.Type.OIL));
                    capability.setValue(IEntityCapabilityBase.Type.FIRE, message.data.getValue(IEntityCapabilityBase.Type.FIRE));
                    capability.setValue(IEntityCapabilityBase.Type.PHOSPHORUS, message.data.getValue(IEntityCapabilityBase.Type.PHOSPHORUS));
                    capability.setValue(IEntityCapabilityBase.Type.BALEFIRE, message.data.getValue(IEntityCapabilityBase.Type.BALEFIRE));
                }
            });
            context.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerEntityCapabilityProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final LivingEntityCapability capability = new LivingEntityCapability();

        private PlayerEntityCapabilityProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"player_entity_capability"), (ICapabilityProvider)new PlayerEntityCapabilityProvider());
            }
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == LIVING_ENTITY_CAPABILITY ? LazyOptional.of(() -> this.capability).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.capability.writeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.capability.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class LivingEntityCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LivingEntityCapability capability = new LivingEntityCapability();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"living_entity_capability");

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Mob) {
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"living_entity_capability"), (ICapabilityProvider)new LivingEntityCapabilityProvider());
            }
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == LIVING_ENTITY_CAPABILITY ? LazyOptional.of(() -> this.capability).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.capability.writeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.capability.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerCapability(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((LivingEntityCapability)event.getEntity().getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability())).syncLivingVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerCapability(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((LivingEntityCapability)event.getEntity().getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability())).syncLivingVariables((Entity)event.getEntity());
                LivingEntityCapability e = (LivingEntityCapability)event.getEntity().getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability());
                e.setValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH, 20.0);
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerCapability(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((LivingEntityCapability)event.getEntity().getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability())).syncLivingVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            LivingEntityCapability original = (LivingEntityCapability)event.getOriginal().getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability());
            LivingEntityCapability clone = (LivingEntityCapability)event.getEntity().getCapability(LIVING_ENTITY_CAPABILITY, null).orElse((Object)new LivingEntityCapability());
            if (!event.isWasDeath()) {
                clone.setValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH, original.getValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH));
                clone.setValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE, original.getValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE));
                clone.setValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION, original.getValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION));
                clone.setValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE, original.getValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE));
                clone.setValue(IEntityCapabilityBase.Type.RADIATION, original.getValue(IEntityCapabilityBase.Type.RADIATION));
                clone.setValue(IEntityCapabilityBase.Type.NEUTRON, original.getValue(IEntityCapabilityBase.Type.NEUTRON));
                clone.setValue(IEntityCapabilityBase.Type.DIGAMMA, original.getValue(IEntityCapabilityBase.Type.DIGAMMA));
                clone.setValue(IEntityCapabilityBase.Type.ASBESTOS, original.getValue(IEntityCapabilityBase.Type.ASBESTOS));
                clone.setValue(IEntityCapabilityBase.Type.BLACKLUNG, original.getValue(IEntityCapabilityBase.Type.BLACKLUNG));
                clone.setValue(IEntityCapabilityBase.Type.RADENV, original.getValue(IEntityCapabilityBase.Type.RADENV));
                clone.setValue(IEntityCapabilityBase.Type.RADBUF, original.getValue(IEntityCapabilityBase.Type.RADBUF));
                clone.setValue(IEntityCapabilityBase.Type.BOMB_TIMER, original.getValue(IEntityCapabilityBase.Type.BOMB_TIMER));
                clone.setValue(IEntityCapabilityBase.Type.CONTAGION, original.getValue(IEntityCapabilityBase.Type.CONTAGION));
                clone.setValue(IEntityCapabilityBase.Type.OIL, original.getValue(IEntityCapabilityBase.Type.OIL));
                clone.setValue(IEntityCapabilityBase.Type.FIRE, original.getValue(IEntityCapabilityBase.Type.FIRE));
                clone.setValue(IEntityCapabilityBase.Type.PHOSPHORUS, original.getValue(IEntityCapabilityBase.Type.PHOSPHORUS));
                clone.setValue(IEntityCapabilityBase.Type.BALEFIRE, original.getValue(IEntityCapabilityBase.Type.BALEFIRE));
                clone.setValue(original.getValue());
            }
        }
    }
}

