/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.capability.energy;

import com.hbm.nucleartech.block.custom.base.BaseHbmBlockEntity;
import com.hbm.nucleartech.capability.HbmCapabilities;
import com.hbm.nucleartech.capability.energy.WattHourStorage;
import com.hbm.nucleartech.interfaces.IWattHourStorage;
import com.hbm.nucleartech.util.FloatingLong;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBatteryProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final ItemStack stack;
    private final WattHourStorage storage;
    private final LazyOptional<IWattHourStorage> lazyWh;
    private final LazyOptional<IEnergyStorage> lazyFE;

    public ItemBatteryProvider(ItemStack stack, final WattHourStorage storage) {
        this.stack = stack;
        this.storage = storage;
        this.lazyWh = LazyOptional.of(() -> new IWattHourStorage(){

            @Override
            public String formatWattHoursStored() {
                return storage.formatWattHoursStored();
            }

            @Override
            public String formatMaxWattHoursStored() {
                return storage.formatMaxWattHoursStored();
            }

            @Override
            public String formatWattsCharge() {
                return storage.formatWattsCharge();
            }

            @Override
            public String formatWattsDischarge() {
                return storage.formatWattsDischarge();
            }

            @Override
            public FloatingLong receiveWattage(FloatingLong maxReceive, boolean simulate) {
                FloatingLong r = storage.receiveWattage(maxReceive, simulate);
                if (!simulate) {
                    ItemBatteryProvider.this.writeToStack();
                }
                return r;
            }

            @Override
            public FloatingLong extractWattage(FloatingLong maxExtract, boolean simulate) {
                FloatingLong r = storage.extractWattage(maxExtract, simulate);
                if (!simulate) {
                    ItemBatteryProvider.this.writeToStack();
                }
                return r;
            }

            @Override
            public FloatingLong getWattageStored() {
                return storage.getWattageStored();
            }

            @Override
            public void setWattageStored(FloatingLong set) {
            }

            @Override
            public FloatingLong getMaxWattageStored() {
                return storage.getMaxWattageStored();
            }

            @Override
            public void setMaxWattageStored(FloatingLong set) {
                storage.setMaxWattageStored(set);
            }

            @Override
            public boolean canExtract() {
                return storage.canExtract();
            }

            @Override
            public boolean canReceive() {
                return storage.canReceive();
            }
        });
        this.lazyFE = LazyOptional.of(() -> new IEnergyStorage(){

            private FloatingLong toWh(int fe) {
                return FloatingLong.create(fe).divide(BaseHbmBlockEntity.WATT_HOUR_TO_FE);
            }

            private int fromWh(FloatingLong wh) {
                try {
                    return wh.multiply(BaseHbmBlockEntity.WATT_HOUR_TO_FE).intValue();
                }
                catch (Exception ex) {
                    return this.feValueIsPositive(wh) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                }
            }

            private boolean feValueIsPositive(FloatingLong wh) {
                try {
                    return wh.compareTo(FloatingLong.ZERO) >= 0;
                }
                catch (Exception e) {
                    return true;
                }
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int r = this.fromWh(storage.receiveWattage(this.toWh(maxReceive), simulate));
                if (!simulate) {
                    ItemBatteryProvider.this.writeToStack();
                }
                return r;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int r = this.fromWh(storage.extractWattage(this.toWh(maxExtract), simulate));
                if (!simulate) {
                    ItemBatteryProvider.this.writeToStack();
                }
                return r;
            }

            public int getEnergyStored() {
                return this.fromWh(storage.getWattageStored());
            }

            public int getMaxEnergyStored() {
                return this.fromWh(storage.getMaxWattageStored());
            }

            public boolean canExtract() {
                return storage.canExtract();
            }

            public boolean canReceive() {
                return storage.canReceive();
            }
        });
    }

    private void writeToStack() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128365_("WattHourStorage", (Tag)this.storage.serializeNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == HbmCapabilities.WATT_HOUR_STORAGE) {
            return this.lazyWh.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyFE.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.storage.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.storage.deserializeNBT(nbt);
    }
}

