/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.capability.energy;

import com.hbm.nucleartech.interfaces.IWattHourStorage;
import com.hbm.nucleartech.util.FloatingLong;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class WattHourStorage
implements IWattHourStorage,
INBTSerializable<CompoundTag> {
    public static final double MCSECOND_TO_TICK = 3.6;
    protected FloatingLong storedWattHours;
    protected FloatingLong capacity;
    protected FloatingLong maxReceive;
    protected FloatingLong maxExtract;
    public static final String TAG_STORED = "Stored";
    public static final String TAG_CAPACITY = "Capacity";
    public static final String TAG_MAX_EXTRACT = "MaxExtract";
    public static final String TAG_MAX_RECEIVE = "MaxReceive";

    public WattHourStorage(FloatingLong capacity) {
        this(capacity, capacity, capacity, FloatingLong.ZERO);
    }

    public WattHourStorage(FloatingLong capacity, FloatingLong maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, FloatingLong.ZERO);
    }

    public WattHourStorage(FloatingLong capacity, FloatingLong maxReceive, FloatingLong maxExtract) {
        this(capacity, maxReceive, maxExtract, FloatingLong.ZERO);
    }

    public WattHourStorage(FloatingLong capacity, FloatingLong maxReceive, FloatingLong maxExtract, FloatingLong initialStorage) {
        FloatingLong init;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.storedWattHours = init = WattHourStorage.Max(FloatingLong.ZERO, WattHourStorage.Min(initialStorage, capacity));
    }

    @Override
    public String formatWattHoursStored() {
        int unitIndex;
        FloatingLong value = this.storedWattHours;
        if (value.compareTo(FloatingLong.create(1000)) < 0) {
            return String.format("%.1f", Float.valueOf(value.floatValue())) + "Wh";
        }
        String[] units = new String[]{"Wh", "kWh", "MWh", "GWh", "TWh", "PWh", "EWh", "ZWh", "YWh", "RWh", "QWh", "?Wh"};
        for (unitIndex = 0; value.compareTo(FloatingLong.create(1000)) >= 0 && unitIndex < units.length - 1; ++unitIndex) {
            value = value.divide(1000.0);
        }
        String formatted = String.format("%.1f", Float.valueOf(value.floatValue()));
        return formatted + units[unitIndex];
    }

    @Override
    public String formatMaxWattHoursStored() {
        int unitIndex;
        FloatingLong value = this.capacity;
        if (value.compareTo(FloatingLong.create(1000)) < 0) {
            return String.format("%.1f", Float.valueOf(value.floatValue())) + "Wh";
        }
        String[] units = new String[]{"Wh", "kWh", "MWh", "GWh", "TWh", "PWh", "EWh", "ZWh", "YWh", "RWh", "QWh", "?Wh"};
        for (unitIndex = 0; value.compareTo(FloatingLong.create(1000)) >= 0 && unitIndex < units.length - 1; ++unitIndex) {
            value = value.divide(1000.0);
        }
        String formatted = String.format("%.1f", Float.valueOf(value.floatValue()));
        return formatted + units[unitIndex];
    }

    @Override
    public String formatWattsCharge() {
        int unitIndex;
        FloatingLong value = WattHourStorage.translateWattHours(this.maxReceive.divide(3.6));
        if (value.compareTo(FloatingLong.create(1000)) < 0) {
            return String.format("%.1f", Float.valueOf(value.floatValue())) + "W";
        }
        String[] units = new String[]{"W", "kW", "MW", "GW", "TW", "PW", "EW", "ZW", "YW", "RW", "QW", "?W"};
        for (unitIndex = 0; value.compareTo(FloatingLong.create(1000)) >= 0 && unitIndex < units.length - 1; ++unitIndex) {
            value = value.divide(1000.0);
        }
        String formatted = String.format("%.1f", Float.valueOf(value.floatValue()));
        return formatted + units[unitIndex];
    }

    @Override
    public String formatWattsDischarge() {
        int unitIndex;
        FloatingLong value = WattHourStorage.translateWattHours(this.maxExtract.divide(3.6));
        if (value.compareTo(FloatingLong.create(1000)) < 0) {
            return String.format("%.1f", Float.valueOf(value.floatValue())) + "W";
        }
        String[] units = new String[]{"W", "kW", "MW", "GW", "TW", "PW", "EW", "ZW", "YW", "RW", "QW", "?W"};
        for (unitIndex = 0; value.compareTo(FloatingLong.create(1000)) >= 0 && unitIndex < units.length - 1; ++unitIndex) {
            value = value.divide(1000.0);
        }
        String formatted = String.format("%.1f", Float.valueOf(value.floatValue()));
        return formatted + units[unitIndex];
    }

    @Override
    public FloatingLong receiveWattage(FloatingLong maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return FloatingLong.ZERO;
        }
        FloatingLong wattHoursReceived = WattHourStorage.Min(this.capacity.subtract(this.storedWattHours), WattHourStorage.Min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.storedWattHours = this.storedWattHours.add(wattHoursReceived);
        }
        return wattHoursReceived;
    }

    @Override
    public FloatingLong extractWattage(FloatingLong maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return FloatingLong.ZERO;
        }
        FloatingLong wattHoursExtracted = WattHourStorage.Min(this.storedWattHours, WattHourStorage.Min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.storedWattHours = this.storedWattHours.subtract(wattHoursExtracted);
        }
        return wattHoursExtracted;
    }

    @Override
    public FloatingLong getWattageStored() {
        return this.storedWattHours;
    }

    @Override
    public FloatingLong getMaxWattageStored() {
        return this.capacity;
    }

    @Override
    public void setMaxWattageStored(FloatingLong set) {
        this.capacity = set;
    }

    @Override
    public void setWattageStored(FloatingLong wattHours) {
        this.storedWattHours = WattHourStorage.Max(FloatingLong.ZERO, WattHourStorage.Min(wattHours, this.capacity));
    }

    public FloatingLong getMaxExtract() {
        return this.maxExtract;
    }

    public FloatingLong getMaxReceive() {
        return this.maxReceive;
    }

    public void setMaxExtract(FloatingLong set) {
        this.maxExtract = set;
    }

    public void setMaxReceive(FloatingLong set) {
        this.maxReceive = set;
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract.compareTo(FloatingLong.ZERO) > 0;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive.compareTo(FloatingLong.ZERO) > 0;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(TAG_STORED, this.storedWattHours.toString());
        tag.m_128359_(TAG_CAPACITY, this.capacity.toString());
        tag.m_128359_(TAG_MAX_EXTRACT, this.maxExtract.toString());
        tag.m_128359_(TAG_MAX_RECEIVE, this.maxReceive.toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_(TAG_STORED)) {
            this.storedWattHours = FloatingLong.create(nbt.m_128461_(TAG_STORED));
        }
        if (nbt.m_128441_(TAG_CAPACITY)) {
            this.capacity = FloatingLong.create(nbt.m_128461_(TAG_CAPACITY));
        }
        if (nbt.m_128441_(TAG_MAX_EXTRACT)) {
            this.maxExtract = FloatingLong.create(nbt.m_128461_(TAG_MAX_EXTRACT));
        }
        if (nbt.m_128441_(TAG_MAX_RECEIVE)) {
            this.maxReceive = FloatingLong.create(nbt.m_128461_(TAG_MAX_RECEIVE));
        }
    }

    public static FloatingLong Min(FloatingLong a, FloatingLong b) {
        if (a == null) {
            return b == null ? FloatingLong.ZERO : b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static FloatingLong Max(FloatingLong a, FloatingLong b) {
        if (a == null) {
            return b == null ? FloatingLong.ZERO : b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static FloatingLong translateWatts(FloatingLong inputWatts) {
        FloatingLong wattHours = inputWatts.divide(3600.0);
        return wattHours;
    }

    public static double translateWattHours(double inputWattHours) {
        double watts = inputWattHours * 3600.0;
        return watts;
    }

    public static FloatingLong translateWattHours(FloatingLong inputWattHours) {
        FloatingLong watts = inputWattHours.multiply(FloatingLong.create(3600));
        return watts;
    }
}

