/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.capability.entity;

import com.hbm.nucleartech.HBM;
import com.hbm.nucleartech.capability.HbmCapabilities;
import com.hbm.nucleartech.interfaces.IEntityCapabilityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public class LivingEntityCapability
implements IEntityCapabilityBase {
    public static final UUID digamma_UUID = UUID.fromString("2a3d8aec-5ab9-4218-9b8b-ca812bdf378b");
    private float oldMaxHealth = 20.0f;
    private int oldRoundedDamage = -1;
    private double internalDamage = 0.0;
    private double permanentContamination = 0.0;
    private float radiation = 0.0f;
    private float neutron = 0.0f;
    private float digamma = 0.0f;
    private int asbestos = 0;
    public static final int maxAsbestos = 72000;
    private int blacklung = 0;
    public static final int maxBlacklung = 144000;
    private float radEnv = 0.0f;
    private float radBuf = 0.0f;
    private int bombTimer = 0;
    private int contagion = 0;
    private int oil = 0;
    private int fire = 0;
    private int phosphorus = 0;
    private int balefire = 0;
    private List<ContaminationEffect> contamination = new ArrayList<ContaminationEffect>();

    public void syncLivingVariables(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            HBM.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new HbmCapabilities.LivingCapabilitiesSyncMessage(this));
        }
    }

    @Override
    public double getValue(IEntityCapabilityBase.Type type) {
        switch (type) {
            case OLD_MAX_HEALTH: {
                return this.oldMaxHealth;
            }
            case OLD_ROUNDED_DAMAGE: {
                return this.oldRoundedDamage;
            }
            case PERMANENT_CONTAMINATION: {
                return this.permanentContamination;
            }
            case INTERNAL_DAMAGE: {
                return this.internalDamage;
            }
            case RADIATION: {
                return this.radiation;
            }
            case NEUTRON: {
                return this.neutron;
            }
            case DIGAMMA: {
                return this.digamma;
            }
            case ASBESTOS: {
                return this.asbestos;
            }
            case BLACKLUNG: {
                return this.blacklung;
            }
            case RADENV: {
                return this.radEnv;
            }
            case RADBUF: {
                return this.radBuf;
            }
            case BOMB_TIMER: {
                return this.bombTimer;
            }
            case CONTAGION: {
                return this.contagion;
            }
            case OIL: {
                return this.oil;
            }
            case FIRE: {
                return this.fire;
            }
            case PHOSPHORUS: {
                return this.phosphorus;
            }
            case BALEFIRE: {
                return this.balefire;
            }
        }
        return -1.0;
    }

    @Override
    public List<ContaminationEffect> getValue() {
        return this.contamination;
    }

    @Override
    public void setValue(IEntityCapabilityBase.Type type, double value) {
        switch (type) {
            case OLD_MAX_HEALTH: {
                this.oldMaxHealth = (float)value;
                break;
            }
            case OLD_ROUNDED_DAMAGE: {
                this.oldRoundedDamage = (int)value;
                break;
            }
            case PERMANENT_CONTAMINATION: {
                this.permanentContamination = Mth.m_14008_((double)value, (double)0.0, (double)Double.MAX_VALUE);
                break;
            }
            case INTERNAL_DAMAGE: {
                this.internalDamage = Mth.m_14008_((double)value, (double)0.0, (double)Double.MAX_VALUE);
                break;
            }
            case RADIATION: {
                this.radiation = (float)Mth.m_14008_((double)value, (double)0.0, (double)Double.MAX_VALUE);
                break;
            }
            case NEUTRON: {
                this.neutron = (float)value;
                break;
            }
            case DIGAMMA: {
                this.digamma = (float)value;
                break;
            }
            case ASBESTOS: {
                this.asbestos = Mth.m_14107_((double)value);
                break;
            }
            case BLACKLUNG: {
                this.blacklung = Mth.m_14107_((double)value);
                break;
            }
            case RADENV: {
                this.radEnv = (float)value;
                break;
            }
            case RADBUF: {
                this.radBuf = (float)value;
                break;
            }
            case BOMB_TIMER: {
                this.bombTimer = Mth.m_14107_((double)value);
                break;
            }
            case CONTAGION: {
                this.contagion = Mth.m_14107_((double)value);
                break;
            }
            case OIL: {
                this.oil = Mth.m_14107_((double)value);
                break;
            }
            case FIRE: {
                this.fire = Mth.m_14107_((double)value);
                break;
            }
            case PHOSPHORUS: {
                this.phosphorus = Mth.m_14107_((double)value);
                break;
            }
            case BALEFIRE: {
                this.balefire = Mth.m_14107_((double)value);
                break;
            }
        }
    }

    @Override
    public void setValue(List<ContaminationEffect> contaminations) {
        this.contamination.clear();
        this.contamination.addAll(contaminations);
    }

    @Override
    public void addValue(IEntityCapabilityBase.Type type, double value) {
        switch (type) {
            case OLD_MAX_HEALTH: {
                float hp = this.oldMaxHealth + (float)value;
                this.setValue(type, hp);
                break;
            }
            case OLD_ROUNDED_DAMAGE: {
                int val = this.oldRoundedDamage + (int)value;
                this.setValue(type, val);
                break;
            }
            case PERMANENT_CONTAMINATION: {
                double perm = this.permanentContamination + value;
                perm = Mth.m_14008_((double)perm, (double)0.0, (double)1000.0);
                this.setValue(type, perm);
                break;
            }
            case INTERNAL_DAMAGE: {
                double dam = this.internalDamage + value;
                dam = Mth.m_14008_((double)dam, (double)0.0, (double)100.0);
                this.setValue(type, dam);
                break;
            }
            case RADIATION: {
                float rad = this.radiation + (float)value;
                this.setValue(type, rad);
                break;
            }
            case NEUTRON: {
                float rad = this.neutron + (float)value;
                this.setValue(type, rad);
                break;
            }
            case DIGAMMA: {
                float dRad = this.digamma + (float)value;
                dRad = Mth.m_14036_((float)dRad, (float)0.0f, (float)10.0f);
                this.setValue(type, dRad);
                break;
            }
            case ASBESTOS: {
                this.setValue(type, Mth.m_14008_((double)((double)this.asbestos + value), (double)0.0, (double)72000.0));
                break;
            }
            case BLACKLUNG: {
                this.setValue(type, Mth.m_14008_((double)((double)this.blacklung + value), (double)0.0, (double)144000.0));
                break;
            }
            case RADENV: {
                float radE = this.radEnv + (float)value;
                radE = Mth.m_14036_((float)radE, (float)0.0f, (float)2500.0f);
                this.setValue(type, radE);
                break;
            }
            case RADBUF: {
                float e = this.radBuf + (float)value;
                e = Mth.m_14036_((float)e, (float)0.0f, (float)2500.0f);
                this.setValue(type, e);
                break;
            }
            case BOMB_TIMER: {
                float e = (float)this.bombTimer + (float)value;
                this.setValue(type, e);
                break;
            }
            case CONTAGION: {
                float e = (float)this.contagion + (float)value;
                this.setValue(type, e);
                break;
            }
            case OIL: {
                float e = (float)this.oil + (float)value;
                this.setValue(type, e);
                break;
            }
            case FIRE: {
                float e = (float)this.fire + (float)value;
                this.setValue(type, e);
                break;
            }
            case PHOSPHORUS: {
                float e = (float)this.phosphorus + (float)value;
                this.setValue(type, e);
                break;
            }
            case BALEFIRE: {
                float e = (float)this.balefire + (float)value;
                this.setValue(type, e);
                break;
            }
        }
    }

    @Override
    public void addValue(ContaminationEffect contaminationEffect) {
        this.contamination.add(contaminationEffect);
    }

    public CompoundTag writeNBT() {
        CompoundTag props = new CompoundTag();
        props.m_128350_("hfr_old_max_health", (float)this.getValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH));
        props.m_128350_("hfr_old_rounded_damage", (float)this.getValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE));
        props.m_128347_("hfr_internal_damage", this.getValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE));
        props.m_128347_("hfr_permanent_contamination", this.getValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION));
        props.m_128350_("hfr_radiation", (float)this.getValue(IEntityCapabilityBase.Type.RADIATION));
        props.m_128350_("hfr_neutron", (float)this.getValue(IEntityCapabilityBase.Type.NEUTRON));
        props.m_128350_("hfr_digamma", (float)this.getValue(IEntityCapabilityBase.Type.DIGAMMA));
        props.m_128405_("hfr_asbestos", (int)this.getValue(IEntityCapabilityBase.Type.ASBESTOS));
        props.m_128405_("hfr_blacklung", (int)this.getValue(IEntityCapabilityBase.Type.BLACKLUNG));
        props.m_128350_("hfr_radenv", (float)this.getValue(IEntityCapabilityBase.Type.RADENV));
        props.m_128350_("hfr_radbuf", (float)this.getValue(IEntityCapabilityBase.Type.RADBUF));
        props.m_128405_("hfr_bomb", (int)this.getValue(IEntityCapabilityBase.Type.BOMB_TIMER));
        props.m_128405_("hfr_contagion", (int)this.getValue(IEntityCapabilityBase.Type.CONTAGION));
        props.m_128405_("hfr_oil", (int)this.getValue(IEntityCapabilityBase.Type.OIL));
        props.m_128405_("hfr_fire", (int)this.getValue(IEntityCapabilityBase.Type.FIRE));
        props.m_128405_("hfr_phosphorus", (int)this.getValue(IEntityCapabilityBase.Type.PHOSPHORUS));
        props.m_128405_("hfr_balefire", (int)this.getValue(IEntityCapabilityBase.Type.BALEFIRE));
        props.m_128350_("hfr_cont_count", (float)this.getValue().size());
        for (int i = 0; i < this.getValue().size(); ++i) {
            props.m_128365_("hfr_buf_" + i, (Tag)this.getValue().get(i).serializeNBT());
        }
        return props;
    }

    public void readNBT(CompoundTag nbt) {
        this.setValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH, nbt.m_128457_("hfr_old_max_health"));
        this.setValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE, nbt.m_128457_("hfr_old_rounded_damage"));
        this.setValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE, nbt.m_128459_("hfr_internal_damage"));
        this.setValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION, nbt.m_128459_("hfr_permanent_contamination"));
        this.setValue(IEntityCapabilityBase.Type.RADIATION, nbt.m_128457_("hfr_radiation"));
        this.setValue(IEntityCapabilityBase.Type.NEUTRON, nbt.m_128457_("hfr_neutron"));
        this.setValue(IEntityCapabilityBase.Type.DIGAMMA, nbt.m_128457_("hfr_digamma"));
        this.setValue(IEntityCapabilityBase.Type.ASBESTOS, nbt.m_128457_("hfr_asbestos"));
        this.setValue(IEntityCapabilityBase.Type.BLACKLUNG, nbt.m_128457_("hfr_blacklung"));
        this.setValue(IEntityCapabilityBase.Type.RADENV, nbt.m_128457_("hfr_radenv"));
        this.setValue(IEntityCapabilityBase.Type.RADBUF, nbt.m_128457_("hfr_radbuf"));
        this.setValue(IEntityCapabilityBase.Type.BOMB_TIMER, nbt.m_128457_("hfr_bomb"));
        this.setValue(IEntityCapabilityBase.Type.CONTAGION, nbt.m_128457_("hfr_contagion"));
        this.setValue(IEntityCapabilityBase.Type.OIL, nbt.m_128457_("hfr_oil"));
        this.setValue(IEntityCapabilityBase.Type.FIRE, nbt.m_128457_("hfr_fire"));
        this.setValue(IEntityCapabilityBase.Type.PHOSPHORUS, nbt.m_128457_("hfr_phosphorus"));
        this.setValue(IEntityCapabilityBase.Type.BALEFIRE, nbt.m_128457_("hfr_balefire"));
        this.getValue().clear();
        int i = 0;
        while ((float)i < nbt.m_128457_("hfr_cont_count")) {
            CompoundTag contaminationTag = nbt.m_128469_("hfr_buf_" + i);
            this.getValue().add(ContaminationEffect.deserializeNBT(contaminationTag));
            ++i;
        }
    }

    public static class ContaminationEffect {
        public float maxRad;
        public int maxTime;
        public int time;
        public boolean ignoreArmor;

        public ContaminationEffect(float rad, int time, boolean ignoreArmor) {
            this.maxRad = rad;
            this.maxTime = this.time = time;
            this.ignoreArmor = ignoreArmor;
        }

        public float getRad() {
            return this.maxRad * ((float)this.time / (float)this.maxTime);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("maxRad", this.maxRad);
            tag.m_128405_("maxTime", this.maxTime);
            tag.m_128405_("time", this.time);
            tag.m_128379_("ignoreArmor", this.ignoreArmor);
            return tag;
        }

        public static ContaminationEffect deserializeNBT(CompoundTag tag) {
            float maxRad = tag.m_128457_("maxRad");
            int maxTime = tag.m_128451_("maxTime");
            int time = tag.m_128451_("time");
            boolean ignoreArmor = tag.m_128471_("ignoreArmor");
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }
    }
}

