/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.compat.jei.categories;

import com.hbm.nucleartech.block.RegisterBlocks;
import com.hbm.nucleartech.recipe.PressRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class PressCategory
implements IRecipeCategory<PressRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"press");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"textures/gui/burner_press_gui.png");
    public static final RecipeType<PressRecipe> BURNER_PRESS_TYPE = new RecipeType(UID, PressRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated stampAnim;
    private static final int XO = 75;
    private static final int YO = 12;

    public PressCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 75, 12, 90, 62);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegisterBlocks.BURNER_PRESS.get()));
        IDrawableStatic stampStatic = helper.createDrawable(TEXTURE, 195, 0, 16, 16);
        this.stampAnim = helper.createAnimatedDrawable(stampStatic, 40, IDrawableAnimated.StartDirection.TOP, false);
    }

    public String toString() {
        return "PressCategory{background=" + String.valueOf(this.background) + ", icon=" + String.valueOf(this.icon) + ", stampAnim=" + String.valueOf(this.stampAnim) + "}";
    }

    public void draw(PressRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.stampAnim.draw(guiGraphics, 5, 23);
    }

    public RecipeType<PressRecipe> getRecipeType() {
        return BURNER_PRESS_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.hbm.press");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PressRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 41).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 23).addItemStack(recipe.m_8043_(null));
    }
}

