/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.compat.jei.categories;

import com.hbm.nucleartech.block.RegisterBlocks;
import com.hbm.nucleartech.capability.energy.WattHourStorage;
import com.hbm.nucleartech.datagen.ModRecipeProvider;
import com.hbm.nucleartech.recipe.ShredderRecipe;
import com.hbm.nucleartech.screen.ShredderScreen;
import com.hbm.nucleartech.util.FloatingLong;
import com.hbm.nucleartech.util.RegisterTags;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ShredderCategory
implements IRecipeCategory<ShredderRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"shredder");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"textures/gui/shredder_nei_gui.png");
    public static final RecipeType<ShredderRecipe> SHREDDER_TYPE = new RecipeType(UID, ShredderRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private static final int XO = 0;
    private static final int YO = 0;
    private final IDrawableStatic shredStatic;
    private final IDrawableStatic energyStatic;
    private final Map<ResourceLocation, Pair<IDrawableAnimated, IDrawableAnimated>> animatedCache = new HashMap<ResourceLocation, Pair<IDrawableAnimated, IDrawableAnimated>>();
    private final Map<ResourceLocation, FloatingLong> energyCache = new HashMap<ResourceLocation, FloatingLong>();

    public ShredderCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 86);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegisterBlocks.SHREDDER.get()));
        this.shredStatic = helper.createDrawable(TEXTURE, 101, 119, 22, 16);
        this.energyStatic = helper.createDrawable(TEXTURE, 36, 86, 16, 52);
    }

    public String toString() {
        return "ShredderCategory{background=" + String.valueOf(this.background) + ", icon=" + String.valueOf(this.icon) + ", helper=" + String.valueOf(this.helper) + ", shredStatic=" + String.valueOf(this.shredStatic) + ", energyStatic=" + String.valueOf(this.energyStatic) + ", animatedCache=" + String.valueOf(this.animatedCache) + ", energyCache=" + String.valueOf(this.energyCache) + "}";
    }

    public void draw(ShredderRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        FloatingLong energyConsumption;
        ResourceLocation id = recipe.m_6423_();
        Pair<IDrawableAnimated, IDrawableAnimated> pair = this.animatedCache.get(id);
        if (pair != null) {
            IDrawableAnimated progressArrow = (IDrawableAnimated)pair.left();
            IDrawableAnimated energyBar = (IDrawableAnimated)pair.right();
            progressArrow.draw(guiGraphics, 86, 35);
            energyBar.draw(guiGraphics, 8, 17);
        }
        if ((energyConsumption = this.energyCache.get(id)) != null && ShredderScreen.isMouseOverGuiArea((int)mouseX, (int)mouseY, 8, 17, 0, 0, 16, 52)) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"ui.hbm.power_draw", (Object[])new Object[]{this.formatWatts(energyConsumption)}), (int)mouseX, (int)mouseY);
        }
    }

    public String formatWatts(FloatingLong wattHours) {
        int unitIndex;
        FloatingLong value = WattHourStorage.translateWattHours(wattHours);
        if (value.compareTo(FloatingLong.create(1000)) < 0) {
            return value.floatValue() + "W";
        }
        String[] units = new String[]{"W", "kW", "MW", "GW", "TW", "PW", "EW", "ZW", "YW", "RW", "QW", "?W"};
        for (unitIndex = 0; value.compareTo(FloatingLong.create(1000)) >= 0 && unitIndex < units.length - 1; ++unitIndex) {
            value = value.divide(1000.0);
        }
        String formatted = String.format("%.1f", Float.valueOf(value.floatValue()));
        return formatted + units[unitIndex];
    }

    public RecipeType<ShredderRecipe> getRecipeType() {
        return SHREDDER_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.hbm.shredder");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ShredderRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 35).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 89, 17).addItemStacks(ShredderCategory.getItemsFromTag(RegisterTags.Items.SHREDDER_BLADES));
        builder.addSlot(RecipeIngredientRole.INPUT, 89, 53).addItemStacks(ShredderCategory.getItemsFromTag(RegisterTags.Items.SHREDDER_BLADES));
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (Pair result : recipe.getResults()) {
            results.add(new ItemStack((ItemLike)result.left(), ((ModRecipeProvider.MetaData)result.right()).getMaxCount()));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 134, 35).addItemStacks(results);
        ResourceLocation id = recipe.m_6423_();
        if (!this.animatedCache.containsKey(id)) {
            int ticksPerCycle = Math.max(1, recipe.getTicks());
            FloatingLong energyConsumption = recipe.getPowerConsumption() == null ? FloatingLong.create(1) : recipe.getPowerConsumption();
            IDrawableAnimated progressArrow = this.helper.createAnimatedDrawable(this.shredStatic, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
            FloatingLong maxEnergy = FloatingLong.create(5000.0);
            int energyTicks = energyConsumption.compareTo(FloatingLong.ZERO) <= 0 ? 1 : Math.max(1, maxEnergy.divide(energyConsumption).intValue());
            IDrawableAnimated energyBar = this.helper.createAnimatedDrawable(this.energyStatic, energyTicks, IDrawableAnimated.StartDirection.TOP, true);
            this.animatedCache.put(id, (Pair<IDrawableAnimated, IDrawableAnimated>)Pair.of((Object)progressArrow, (Object)energyBar));
            this.energyCache.put(id, recipe.getPowerConsumption());
        }
    }

    public static List<ItemStack> getItemsFromTag(TagKey<Item> tagKey) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Item holder : ForgeRegistries.ITEMS.tags().getTag(tagKey).stream().toList()) {
            items.add(holder.m_7968_());
        }
        return items;
    }
}

