/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.damagesource;

import com.hbm.nucleartech.damagesource.HbmDamageTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class RegisterDamageSources {
    public static final DamageSource BLAST = RegisterDamageSources.createDamageSource(HbmDamageTypes.BLAST);
    public static final DamageSource NUCLEAR_BLAST = RegisterDamageSources.createDamageSource(HbmDamageTypes.NUCLEAR_BLAST);
    public static final DamageSource MUD_POISONING = RegisterDamageSources.createDamageSource(HbmDamageTypes.MUD_POISONING);
    public static final DamageSource ACID = RegisterDamageSources.createDamageSource(HbmDamageTypes.ACID);
    public static final DamageSource EUTHANIZED_SELF = RegisterDamageSources.createDamageSource(HbmDamageTypes.EUTHANIZED_SELF);
    public static final DamageSource EUTHANIZED_SELF_2 = RegisterDamageSources.createDamageSource(HbmDamageTypes.EUTHANIZED_SELF_2);
    public static final DamageSource TAU_BLAST = RegisterDamageSources.createDamageSource(HbmDamageTypes.TAU_BLAST);
    public static final DamageSource RADIATION = RegisterDamageSources.createDamageSource(HbmDamageTypes.RADIATION);
    public static final DamageSource DIGAMMA = RegisterDamageSources.createDamageSource(HbmDamageTypes.DIGAMMA);
    public static final DamageSource SUICIDE = RegisterDamageSources.createDamageSource(HbmDamageTypes.SUICIDE);
    public static final DamageSource TELEPORTER = RegisterDamageSources.createDamageSource(HbmDamageTypes.TELEPORTER);
    public static final DamageSource CHEATER = RegisterDamageSources.createDamageSource(HbmDamageTypes.CHEATER);
    public static final DamageSource RUBBLE = RegisterDamageSources.createDamageSource(HbmDamageTypes.RUBBLE);
    public static final DamageSource SHRAPNEL = RegisterDamageSources.createDamageSource(HbmDamageTypes.SHRAPNEL);
    public static final DamageSource BLACK_HOLE = RegisterDamageSources.createDamageSource(HbmDamageTypes.BLACK_HOLE);
    public static final DamageSource BLENDER = RegisterDamageSources.createDamageSource(HbmDamageTypes.BLENDER);
    public static final DamageSource METEORITE = RegisterDamageSources.createDamageSource(HbmDamageTypes.METEORITE);
    public static final DamageSource BOXCAR = RegisterDamageSources.createDamageSource(HbmDamageTypes.BOXCAR);
    public static final DamageSource BOAT = RegisterDamageSources.createDamageSource(HbmDamageTypes.BOAT);
    public static final DamageSource BUILDING = RegisterDamageSources.createDamageSource(HbmDamageTypes.BUILDING);
    public static final DamageSource TAINT = RegisterDamageSources.createDamageSource(HbmDamageTypes.TAINT);
    public static final DamageSource AMS = RegisterDamageSources.createDamageSource(HbmDamageTypes.AMS);
    public static final DamageSource AMS_CORE = RegisterDamageSources.createDamageSource(HbmDamageTypes.AMS_CORE);
    public static final DamageSource BROADCAST = RegisterDamageSources.createDamageSource(HbmDamageTypes.BROADCAST);
    public static final DamageSource BANG = RegisterDamageSources.createDamageSource(HbmDamageTypes.BANG);
    public static final DamageSource PC = RegisterDamageSources.createDamageSource(HbmDamageTypes.PC);
    public static final DamageSource CLOUD = RegisterDamageSources.createDamageSource(HbmDamageTypes.CLOUD);
    public static final DamageSource LEAD = RegisterDamageSources.createDamageSource(HbmDamageTypes.LEAD);
    public static final DamageSource ENERVATION = RegisterDamageSources.createDamageSource(HbmDamageTypes.ENERVATION);
    public static final DamageSource ELECTRICITY = RegisterDamageSources.createDamageSource(HbmDamageTypes.ELECTRICITY);
    public static final DamageSource EXHAUST = RegisterDamageSources.createDamageSource(HbmDamageTypes.EXHAUST);
    public static final DamageSource SPIKES = RegisterDamageSources.createDamageSource(HbmDamageTypes.SPIKES);
    public static final DamageSource LUNAR = RegisterDamageSources.createDamageSource(HbmDamageTypes.LUNAR);
    public static final DamageSource MONOXIDE = RegisterDamageSources.createDamageSource(HbmDamageTypes.MONOXIDE);
    public static final DamageSource ASBESTOS = RegisterDamageSources.createDamageSource(HbmDamageTypes.ASBESTOS);
    public static final DamageSource BLACKLUNG = RegisterDamageSources.createDamageSource(HbmDamageTypes.BLACKLUNG);
    public static final DamageSource MKU = RegisterDamageSources.createDamageSource(HbmDamageTypes.MKU);
    public static final DamageSource VACUUM = RegisterDamageSources.createDamageSource(HbmDamageTypes.VACUUM);
    public static final DamageSource OVERDOSE = RegisterDamageSources.createDamageSource(HbmDamageTypes.OVERDOSE);
    public static final DamageSource MICROWAVE = RegisterDamageSources.createDamageSource(HbmDamageTypes.MICROWAVE);
    public static final DamageSource NITAN = RegisterDamageSources.createDamageSource(HbmDamageTypes.NITAN);
    private static final DamageSource REVOLVER_BULLET = RegisterDamageSources.createDamageSource(HbmDamageTypes.REVOLVER_BULLET);
    private static final DamageSource CHOPPER_BULLET = RegisterDamageSources.createDamageSource(HbmDamageTypes.CHOPPER_BULLET);
    private static final DamageSource TAU = RegisterDamageSources.createDamageSource(HbmDamageTypes.TAU);
    private static final DamageSource CMB = RegisterDamageSources.createDamageSource(HbmDamageTypes.CMB);
    private static final DamageSource SUB_ATOMIC = RegisterDamageSources.createDamageSource(HbmDamageTypes.SUB_ATOMIC);
    private static final DamageSource EUTHANIZED = RegisterDamageSources.createDamageSource(HbmDamageTypes.EUTHANIZED);
    public static final DamageSource ELECTRIFIED = RegisterDamageSources.createDamageSource(HbmDamageTypes.ELECTRIFIED);
    public static final DamageSource FLAMETHROWER = RegisterDamageSources.createDamageSource(HbmDamageTypes.FLAMETHROWER);
    public static final DamageSource PLASMA = RegisterDamageSources.createDamageSource(HbmDamageTypes.PLASMA);
    public static final DamageSource ICE = RegisterDamageSources.createDamageSource(HbmDamageTypes.ICE);
    public static final DamageSource BOIL = RegisterDamageSources.createDamageSource(HbmDamageTypes.BOIL);
    public static final DamageSource ACID_PLAYER = RegisterDamageSources.createDamageSource(HbmDamageTypes.ACID_PLAYER);

    @NotNull
    private static DamageSource createDamageSource(ResourceKey<DamageType> damageTypeKey) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                return new DamageSource((Holder)server.m_206579_().m_175515_(Registries.f_268580_).m_246971_(damageTypeKey));
            }
        }
        catch (Exception server) {
            // empty catch block
        }
        DamageType tempType = new DamageType("hbm." + damageTypeKey.m_135782_().m_135815_(), 0.1f);
        return new DamageSource(Holder.m_205709_((Object)tempType));
    }

    public static DamageSource causeBulletDamage(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(REVOLVER_BULLET.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource causeDisplacementDamage(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(CHOPPER_BULLET.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource causeTauDamage(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(TAU.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource causeCombineDamage(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(CMB.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource causeSubatomicDamage(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(SUB_ATOMIC.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource euthanized(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(EUTHANIZED.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource ELECTRIFIED(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(ELECTRIFIED.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource FLAMETHROWER(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(FLAMETHROWER.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource PLASMA(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(PLASMA.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource ICE(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(ICE.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource BOIL(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(BOIL.m_269150_(), (Entity)hit, (Entity)ent);
    }

    public static DamageSource ACID_PLAYER(LivingEntity ent, LivingEntity hit) {
        return new DamageSource(ACID_PLAYER.m_269150_(), (Entity)hit, (Entity)ent);
    }
}

