/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class ModDamageTypeTagProvider
extends DamageTypeTagsProvider {
    private final PackOutput output;

    public ModDamageTypeTagProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(pOutput, pLookupProvider, "hbm", existingFileHelper);
        this.output = pOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        CompletableFuture value = super.m_213708_(pOutput);
        try {
            System.out.println("Attempting to inject values into tag JSONs...");
            this.injectIntoGeneratedJsons();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to inject values into tag JSONs", e);
        }
        return value;
    }

    private void injectIntoGeneratedJsons() throws IOException {
        Path tagsFolder = this.output.m_245114_().resolve("data/minecraft/tags/damage_type");
        if (!Files.exists(tagsFolder, new LinkOption[0])) {
            return;
        }
        HashMap<String, List<String>> injectMap = new HashMap<String, List<String>>();
        injectMap.put("bypasses_armor.json", List.of("hbm:radiation", "hbm:mud_poisoning", "hbm:euthanized_self", "hbm:euthanized_self_2", "hbm:tau_blast", "hbm:digamma", "hbm:cheater", "hbm:black_hole", "hbm:blender", "hbm:meteorite", "hbm:boxcar", "hbm:boat", "hbm:building", "hbm:taint", "hbm:ams", "hbm:ams_core", "hbm:broadcast", "hbm:bang", "hbm:pc", "hbm:cloud", "hbm:lead", "hbm:enervation", "hbm:electricity", "hbm:exhaust", "hbm:spikes", "hbm:lunar", "hbm:monoxide", "hbm:asbestos", "hbm:blacklung", "hbm:mku", "hbm:vacuum", "hbm:overdose", "hbm:microwave", "hbm:nitan", "hbm:tau", "hbm:cmb", "hbm:sub_atomic", "hbm:euthanized", "hbm:laser"));
        injectMap.put("is_explosion.json", List.of("hbm:nuclear_blast", "hbm:blast"));
        injectMap.put("bypasses_effects.json", List.of("hbm:digamma", "hbm:teleporter", "hbm:cheater", "hbm:black_hole", "hbm:blender", "hbm:meteorite", "hbm:boxcar", "hbm:boat", "hbm:building", "hbm:taint", "hbm:ams", "hbm:ams_core", "hbm:broadcast", "hbm:bang", "hbm:pc", "hbm:cloud", "hbm:lead", "hbm:enervation", "hbm:electricity", "hbm:exhaust", "hbm:lunar", "hbm:monoxide", "hbm:asbestos", "hbm:blacklung", "hbm:mku", "hbm:vacuum", "hbm:overdose", "hbm:microwave", "hbm:nitan"));
        injectMap.put("bypasses_enchantments.json", List.of("hbm:digamma", "hbm:teleporter", "hbm:cheater", "hbm:black_hole", "hbm:blender", "hbm:meteorite", "hbm:boxcar", "hbm:boat", "hbm:building", "hbm:taint", "hbm:ams", "hbm:ams_core", "hbm:broadcast", "hbm:bang", "hbm:pc", "hbm:cloud", "hbm:lead", "hbm:enervation", "hbm:electricity", "hbm:exhaust", "hbm:lunar", "hbm:monoxide", "hbm:asbestos", "hbm:blacklung", "hbm:mku", "hbm:vacuum", "hbm:overdose", "hbm:microwave", "hbm:nitan"));
        injectMap.put("bypasses_invulnerability.json", List.of("hbm:digamma", "hbm:teleporter", "hbm:cheater", "hbm:black_hole", "hbm:blender", "hbm:meteorite", "hbm:boxcar", "hbm:boat", "hbm:building", "hbm:taint", "hbm:ams", "hbm:ams_core", "hbm:broadcast", "hbm:bang", "hbm:pc", "hbm:cloud", "hbm:lead", "hbm:enervation", "hbm:electricity", "hbm:exhaust", "hbm:lunar", "hbm:monoxide", "hbm:asbestos", "hbm:blacklung", "hbm:mku", "hbm:vacuum", "hbm:overdose", "hbm:microwave", "hbm:nitan"));
        injectMap.put("bypasses_resistance.json", List.of("hbm:digamma", "hbm:teleporter", "hbm:cheater", "hbm:black_hole", "hbm:blender", "hbm:meteorite", "hbm:boxcar", "hbm:boat", "hbm:building", "hbm:taint", "hbm:ams", "hbm:ams_core", "hbm:broadcast", "hbm:bang", "hbm:pc", "hbm:cloud", "hbm:lead", "hbm:enervation", "hbm:electricity", "hbm:exhaust", "hbm:lunar", "hbm:monoxide", "hbm:asbestos", "hbm:blacklung", "hbm:mku", "hbm:vacuum", "hbm:overdose", "hbm:microwave", "hbm:nitan"));
        injectMap.put("bypasses_shield.json", List.of("hbm:digamma", "hbm:teleporter", "hbm:cheater", "hbm:black_hole", "hbm:blender", "hbm:meteorite", "hbm:boxcar", "hbm:boat", "hbm:building", "hbm:taint", "hbm:ams", "hbm:ams_core", "hbm:broadcast", "hbm:bang", "hbm:pc", "hbm:cloud", "hbm:lead", "hbm:enervation", "hbm:electricity", "hbm:exhaust", "hbm:lunar", "hbm:monoxide", "hbm:asbestos", "hbm:blacklung", "hbm:mku", "hbm:vacuum", "hbm:overdose", "hbm:microwave", "hbm:nitan"));
        injectMap.put("is_projectile.json", List.of("hbm:suicide", "hbm:rubble", "hbm:shrapnel", "hbm:revolver_bullet", "hbm:chopper_bullet", "hbm:tau", "hbm:cmb", "hbm:sub_atomic"));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (Stream<Path> paths = Files.walk(tagsFolder, new FileVisitOption[0]);){
            for (Path path : paths.collect(Collectors.toList())) {
                if (!Files.isRegularFile(path, new LinkOption[0]) || !path.toString().endsWith(".json")) continue;
                String fileName = path.getFileName().toString();
                System.out.println("Checking injection map for file: " + fileName);
                if (!injectMap.containsKey(fileName)) continue;
                System.out.println("Found " + ((List)injectMap.get(fileName)).size() + " resource locations to inject into " + fileName);
                JsonObject json = (JsonObject)gson.fromJson(Files.readString(path), JsonObject.class);
                if (!json.has("values") || !json.get("values").isJsonArray()) continue;
                JsonArray values = json.getAsJsonArray("values");
                List toInject = (List)injectMap.get(fileName);
                for (String id : toInject) {
                    boolean alreadyPresent = false;
                    for (JsonElement element : values) {
                        if (!element.isJsonPrimitive() || !element.getAsString().equals(id)) continue;
                        alreadyPresent = true;
                        break;
                    }
                    if (alreadyPresent) continue;
                    values.add(id);
                }
                Files.writeString(path, (CharSequence)gson.toJson((JsonElement)json), new OpenOption[0]);
            }
        }
    }
}

