/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.nucleartech.block.RegisterBlocks;
import com.hbm.nucleartech.datagen.ModItemTagGenerator;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.recipe.RegisterRecipes;
import com.hbm.nucleartech.util.FloatingLong;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final List<ItemLike> TITANIUM_SMELTABLES = List.of((ItemLike)RegisterBlocks.TITANIUM_ORE.get(), (ItemLike)RegisterBlocks.DEEPSLATE_TITANIUM_ORE.get(), (ItemLike)RegisterItems.RAW_TITANIUM.get());
    private static final List<ItemLike> URANIUM_SMELTABLES = List.of((ItemLike)RegisterBlocks.URANIUM_ORE.get(), (ItemLike)RegisterBlocks.DEEPSLATE_URANIUM_ORE.get(), (ItemLike)RegisterItems.RAW_URANIUM.get(), (ItemLike)RegisterItems.URANIUM_CRYSTAL.get());

    public ModRecipeProvider(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        ModRecipeProvider.m_246272_(consumer, TITANIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)RegisterItems.TITANIUM_INGOT.get(), 0.7f, 200, "ingot_titanium");
        ModRecipeProvider.m_245412_(consumer, TITANIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)RegisterItems.TITANIUM_INGOT.get(), 0.7f, 100, "ingot_titanium");
        ModRecipeProvider.m_246272_(consumer, URANIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)RegisterItems.URANIUM_INGOT.get(), 1.0f, 200, "ingot_uranium");
        ModRecipeProvider.m_245412_(consumer, URANIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)RegisterItems.URANIUM_INGOT.get(), 1.0f, 100, "ingot_uranium");
        ModRecipeProvider.platePressing(consumer, (ItemLike)Items.f_42416_, (ItemLike)RegisterItems.IRON_PLATE.get());
        List<Pair<ItemLike, MetaData>> results = List.of(Pair.of((Object)((ItemLike)RegisterItems.RAW_THORIUM.get()), (Object)new MetaData(1, 1, 100)), Pair.of((Object)Items.f_42461_, (Object)new MetaData(0, 2, 100)), Pair.of((Object)Items.f_42587_, (Object)new MetaData(1, 1, 5)), Pair.of((Object)((ItemLike)RegisterItems.THORIUM_POWDER.get()), (Object)new MetaData(1, 1, 2)));
        ModRecipeProvider.itemShredding(consumer, (ItemLike)RegisterItems.THORIUM_SHALE.get(), results, FloatingLong.create(13.9), 60);
        results = List.of(Pair.of((Object)((ItemLike)RegisterItems.THORIUM_POWDER.get()), (Object)new MetaData(1, 1, 100)));
        ModRecipeProvider.itemShredding(consumer, (ItemLike)RegisterItems.THORIUM_INGOT.get(), results, FloatingLong.create(20.83), 80);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterBlocks.TITANIUM_BLOCK.get())).m_126130_("TTT").m_126130_("TTT").m_126130_("TTT").m_126127_(Character.valueOf('T'), (ItemLike)RegisterItems.TITANIUM_INGOT.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.TITANIUM_INGOT.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.TITANIUM_INGOT.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterBlocks.TITANIUM_BLOCK.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.TITANIUM_INGOT.get())));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterBlocks.URANIUM_BLOCK.get())).m_126130_("UUU").m_126130_("UUU").m_126130_("UUU").m_126127_(Character.valueOf('U'), (ItemLike)RegisterItems.URANIUM_INGOT.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterBlocks.URANIUM_BLOCK.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())).m_126130_("NNN").m_126130_("NNN").m_126130_("NNN").m_126127_(Character.valueOf('N'), (ItemLike)RegisterItems.URANIUM_NUGGET.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_NUGGET.get())));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.URANIUM_PILE_ROD.get())).m_126130_(" B ").m_126130_("PBP").m_126130_(" B ").m_126127_(Character.valueOf('B'), (ItemLike)RegisterItems.URANIUM_BILLET.get()).m_126127_(Character.valueOf('P'), (ItemLike)RegisterItems.IRON_PLATE.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_PILE_ROD.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get())) + "_and_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.IRON_PLATE.get())));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.TITANIUM_INGOT.get()), (int)9).m_126209_((ItemLike)RegisterBlocks.TITANIUM_BLOCK.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterBlocks.TITANIUM_BLOCK.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterBlocks.TITANIUM_BLOCK.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.TITANIUM_INGOT.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterBlocks.TITANIUM_BLOCK.get())));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get()), (int)9).m_126209_((ItemLike)RegisterBlocks.URANIUM_BLOCK.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterBlocks.URANIUM_BLOCK.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterBlocks.URANIUM_BLOCK.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterBlocks.URANIUM_BLOCK.get())));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.URANIUM_NUGGET.get()), (int)9).m_126209_((ItemLike)RegisterItems.URANIUM_INGOT.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_NUGGET.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get()), (int)3).m_126211_((ItemLike)RegisterItems.URANIUM_INGOT.get(), 2).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get()), (int)2).m_126211_((ItemLike)RegisterItems.URANIUM_BILLET.get(), 3).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_INGOT.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get())));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegisterItems.URANIUM_NUGGET.get()), (int)6).m_126209_((ItemLike)RegisterItems.URANIUM_BILLET.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get()))).m_176500_(consumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_NUGGET.get())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)((ItemLike)RegisterItems.URANIUM_BILLET.get())));
    }

    private static String getItemId(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if (id == null) {
            throw new IllegalStateException("Item not registered: " + String.valueOf(item));
        }
        return id.toString();
    }

    private static String getItemPath(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if (id == null) {
            throw new IllegalStateException("Item not registered: " + String.valueOf(item));
        }
        return id.m_135815_();
    }

    protected static void m_246272_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        ModRecipeProvider.m_245809_(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void m_245412_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.m_245809_(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static void m_245809_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeSerializer<? extends AbstractCookingRecipe> pCookingSerializer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer).m_126145_(pGroup).m_126132_(ModRecipeProvider.m_176602_((ItemLike)itemlike), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)itemlike)).m_176500_(pFinishedRecipeConsumer, "hbm:" + ModRecipeProvider.m_176632_((ItemLike)pResult) + pRecipeName + "_" + ModRecipeProvider.m_176632_((ItemLike)itemlike));
        }
    }

    protected static void itemShredding(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ItemLike pInput, List<Pair<ItemLike, MetaData>> pResults, FloatingLong pPowerConsumption, int pTicks) {
        pFinishedRecipeConsumer.accept(new ShredderRecipeBuilder(pInput, pResults, pPowerConsumption, pTicks));
    }

    protected static void platePressing(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ItemLike pInput, ItemLike pResult) {
        for (ItemLike itemLike : ModItemTagGenerator.SharedTagLists.PLATE_STAMPS) {
            pFinishedRecipeConsumer.accept(new PressRecipeBuilder(pInput, itemLike, pResult));
        }
    }

    public static class MetaData {
        protected final int minCount;
        protected final int maxCount;
        protected final int chance;

        public MetaData(int minCount, int maxCount, int chance) {
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.chance = chance;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public int getChance() {
            return this.chance;
        }
    }

    public record ShredderRecipeBuilder(ItemLike input, List<Pair<ItemLike, MetaData>> results, FloatingLong powerConsumption, int ticks) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.addProperty("type", "hbm:shredder");
            json.add("ingredient", Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.input}).m_43942_());
            JsonArray resultsArray = new JsonArray();
            for (Pair<ItemLike, MetaData> stack : this.results) {
                System.err.println(ModRecipeProvider.m_176632_((ItemLike)((ItemLike)((ItemLike)stack.left()).m_5456_())));
                JsonObject jsonResult = new JsonObject();
                jsonResult.addProperty("item", ModRecipeProvider.getItemId(((ItemLike)stack.left()).m_5456_()));
                JsonObject metaData = new JsonObject();
                metaData.addProperty("min_amount", (Number)((MetaData)stack.right()).getMinCount());
                metaData.addProperty("max_amount", (Number)((MetaData)stack.right()).getMaxCount());
                metaData.addProperty("chance", (Number)((MetaData)stack.right()).getChance());
                jsonResult.add("metadata", (JsonElement)metaData);
                resultsArray.add((JsonElement)jsonResult);
            }
            json.add("results", (JsonElement)resultsArray);
            json.addProperty("power_consumption", this.powerConsumption.toString());
            json.addProperty("ticks", (Number)this.ticks);
        }

        public ResourceLocation m_6445_() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)(ModRecipeProvider.m_176632_((ItemLike)((ItemLike)((ItemLike)this.results.get(0).left()).m_5456_())) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)this.input) + "_with_shredder"));
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegisterRecipes.SHREDDER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public record PressRecipeBuilder(ItemLike input, ItemLike stamp, ItemLike result) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.addProperty("type", "hbm:press");
            ItemLike[] ingredients = new ItemLike[]{this.stamp, this.input};
            JsonArray jsonIngredients = new JsonArray();
            for (int i = 0; i < 2; ++i) {
                jsonIngredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredients[i]}).m_43942_());
            }
            json.add("ingredients", (JsonElement)jsonIngredients);
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("count", (Number)1);
            jsonResult.addProperty("item", ModRecipeProvider.getItemId(this.result.m_5456_()));
            json.add("result", (JsonElement)jsonResult);
        }

        public ResourceLocation m_6445_() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)(ModRecipeProvider.m_176632_((ItemLike)this.result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)this.input) + "_with_" + ModRecipeProvider.m_176632_((ItemLike)this.stamp) + "_press"));
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegisterRecipes.PRESS.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

