/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.handler;

import com.hbm.nucleartech.item.special.ItemArmorMod;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class ArmorModHandler {
    public static final ArmorItem.Type helmet_only = ArmorItem.Type.HELMET;
    public static final ArmorItem.Type plate_only = ArmorItem.Type.CHESTPLATE;
    public static final ArmorItem.Type legs_only = ArmorItem.Type.LEGGINGS;
    public static final ArmorItem.Type boots_only = ArmorItem.Type.BOOTS;
    public static final ArmorItem.Type servos = ArmorItem.Type.CHESTPLATE;
    public static final ArmorItem.Type cladding = ArmorItem.Type.CHESTPLATE;
    public static final ArmorItem.Type kevlar = ArmorItem.Type.CHESTPLATE;
    public static final ArmorItem.Type extra = ArmorItem.Type.CHESTPLATE;
    public static final UUID[] UUIDs = new UUID[]{UUID.fromString("8d6e5c77-133e-4056-9c80-a9e42a1a0b65"), UUID.fromString("b1b7ee0e-1d14-4400-8037-f7f2e02f21ca"), UUID.fromString("30b50d2a-4858-4e5b-88d4-3e3612224238"), UUID.fromString("426ee0d0-7587-4697-aaef-4772ab202e78")};
    public static final UUID[] fixedUUIDs = new UUID[]{UUID.fromString("e572caf4-3e65-4152-bc79-c4d4048cbd29"), UUID.fromString("bed30902-8a6a-4769-9f65-2a9b67469fff"), UUID.fromString("baebf7b3-1eda-4a14-b233-068e2493e9a2"), UUID.fromString("28016c1b-d992-4324-9409-a9f9f0ffb85c")};
    public static final String MOD_COMPOUND_KEY = "ntm_armor_mods";
    public static final String MOD_SLOT_KEY = "mod_slot_";

    public static boolean isApplicable(ItemStack armor, ItemStack mod) {
        if (armor == null || mod == null) {
            return false;
        }
        if (!(armor.m_41720_() instanceof ArmorItem)) {
            return false;
        }
        if (!(mod.m_41720_() instanceof ItemArmorMod)) {
            return false;
        }
        EquipmentSlot type = ((ArmorItem)armor.m_41720_()).m_40402_();
        ItemArmorMod aMod = (ItemArmorMod)mod.m_41720_();
        return type == EquipmentSlot.HEAD && aMod.helmet || type == EquipmentSlot.CHEST && aMod.chestplate || type == EquipmentSlot.LEGS && aMod.leggings || type == EquipmentSlot.FEET && aMod.boots;
    }

    public static void applyMod(ItemStack armor, ItemStack mod) {
        if (armor.m_41619_() || mod.m_41619_()) {
            return;
        }
        CompoundTag root = armor.m_41784_();
        CompoundTag mods = root.m_128425_(MOD_COMPOUND_KEY, 10) ? root.m_128469_(MOD_COMPOUND_KEY) : new CompoundTag();
        root.m_128365_(MOD_COMPOUND_KEY, (Tag)mods);
        CompoundTag modNbt = new CompoundTag();
        mod.m_41739_(modNbt);
        int slot = ((ItemArmorMod)mod.m_41720_()).type.m_266308_().m_20749_();
        mods.m_128365_(MOD_SLOT_KEY + slot, (Tag)modNbt);
    }

    public static void removeMod(ItemStack armor, int slot) {
        if (armor.m_41619_()) {
            return;
        }
        CompoundTag root = armor.m_41783_();
        if (root == null || !root.m_128425_(MOD_COMPOUND_KEY, 10)) {
            return;
        }
        CompoundTag mods = root.m_128469_(MOD_COMPOUND_KEY);
        mods.m_128473_(MOD_SLOT_KEY + slot);
        if (mods.m_128456_()) {
            root.m_128473_(MOD_COMPOUND_KEY);
            if (root.m_128456_()) {
                armor.m_41751_(null);
            }
        } else {
            root.m_128365_(MOD_COMPOUND_KEY, (Tag)mods);
        }
    }

    public static void clearMods(ItemStack armor) {
        if (armor.m_41619_()) {
            return;
        }
        CompoundTag root = armor.m_41783_();
        if (root == null || !root.m_128425_(MOD_COMPOUND_KEY, 10)) {
            return;
        }
        root.m_128473_(MOD_COMPOUND_KEY);
        if (root.m_128456_()) {
            armor.m_41751_(null);
        }
    }

    public static boolean hasMods(ItemStack armor) {
        if (armor.m_41619_()) {
            return false;
        }
        CompoundTag root = armor.m_41783_();
        return root != null && root.m_128425_(MOD_COMPOUND_KEY, 10);
    }

    public static ItemStack[] pryMods(ItemStack armor) {
        Object[] slots = new ItemStack[8];
        Arrays.fill(slots, ItemStack.f_41583_);
        if (!ArmorModHandler.hasMods(armor)) {
            return slots;
        }
        CompoundTag root = armor.m_41783_();
        CompoundTag mods = root.m_128469_(MOD_COMPOUND_KEY);
        for (int i = 0; i < slots.length; ++i) {
            String key = MOD_SLOT_KEY + i;
            if (!mods.m_128425_(key, 10)) continue;
            CompoundTag modTag = mods.m_128469_(key);
            slots[i] = ItemStack.m_41712_((CompoundTag)modTag);
        }
        return slots;
    }

    public static ItemStack pryMod(ItemStack armor, int slot) {
        String key;
        if (!ArmorModHandler.hasMods(armor)) {
            return ItemStack.f_41583_;
        }
        CompoundTag mods = armor.m_41783_().m_128469_(MOD_COMPOUND_KEY);
        if (!mods.m_128425_(key = MOD_SLOT_KEY + slot, 10)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)mods.m_128469_(key));
    }
}

