/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.handler;

import com.hbm.nucleartech.Config;
import com.hbm.nucleartech.HBM;
import com.hbm.nucleartech.block.RegisterBlocks;
import com.hbm.nucleartech.handler.RadiationSystemChunksNT;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncChunkProcessor {
    private static final int QUEUE_CAPACITY = 16;
    private static final long QUEUE_TIMEOUT_MS = 500L;
    private static final ThreadFactory threadFactory = r -> {
        Thread t = new Thread(r, "Radiation Chunk Processor");
        t.setDaemon(true);
        t.setUncaughtExceptionHandler((thread, throwable) -> {
            System.err.println("Uncaught exception in " + thread.getName() + ": " + throwable.getMessage());
            throwable.printStackTrace();
        });
        return t;
    };
    private static final ExecutorService executorService = new ThreadPoolExecutor(AsyncChunkProcessor.getMaxConcurrentChunks(), AsyncChunkProcessor.getMaxConcurrentChunks(), 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(16), threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy()){

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
        }
    };
    private static final Map<net.minecraft.world.level.ChunkPos, ProcessChunkTask> pendingTasks = new ConcurrentHashMap<net.minecraft.world.level.ChunkPos, ProcessChunkTask>();

    private static int getMaxConcurrentChunks() {
        return Math.max(1, Config.concurrentChunkThreads);
    }

    public static void queueChunkForProcessing(ServerLevel world, LevelChunk chunk, int sectionY, RadiationSystemChunksNT.RadPocket pocket) {
        if (chunk == null || world == null || pocket == null) {
            return;
        }
        net.minecraft.world.level.ChunkPos chunkPos = new net.minecraft.world.level.ChunkPos(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        if (pendingTasks.containsKey(chunkPos)) {
            return;
        }
        ProcessChunkTask task = new ProcessChunkTask(world, chunk, sectionY, pocket);
        pendingTasks.put(chunkPos, task);
        try {
            world.m_7654_().execute((Runnable)task);
        }
        catch (Exception e) {
            pendingTasks.remove(chunkPos);
            HBM.LOGGER.error("Failed to schedule chunk processing on server thread for chunk ({}, {})", new Object[]{chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, e});
        }
    }

    public static void shutdown() {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class ProcessChunkTask
    implements Runnable {
        private static final Logger LOGGER = LogManager.getLogger(ProcessChunkTask.class);
        final ServerLevel world;
        final LevelChunk chunk;
        final int sectionY;
        final RadiationSystemChunksNT.RadPocket pocket;
        final LevelChunkSection section;

        ProcessChunkTask(ServerLevel world, LevelChunk chunk, int sectionY, RadiationSystemChunksNT.RadPocket pocket) {
            this.world = world;
            this.chunk = chunk;
            this.sectionY = sectionY;
            this.pocket = pocket;
            this.section = chunk.m_7103_()[sectionY];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<BlockPos> blocksToUpdate = new ArrayList<BlockPos>();
                int chunkX = this.chunk.m_7697_().f_45578_;
                int chunkZ = this.chunk.m_7697_().f_45579_;
                int baseY = this.world.m_141937_() + (this.sectionY << 4);
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int worldZ;
                            int worldY;
                            int worldX;
                            BlockPos worldPos;
                            BlockState state = this.section.m_62982_(x, y, z);
                            if (state.m_60795_() || state.m_60734_() != Blocks.f_50440_ && state.m_60734_() != Blocks.f_50599_ || this.pocket.parent.getPocket(worldPos = new BlockPos(worldX = (chunkX << 4) + x, worldY = baseY + y, worldZ = (chunkZ << 4) + z)) != this.pocket || this.world.f_46441_.m_188503_(100) <= 60) continue;
                            blocksToUpdate.add(worldPos);
                        }
                    }
                }
                if (!blocksToUpdate.isEmpty()) {
                    int updated = 0;
                    for (BlockPos pos : blocksToUpdate) {
                        if (this.world.m_8055_(pos).m_60734_() != Blocks.f_50440_) continue;
                        this.world.m_7731_(pos, ((Block)RegisterBlocks.DEAD_GRASS.get()).m_49966_(), 2);
                        ++updated;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing chunk at ({}, {})", (Object)this.chunk.m_7697_().f_45578_, (Object)this.chunk.m_7697_().f_45579_, (Object)e);
            }
            finally {
                pendingTasks.remove(new net.minecraft.world.level.ChunkPos(this.chunk.m_7697_().f_45578_, this.chunk.m_7697_().f_45579_));
            }
        }
    }

    private static class ChunkPos {
        public final int x;
        public final int z;

        public ChunkPos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkPos chunkPos = (ChunkPos)o;
            return this.x == chunkPos.x && this.z == chunkPos.z;
        }

        public int hashCode() {
            return 31 * this.x + this.z;
        }
    }
}

