/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.handler;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.nucleartech.HBM;
import com.hbm.nucleartech.handler.ArmorModHandler;
import com.hbm.nucleartech.handler.ItemModCladding;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.util.ShadyUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class HazmatRegistry {
    private static HashMap<Item, Double> entries = new HashMap();
    public static final Gson gson = new Gson();

    public static void initDefault() {
        double helmet = 0.2;
        double chest = 0.4;
        double legs = 0.3;
        double boots = 0.1;
        double iron = 0.0225;
        double gold = 0.0225;
        double netherite = 1.0;
        double hazYellow = 0.6;
        double hazRed = 1.0;
        double hazGray = 2.0;
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_HELMET.get(), hazYellow * helmet);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_CHESTPLATE.get(), hazYellow * chest);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_LEGGINGS.get(), hazYellow * legs);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_BOOTS.get(), hazYellow * boots);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_HELMET_RED.get(), hazRed * helmet);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_CHESTPLATE_RED.get(), hazRed * chest);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_LEGGINGS_RED.get(), hazRed * legs);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_BOOTS_RED.get(), hazRed * boots);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_HELMET_GREY.get(), hazGray * helmet);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_CHESTPLATE_GREY.get(), hazGray * chest);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_LEGGINGS_GREY.get(), hazGray * legs);
        HazmatRegistry.registerHazmat((Item)RegisterItems.HAZMAT_BOOTS_GREY.get(), hazGray * boots);
        HazmatRegistry.registerHazmat(Items.f_42468_, iron * helmet);
        HazmatRegistry.registerHazmat(Items.f_42469_, iron * chest);
        HazmatRegistry.registerHazmat(Items.f_42470_, iron * legs);
        HazmatRegistry.registerHazmat(Items.f_42471_, iron * boots);
        HazmatRegistry.registerHazmat(Items.f_42476_, gold * helmet);
        HazmatRegistry.registerHazmat(Items.f_42477_, gold * chest);
        HazmatRegistry.registerHazmat(Items.f_42478_, gold * legs);
        HazmatRegistry.registerHazmat(Items.f_42479_, gold * boots);
        HazmatRegistry.registerHazmat(Items.f_42480_, netherite * helmet);
        HazmatRegistry.registerHazmat(Items.f_42481_, netherite * chest);
        HazmatRegistry.registerHazmat(Items.f_42482_, netherite * legs);
        HazmatRegistry.registerHazmat(Items.f_42483_, netherite * boots);
    }

    public static void registerHazmat(Item item, double resistance) {
        entries.put(item, resistance);
    }

    public static double getResistance(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        double cladding = HazmatRegistry.getCladding(stack);
        Double f = entries.get(stack.m_41720_());
        if (f != null) {
            return f + cladding;
        }
        return cladding;
    }

    public static double getCladding(ItemStack stack) {
        ItemStack[] mods;
        ItemStack cladding;
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            if (stack.m_41783_().m_128457_("hfr_cladding") > 0.0f) {
                return stack.m_41783_().m_128457_("hfr_cladding");
            }
        }
        if (ArmorModHandler.hasMods(stack) && (cladding = (mods = ArmorModHandler.pryMods(stack))[ArmorModHandler.cladding.ordinal()]) != null && cladding.m_41720_() instanceof ItemModCladding) {
            return ((ItemModCladding)cladding.m_41720_()).rad;
        }
        return 0.0;
    }

    public static float getResistance(Player player) {
        float res = 0.0f;
        if (player.m_20149_().equals(ShadyUtil.Pu_238)) {
            res += 0.4f;
        }
        for (int i = 0; i < 4; ++i) {
            res += (float)HazmatRegistry.getResistance(player.m_150109_().m_36052_(i));
        }
        return res;
    }

    public static void registerHazmats() {
        File folder = HBM.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmRadResist.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmRadResist.json");
        HazmatRegistry.initDefault();
        if (!config.exists()) {
            HazmatRegistry.writeDefault(template);
        } else {
            HashMap<Item, Double> conf = HazmatRegistry.readConfig(config);
            if (conf != null) {
                entries.clear();
                entries.putAll(conf);
            }
        }
    }

    private static void writeDefault(File file) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("comment").value("Template file, remove the underscore ('_') from the name to enable the config.");
            writer.name("entries").beginArray();
            for (Map.Entry<Item, Double> entry : entries.entrySet()) {
                writer.beginObject();
                writer.name("item").value(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)entry.getKey())).toString());
                writer.name("resistance").value((Number)entry.getValue());
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HashMap<Item, Double> readConfig(File config) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            JsonArray array = json.get("entries").getAsJsonArray();
            HashMap<Item, Double> conf = new HashMap<Item, Double>();
            for (JsonElement element : array) {
                JsonObject object = (JsonObject)element;
                try {
                    String name = object.get("item").getAsString();
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)name));
                    double resistance = object.get("resistance").getAsDouble();
                    if (item != null) {
                        conf.put(item, resistance);
                        continue;
                    }
                    HBM.LOGGER.error("Tried loading unknown item " + name + " for hazmat entry.");
                }
                catch (Exception e) {
                    HBM.LOGGER.error("Encountered " + String.valueOf(e) + " trying to read hazmat entry " + element.toString());
                }
            }
            return conf;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

