/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.handler;

import com.hbm.nucleartech.handler.ArmorModHandler;
import com.hbm.nucleartech.handler.HazmatRegistry;
import com.hbm.nucleartech.handler.RadiationSystemNT;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.item.custom.BatteryItem;
import com.hbm.nucleartech.item.custom.SelfChargingBatteryItem;
import com.hbm.nucleartech.item.special.ItemArmorMod;
import com.hbm.nucleartech.util.ArmorRegistry;
import com.hbm.nucleartech.util.ContaminationUtil;
import com.hbm.nucleartech.util.I18nUtil;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ItemHandler {
    @SubscribeEvent
    public static void drawTooltip(ItemTooltipEvent event) {
        Item item;
        double rad;
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        boolean leftShiftDown = InputConstants.m_84830_((long)window, (int)340);
        ItemStack stack = event.getItemStack();
        List list = event.getToolTip();
        List hazInfo = ArmorRegistry.hazardClasses.get(stack.m_41720_());
        if (hazInfo != null) {
            if (leftShiftDown) {
                list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.GOLD) + I18nUtil.resolveKey("hazard.prot", new Object[0]))));
                for (ArmorRegistry.HazardClass clazz : hazInfo) {
                    list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "  " + I18nUtil.resolveKey(clazz.lang, new Object[0]))));
                }
            } else {
                list.add(Component.m_237113_((String)I18nUtil.resolveKey("desc.tooltip.hold", "LSHIFT")));
            }
        }
        if ((rad = HazmatRegistry.getResistance(stack)) > 0.0) {
            list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + I18nUtil.resolveKey("trait.rad_resistance", rad))));
        }
        if (stack.m_41720_() instanceof ArmorItem && ArmorModHandler.hasMods(stack)) {
            if (!leftShiftDown) {
                list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_GRAY) + String.valueOf(ChatFormatting.ITALIC) + "Hold <" + String.valueOf(ChatFormatting.YELLOW) + String.valueOf(ChatFormatting.ITALIC) + "LSHIFT" + String.valueOf(ChatFormatting.DARK_GRAY) + String.valueOf(ChatFormatting.ITALIC) + "> to display installed armor mods")));
            } else {
                list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "Mods:")));
                ItemStack[] mods = ArmorModHandler.pryMods(stack);
                for (int i = 0; i < 8; ++i) {
                    if (mods[i] == null || !(mods[i].m_41720_() instanceof ItemArmorMod)) continue;
                    ((ItemArmorMod)mods[i].m_41720_()).addDesc(list, mods[i], stack);
                }
            }
        }
        ContaminationUtil.addNeutronRadInfo(stack, event.getEntity(), list, event.getFlags());
        if (stack.m_41720_() instanceof BatteryItem) {
            list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "Energy stored: " + BatteryItem.formatWattHoursStored(stack) + "/" + BatteryItem.formatMaxWattHoursStored(stack))));
            list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "Charge rate: " + BatteryItem.formatWattsCharge(stack))));
            list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "Discharge rate: " + BatteryItem.formatWattsDischarge(stack))));
        }
        if ((item = stack.m_41720_()) instanceof SelfChargingBatteryItem) {
            SelfChargingBatteryItem sc = (SelfChargingBatteryItem)item;
            if (stack.m_41720_().equals(RegisterItems.INFINITE_FUSION_CORE.get()) || stack.m_41720_().equals(RegisterItems.CREATIVE_BATTERY.get())) {
                list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "Discharge rate: \u221eW")));
            } else {
                list.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "Discharge rate: " + sc.formatWattsDischarge())));
            }
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Level level = event.level;
            for (Player p : level.m_6907_()) {
                LevelChunk chunk = level.m_46745_(p.m_20097_());
                AABB aabb = RadiationSystemNT.getAabb(level, chunk.m_7697_());
                List items = level.m_45976_(ItemEntity.class, aabb);
                if (items.isEmpty()) continue;
                for (ItemEntity i : items) {
                    float neutronRads = ContaminationUtil.getNeutronRads(i.m_32055_());
                    if (neutronRads == 0.0f) continue;
                    ContaminationUtil.radiate((ServerLevel)level, (double)i.m_20097_().m_123341_() + 0.5, i.m_20097_().m_123342_() + 1, (double)i.m_20097_().m_123343_() + 0.5, 5.0, (float)((double)neutronRads * 4.0E-5 - 8.0E-4), i.m_20097_().m_7918_(0, 1, 0));
                }
            }
        }
    }
}

