/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hbm.nucleartech.HBM;
import com.hbm.nucleartech.handler.RadiationSystemNT;
import com.hbm.nucleartech.hazard.HazardBlock;
import com.hbm.nucleartech.interfaces.IRadResistantBlock;
import com.hbm.nucleartech.item.custom.GeigerCounterItem;
import com.hbm.nucleartech.util.ContaminationUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RadiationSystemChunksNT {
    private static final Set<RadPocket> activePockets = new HashSet<RadPocket>();
    private static int ticks;
    public static final Capability<IChunkRadiation> CHUNK_RAD_CAPABILITY;
    private static RadPocket[] pocketsByBlock;
    private static BlockPos[] blocksByPocket;
    private static final Queue<BlockPos> stack;

    public static Set<RadPocket> getActivePockets() {
        return activePockets;
    }

    public static void addActivePocket(RadPocket pocket) {
        activePockets.add(pocket);
    }

    public static void removeActivePocket(RadPocket pocket) {
        activePockets.remove(pocket);
    }

    public static void clearActivePockets() {
        activePockets.clear();
    }

    public static boolean isSubChunkLoaded(Level level, BlockPos pos) {
        if (pos.m_123342_() > 319 || pos.m_123342_() < -64) {
            return false;
        }
        if (!level.m_7726_().m_5563_(pos.m_123341_() >> 4, pos.m_123343_() >> 4)) {
            return false;
        }
        AtomicReference stAtomic = new AtomicReference();
        level.m_46745_(pos).getCapability(CHUNK_RAD_CAPABILITY, null).ifPresent(stAtomic::set);
        IChunkRadiation st = (IChunkRadiation)stAtomic.get();
        if (st == null) {
            return false;
        }
        SubChunkRadiationStorage sc = st.getForYLevel(pos.m_123342_());
        return sc != null;
    }

    public static RadPocket getPocket(Level world, BlockPos pos) {
        return RadiationSystemChunksNT.getSubChunkStorage(world, pos).getPocket(pos);
    }

    public static SubChunkRadiationStorage getSubChunkStorage(Level level, BlockPos pos) {
        ChunkRadiationStorage st = RadiationSystemChunksNT.getChunkStorage(level, pos);
        SubChunkRadiationStorage sc = st.instance.getForYLevel(pos.m_123342_());
        if (sc == null) {
            RadiationSystemChunksNT.rebuildChunkPockets(level.m_46745_(pos), ChunkStorageCompat.getIndexFromWorldY(pos.m_123342_()));
        }
        sc = st.instance.getForYLevel(pos.m_123342_());
        return sc;
    }

    public static SubChunkRadiationStorage getSubChunkStorage(ChunkRadiationStorage st, Integer yLevel, LevelChunk chunk) {
        SubChunkRadiationStorage sc = st.instance.getForYLevel(yLevel);
        if (sc == null) {
            RadiationSystemChunksNT.rebuildChunkPockets(chunk, ChunkStorageCompat.getIndexFromWorldY(yLevel));
        }
        sc = st.instance.getForYLevel(yLevel);
        return sc;
    }

    public static void updateRadiation() {
        long time = System.currentTimeMillis();
        ArrayList<RadPocket> itrActive = new ArrayList<RadPocket>(RadiationSystemChunksNT.getActivePockets());
        Iterator itr = itrActive.iterator();
        while (itr.hasNext()) {
            RadPocket p = (RadPocket)itr.next();
            BlockPos pos = p.parent.parentChunk.getWorldPos(p.parent.yLevel);
            p.radiation *= 0.999f;
            p.radiation -= 0.05f;
            p.parent.parentChunk.chunk.m_8092_(true);
            if (p.radiation <= 0.0f) {
                p.radiation = 0.0f;
                p.accumulatedRads = 0.0f;
                itr.remove();
                p.parent.parentChunk.chunk.m_8092_(true);
                continue;
            }
            float count = 0.0f;
            for (Direction d : Direction.values()) {
                count += (float)p.connectionIndices[d.ordinal()].size();
            }
            float amountPer = 0.7f / count;
            if (count == 0.0f || p.radiation < 1.0f) {
                amountPer = 0.0f;
            }
            if (p.radiation < 1.0f) {
                amountPer = 0.0f;
            }
            if (p.radiation > 0.0f && amountPer > 0.0f) {
                for (Direction e : Direction.values()) {
                    BlockPos nPos = pos.m_5484_(e, 16);
                    if (!p.parent.parentChunk.chunk.m_62953_().m_46749_(nPos) || nPos.m_123342_() < -64 || nPos.m_123342_() > 319) continue;
                    if (p.connectionIndices[e.ordinal()].size() == 1 && p.connectionIndices[e.ordinal()].get(0) == -1) {
                        RadiationSystemChunksNT.rebuildChunkPockets(p.parent.parentChunk.chunk.m_62953_().m_46745_(nPos), ChunkStorageCompat.getIndexFromWorldY(nPos.m_123342_()));
                        continue;
                    }
                    SubChunkRadiationStorage sc2 = RadiationSystemChunksNT.getSubChunkStorage(p.parent.parentChunk.chunk.m_62953_(), nPos);
                    for (int idx : p.connectionIndices[e.ordinal()]) {
                        if (sc2.pockets[idx].isSealed()) continue;
                        sc2.pockets[idx].accumulatedRads += p.radiation * amountPer;
                        RadiationSystemChunksNT.addActivePocket(sc2.pockets[idx]);
                    }
                }
            }
            if (amountPer != 0.0f) {
                p.accumulatedRads += p.radiation * 0.3f;
            }
            if (System.currentTimeMillis() - time <= 20L) continue;
            break;
        }
        ArrayList<RadPocket> itrActiveCheck = new ArrayList<RadPocket>(RadiationSystemChunksNT.getActivePockets());
        itr = itrActiveCheck.iterator();
        while (itr.hasNext()) {
            RadPocket act = (RadPocket)itr.next();
            act.radiation = act.accumulatedRads;
            act.accumulatedRads = 0.0f;
            if (!(act.radiation <= 0.0f)) continue;
            RadiationSystemChunksNT.removeActivePocket(act);
            itr.remove();
        }
    }

    public static void updateEntities(ServerLevel level) {
        if (level != null && !level.f_46443_) {
            HashSet<ChunkPos> processedChunks = new HashSet<ChunkPos>();
            for (Player playerI : level.m_6907_()) {
                ChunkPos playerChunkPos = new ChunkPos(playerI.m_20183_());
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        ChunkPos chunkPos = new ChunkPos(playerChunkPos.f_45578_ + dx, playerChunkPos.f_45579_ + dz);
                        if (!processedChunks.add(chunkPos) || !level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) continue;
                        AABB chunkAABB = RadiationSystemNT.getAabb((Level)level, chunkPos);
                        List entities = level.m_45976_(LivingEntity.class, chunkAABB);
                        for (LivingEntity entity : entities) {
                            RadPocket ePoc = RadiationSystemChunksNT.getPocket((Level)level, entity.m_20097_().m_7918_(0, 1, 0));
                            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, ePoc.radiation);
                        }
                    }
                }
            }
        }
    }

    @Deprecated(since="N/A")
    private static void rebuildChunkPockets(LevelChunk chunk, int yIndex) {
        BlockPos subChunkPos = new BlockPos(chunk.m_7697_().f_45578_ << 4, ChunkStorageCompat.getWorldYFromIndex(yIndex), chunk.m_7697_().f_45579_ << 4);
        ArrayList<RadPocket> pockets = new ArrayList<RadPocket>();
        ChunkStorageCompat.ExtendedBlockStorage blocks = ChunkStorageCompat.getBlockStorageArray(chunk)[yIndex];
        if (pocketsByBlock == null) {
            pocketsByBlock = new RadPocket[4096];
        } else {
            Arrays.fill(pocketsByBlock, null);
        }
        if (blocksByPocket == null) {
            blocksByPocket = new BlockPos[0];
        } else {
            Arrays.fill(blocksByPocket, null);
        }
        ChunkRadiationStorage st = RadiationSystemChunksNT.getChunkStorage(chunk.m_62953_(), subChunkPos);
        SubChunkRadiationStorage subChunk = new SubChunkRadiationStorage(st, subChunkPos.m_123342_(), null, null);
        if (blocks != null) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        if (pocketsByBlock[x * 16 * 16 + y * 16 + z] != null) continue;
                        Block block = blocks.get(x, y, z).m_60734_();
                        BlockPos globalPos = subChunkPos.m_7918_(x, y, z);
                        BlockPos[] old = blocksByPocket;
                        blocksByPocket = new BlockPos[old.length + 1];
                        for (int i = 0; i < old.length; ++i) {
                            RadiationSystemChunksNT.blocksByPocket[i] = old[i];
                        }
                        RadiationSystemChunksNT.blocksByPocket[old.length] = globalPos;
                        if (block instanceof IRadResistantBlock && ((IRadResistantBlock)block).isRadResistant((Level)((ServerLevel)chunk.m_62953_()), globalPos)) continue;
                        pockets.add(RadiationSystemChunksNT.buildPocket(subChunk, chunk.m_62953_(), new BlockPos(x, y, z), subChunkPos, blocks, pocketsByBlock, pockets.size()));
                    }
                }
            }
        } else {
            RadPocket pocket = new RadPocket(subChunk, 0);
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    RadiationSystemChunksNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, 0, y), pocket, Direction.DOWN);
                    RadiationSystemChunksNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, 15, y), pocket, Direction.UP);
                    RadiationSystemChunksNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, y, 0), pocket, Direction.NORTH);
                    RadiationSystemChunksNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, y, 15), pocket, Direction.SOUTH);
                    RadiationSystemChunksNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(0, y, x), pocket, Direction.WEST);
                    RadiationSystemChunksNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(15, y, x), pocket, Direction.EAST);
                }
            }
            pockets.add(pocket);
        }
        subChunk.pocketsByBlock = pockets.size() == 1 ? null : pocketsByBlock;
        BlockPos[] blockPosArray = subChunk.blocksByPocket = pockets.size() == 1 ? null : blocksByPocket;
        if (subChunk.pocketsByBlock != null) {
            pocketsByBlock = null;
        }
        if (subChunk.blocksByPocket != null) {
            blocksByPocket = null;
        }
        subChunk.pockets = pockets.toArray(new RadPocket[pockets.size()]);
        st.instance.setForYLevel(ChunkStorageCompat.getWorldYFromIndex(yIndex), subChunk);
    }

    private static void doEmptyChunk(LevelChunk chunk, BlockPos subChunkPos, BlockPos pos, RadPocket pocket, Direction facing) {
        BlockPos newPos = pos.m_121945_(facing);
        BlockPos outPos = newPos.m_121955_((Vec3i)subChunkPos);
        Block block = chunk.m_62953_().m_8055_(outPos).m_60734_();
        if (!(block instanceof IRadResistantBlock) || !((IRadResistantBlock)block).isRadResistant((Level)((ServerLevel)chunk.m_62953_()), outPos)) {
            if (!RadiationSystemChunksNT.isSubChunkLoaded(chunk.m_62953_(), outPos)) {
                if (!pocket.connectionIndices[facing.ordinal()].contains(-1)) {
                    pocket.connectionIndices[facing.ordinal()].add(-1);
                }
            } else {
                RadPocket outPocket = RadiationSystemChunksNT.getPocket(chunk.m_62953_(), outPos);
                if (!pocket.connectionIndices[facing.ordinal()].contains(outPocket.index)) {
                    pocket.connectionIndices[facing.ordinal()].add(outPocket.index);
                }
            }
        }
    }

    private static RadPocket buildPocket(SubChunkRadiationStorage subChunk, Level level, BlockPos start, BlockPos subChunkWorldPos, ChunkStorageCompat.ExtendedBlockStorage chunk, RadPocket[] pocketsByBlock, int index) {
        RadPocket pocket = new RadPocket(subChunk, index);
        stack.clear();
        stack.add(start);
        while (!stack.isEmpty()) {
            BlockPos pos = stack.poll();
            Block block = chunk.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).m_60734_();
            if (pocketsByBlock[pos.m_123341_() * 16 * 16 + pos.m_123342_() * 16 + pos.m_123343_()] != null) continue;
            pocketsByBlock[pos.m_123341_() * 16 * 16 + pos.m_123342_() * 16 + pos.m_123343_()] = pocket;
            for (Direction facing : Direction.values()) {
                BlockPos newPos = pos.m_121945_(facing);
                if (Math.max(Math.max(newPos.m_123341_(), newPos.m_123342_()), newPos.m_123343_()) > 15 || Math.min(Math.min(newPos.m_123341_(), newPos.m_123342_()), newPos.m_123343_()) < 0) {
                    BlockPos outPos = newPos.m_121955_((Vec3i)subChunkWorldPos);
                    if (outPos.m_123342_() < -64 || outPos.m_123342_() > 319 || (block = level.m_8055_(outPos).m_60734_()) instanceof IRadResistantBlock && ((IRadResistantBlock)block).isRadResistant((Level)((ServerLevel)level), outPos)) continue;
                    if (!RadiationSystemChunksNT.isSubChunkLoaded(level, outPos)) {
                        if (pocket.connectionIndices[facing.ordinal()].contains(-1)) continue;
                        pocket.connectionIndices[facing.ordinal()].add(-1);
                        continue;
                    }
                    RadPocket outPocket = RadiationSystemChunksNT.getPocket(level, outPos);
                    if (pocket.connectionIndices[facing.ordinal()].contains(outPocket.index)) continue;
                    pocket.connectionIndices[facing.ordinal()].add(outPocket.index);
                    continue;
                }
                if (block instanceof IRadResistantBlock && ((IRadResistantBlock)block).isRadResistant((Level)((ServerLevel)level), pos.m_121955_((Vec3i)subChunkWorldPos))) continue;
                stack.add(newPos);
            }
        }
        return pocket;
    }

    public static ChunkRadiationStorage getChunkStorage(Level level, BlockPos pos) {
        AtomicReference stAtomic = new AtomicReference();
        level.m_46745_(pos).getCapability(CHUNK_RAD_CAPABILITY, null).ifPresent(stAtomic::set);
        ChunkRadiationStorage st = ((IChunkRadiation)stAtomic.get()).getParent();
        return st;
    }

    public static ChunkRadiationStorage getChunkStorage(LevelChunk chunk) {
        AtomicReference stAtomic = new AtomicReference();
        chunk.getCapability(CHUNK_RAD_CAPABILITY, null).ifPresent(stAtomic::set);
        ChunkRadiationStorage st = ((IChunkRadiation)stAtomic.get()).getParent();
        return st;
    }

    public static void incrementRad(ServerLevel level, BlockPos pos, float amount, float max) {
        if (pos.m_123342_() < -64 || pos.m_123342_() > 319 || !level.m_46749_(pos)) {
            return;
        }
        RadPocket p = RadiationSystemChunksNT.getPocket((Level)level, pos);
        if (p.radiation < max) {
            p.radiation += amount;
        }
        if (amount > 0.0f) {
            RadiationSystemChunksNT.addActivePocket(p);
        }
    }

    public static void decrementRad(ServerLevel level, BlockPos pos, float amount) {
        if (pos.m_123342_() < -64 || pos.m_123342_() > 319 || !level.m_46749_(pos)) {
            return;
        }
        RadPocket p = RadiationSystemChunksNT.getPocket((Level)level, pos);
        p.radiation -= Math.max(amount, 0.0f);
        if (p.radiation < 0.0f) {
            p.radiation = 0.0f;
        }
    }

    public static void setRadForCoord(ServerLevel level, BlockPos pos, float amount) {
        RadPocket p = RadiationSystemChunksNT.getPocket((Level)level, pos);
        p.radiation = Math.max(amount, 0.0f);
        if (amount > 0.0f) {
            RadiationSystemChunksNT.addActivePocket(p);
        }
    }

    public static float getRadForCoord(Level level, BlockPos pos) {
        if (!RadiationSystemChunksNT.isSubChunkLoaded(level, pos)) {
            return 0.0f;
        }
        if (RadiationSystemChunksNT.getPocket(level, pos) == null) {
            return 0.0f;
        }
        return RadiationSystemChunksNT.getPocket((Level)level, (BlockPos)pos).radiation;
    }

    static {
        CHUNK_RAD_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkRadiation>(){});
        pocketsByBlock = null;
        blocksByPocket = null;
        stack = new ArrayDeque<BlockPos>(1024);
    }

    public static interface IChunkRadiation {
        public ChunkRadiationStorage getParent();

        public void setParent(ChunkRadiationStorage var1);

        public SubChunkRadiationStorage getForYLevel(int var1);

        public void setForYLevel(int var1, SubChunkRadiationStorage var2);

        public void setInitialized();

        public boolean wasInitialized();

        public void unload();

        public CompoundTag serializeNBT();

        public void deserializeNBT(CompoundTag var1);
    }

    public static class SubChunkRadiationStorage {
        public final ChunkRadiationStorage parentChunk;
        public final int yLevel;
        public RadPocket[] pockets;
        public RadPocket[] pocketsByBlock;
        public BlockPos[] blocksByPocket;
        BlockPos subChunkPos;

        public SubChunkRadiationStorage(ChunkRadiationStorage parent, int yLevel, RadPocket[] pockets, RadPocket[] pocketsByBlock) {
            this.parentChunk = parent;
            this.yLevel = yLevel;
            this.pocketsByBlock = pocketsByBlock;
            this.pockets = pockets;
            this.subChunkPos = new BlockPos(this.parentChunk.chunk.m_7697_().f_45578_ << 4, yLevel, this.parentChunk.chunk.m_7697_().f_45579_ << 4);
        }

        public BlockPos getBlock(Integer pIndex) {
            if (this.blocksByPocket == null) {
                return this.subChunkPos;
            }
            if (this.blocksByPocket.length > pIndex) {
                BlockPos pos = this.blocksByPocket[pIndex];
                if (pos == null) {
                    if (this.blocksByPocket[0] != null) {
                        return this.blocksByPocket[0];
                    }
                    this.blocksByPocket[0] = pos = this.subChunkPos;
                    return pos;
                }
                return pos;
            }
            return this.subChunkPos;
        }

        public RadPocket getPocket(BlockPos pos) {
            int z;
            int y;
            if (this.pocketsByBlock == null) {
                return this.pockets[0];
            }
            int x = pos.m_123341_() & 0xF;
            RadPocket p = this.pocketsByBlock[x * 16 * 16 + (y = pos.m_123342_() & 0xF) * 16 + (z = pos.m_123343_() & 0xF)];
            if (p == null) {
                if (this.pockets != null && this.pockets.length > 0 && this.pockets[0] != null) {
                    return this.pockets[0];
                }
                p = new RadPocket(this, 0);
                p.radiation = 0.0f;
                if (this.pockets == null || this.pockets.length == 0) {
                    this.pockets = new RadPocket[1];
                }
                this.pockets[0] = p;
                return p;
            }
            return p;
        }

        public void setRad(SubChunkRadiationStorage other) {
            float total = 0.0f;
            for (RadPocket p : other.pockets) {
                if (p.isSealed()) continue;
                total += p.radiation;
            }
            float radPer = total / (float)this.pockets.length;
            for (RadPocket p : this.pockets) {
                p.radiation = radPer;
                if (!(radPer > 0.0f)) continue;
                RadiationSystemChunksNT.addActivePocket(p);
            }
        }

        public void remove(Level level, BlockPos pos) {
            for (RadPocket radPocket : this.pockets) {
                radPocket.remove();
            }
            for (RadPocket radPocket : Direction.values()) {
                level.m_8055_(pos.m_5484_((Direction)radPocket, 16));
                if (!RadiationSystemChunksNT.isSubChunkLoaded(level, pos.m_5484_((Direction)radPocket, 16))) continue;
                SubChunkRadiationStorage sc = RadiationSystemChunksNT.getSubChunkStorage(level, pos.m_5484_((Direction)radPocket, 16));
                for (RadPocket p : sc.pockets) {
                    p.connectionIndices[radPocket.m_122424_().ordinal()].clear();
                }
            }
        }

        public void add(Level world, BlockPos pos) {
            for (Direction e : Direction.values()) {
                world.m_8055_(pos.m_5484_(e, 16));
                if (!RadiationSystemChunksNT.isSubChunkLoaded(world, pos.m_5484_(e, 16))) continue;
                SubChunkRadiationStorage sc = RadiationSystemChunksNT.getSubChunkStorage(world, pos.m_5484_(e, 16));
                for (RadPocket p : sc.pockets) {
                    p.connectionIndices[e.m_122424_().ordinal()].clear();
                }
                for (RadPocket p : this.pockets) {
                    List<Integer> indc = p.connectionIndices[e.ordinal()];
                    for (int idx : indc) {
                        sc.pockets[idx].connectionIndices[e.m_122424_().ordinal()].add(p.index);
                    }
                }
            }
        }
    }

    public static class RadPocket {
        public final SubChunkRadiationStorage parent;
        public final int index;
        public float radiation = 0.0f;
        public float accumulatedRads = 0.0f;
        public final List<Integer>[] connectionIndices = new ArrayList[Direction.values().length];

        public RadPocket(SubChunkRadiationStorage parent, int index) {
            this.parent = parent;
            this.index = index;
            for (int i = 0; i < Direction.values().length; ++i) {
                this.connectionIndices[i] = new ArrayList<Integer>(1);
            }
        }

        protected void remove() {
            for (Direction d : Direction.values()) {
                this.connectionIndices[d.ordinal()].clear();
            }
            RadiationSystemChunksNT.removeActivePocket(this);
        }

        public BlockPos getSubChunkPos() {
            return this.parent.parentChunk.getWorldPos(this.parent.yLevel);
        }

        public boolean isSealed() {
            int count = 0;
            for (Direction d : Direction.values()) {
                count += this.connectionIndices[d.ordinal()].size();
            }
            return count == 0;
        }
    }

    public static class ChunkRadiationStorage
    implements ICapabilitySerializable<CompoundTag> {
        public final LevelChunk chunk;
        private final IChunkRadiation instance = new Impl();
        public final SubChunkRadiationStorage[] subData = new SubChunkRadiationStorage[24];

        public ChunkRadiationStorage(LevelChunk chunk) {
            this.chunk = chunk;
            this.instance.setParent(this);
        }

        public BlockPos getWorldPos(int y) {
            return new BlockPos(this.chunk.m_7697_().f_45578_ << 4, y, this.chunk.m_7697_().f_45579_ << 4);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CHUNK_RAD_CAPABILITY) {
                return LazyOptional.of(() -> this.instance).cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT(nbt);
        }

        private class Impl
        implements IChunkRadiation {
            private ChunkRadiationStorage parent;
            private boolean wasInitialized = false;

            private Impl() {
            }

            @Override
            public ChunkRadiationStorage getParent() {
                return this.parent;
            }

            @Override
            public void setParent(ChunkRadiationStorage pParent) {
                this.parent = pParent;
            }

            @Override
            public SubChunkRadiationStorage getForYLevel(int y) {
                int index = ChunkStorageCompat.getIndexFromWorldY(y);
                if (index < 0 || index > ChunkRadiationStorage.this.subData.length) {
                    return null;
                }
                return ChunkRadiationStorage.this.subData[index];
            }

            @Override
            public void setForYLevel(int y, SubChunkRadiationStorage sc) {
                int index = ChunkStorageCompat.getIndexFromWorldY(y);
                if (ChunkRadiationStorage.this.subData[index] != null) {
                    ChunkRadiationStorage.this.subData[index].remove(ChunkRadiationStorage.this.chunk.m_62953_(), ChunkRadiationStorage.this.getWorldPos(y));
                    if (sc != null) {
                        sc.setRad(ChunkRadiationStorage.this.subData[index]);
                    }
                }
                if (sc != null) {
                    sc.add(ChunkRadiationStorage.this.chunk.m_62953_(), ChunkRadiationStorage.this.getWorldPos(y));
                }
                ChunkRadiationStorage.this.subData[index] = sc;
            }

            @Override
            public void setInitialized() {
                this.wasInitialized = true;
            }

            @Override
            public boolean wasInitialized() {
                return this.wasInitialized;
            }

            @Override
            public void unload() {
                for (int y = 0; y < ChunkRadiationStorage.this.subData.length; ++y) {
                    if (ChunkRadiationStorage.this.subData[y] == null) continue;
                    for (RadPocket p : ChunkRadiationStorage.this.subData[y].pockets) {
                        RadiationSystemChunksNT.removeActivePocket(p);
                    }
                    ChunkRadiationStorage.this.subData[y] = null;
                }
            }

            public short arrayIndex(RadPocket p, RadPocket[] pockets) {
                for (short i = 0; i < pockets.length; i = (short)(i + 1)) {
                    if (p != pockets[i]) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag root = new CompoundTag();
                for (int i = 0; i < 24; ++i) {
                    SubChunkRadiationStorage sc = ChunkRadiationStorage.this.subData[i];
                    if (sc == null) continue;
                    CompoundTag subTag = new CompoundTag();
                    ListTag pocketListNBT = new ListTag();
                    for (RadPocket p : sc.pockets) {
                        CompoundTag pTag = new CompoundTag();
                        pTag.m_128405_("index", p.index);
                        pTag.m_128350_("radiation", p.radiation);
                        for (Direction d : Direction.values()) {
                            IntArrayTag connArr = new IntArrayTag(p.connectionIndices[d.ordinal()].stream().mapToInt(Integer::intValue).toArray());
                            pTag.m_128365_("conn_" + d.m_7912_(), (Tag)connArr);
                        }
                        pocketListNBT.add((Object)pTag);
                    }
                    subTag.m_128365_("pockets", (Tag)pocketListNBT);
                    root.m_128365_("sub_" + i, (Tag)subTag);
                    if (sc.pocketsByBlock == null) {
                        subTag.m_128344_("p_nul", (byte)0);
                    } else {
                        subTag.m_128344_("p_nul", (byte)1);
                        for (int j = 0; j < sc.pocketsByBlock.length; ++j) {
                            RadPocket p = sc.pocketsByBlock[j];
                            subTag.m_128376_("pbb_" + j, this.arrayIndex(p, sc.pockets));
                        }
                    }
                    if (sc.blocksByPocket == null) {
                        subTag.m_128344_("b_nul", (byte)0);
                        continue;
                    }
                    subTag.m_128344_("b_nul", (byte)1);
                    for (int j = 0; j < sc.blocksByPocket.length; ++j) {
                        BlockPos b = sc.getBlock(j);
                        subTag.m_128356_("bbp_" + j, b.m_121878_());
                    }
                }
                root.m_128379_("was_initialized", this.wasInitialized);
                return root;
            }

            @Override
            public void deserializeNBT(CompoundTag nbt) {
                for (int i = 0; i < 24; ++i) {
                    String key = "sub_" + i;
                    if (nbt.m_128425_(key, 10)) {
                        boolean perBlockDataExists;
                        int idx;
                        CompoundTag subTag = nbt.m_128469_(key);
                        SubChunkRadiationStorage sc = new SubChunkRadiationStorage(ChunkRadiationStorage.this, ChunkStorageCompat.getWorldYFromIndex(i), null, null);
                        ListTag pocketListNBT = subTag.m_128437_("pockets", 10);
                        sc.pockets = new RadPocket[pocketListNBT.size()];
                        for (int pi = 0; pi < pocketListNBT.size(); ++pi) {
                            CompoundTag pTag = pocketListNBT.m_128728_(pi);
                            idx = pTag.m_128451_("index");
                            RadPocket p = new RadPocket(sc, idx);
                            p.radiation = pTag.m_128457_("radiation");
                            for (Direction d : Direction.values()) {
                                int[] connArr;
                                for (int val : connArr = pTag.m_128465_("conn_" + d.m_7912_())) {
                                    p.connectionIndices[d.ordinal()].add(val);
                                }
                            }
                            sc.pockets[idx] = p;
                        }
                        boolean bl = perBlockDataExists = subTag.m_128445_("p_nul") == 1;
                        if (perBlockDataExists) {
                            sc.pocketsByBlock = new RadPocket[4096];
                            for (int j = 0; j < 4096; ++j) {
                                idx = subTag.m_128448_("pbb_" + j);
                                if (idx < 0) continue;
                                sc.pocketsByBlock[j] = sc.pockets[idx];
                            }
                        }
                        boolean bl2 = perBlockDataExists = subTag.m_128445_("b_nul") == 1;
                        if (perBlockDataExists) {
                            sc.blocksByPocket = new BlockPos[sc.pockets.length];
                            for (int j = 0; j < sc.pockets.length; ++j) {
                                BlockPos pos;
                                sc.blocksByPocket[j] = pos = BlockPos.m_122022_((long)subTag.m_128454_("bbp_" + j));
                            }
                        }
                        ChunkRadiationStorage.this.subData[i] = sc;
                        continue;
                    }
                    ChunkRadiationStorage.this.subData[i] = null;
                }
                this.wasInitialized = nbt.m_128441_("was_initialized") && nbt.m_128471_("was_initialized");
            }
        }
    }

    public static class ChunkStorageCompat {
        public static ExtendedBlockStorage[] getBlockStorageArray(LevelChunk chunk) {
            LevelChunkSection[] modernSections = chunk.m_7103_();
            ExtendedBlockStorage[] legacyCompat = new ExtendedBlockStorage[24];
            for (int i = 0; i < modernSections.length; ++i) {
                LevelChunkSection section = modernSections[i];
                if (section == null) continue;
                legacyCompat[i] = new ExtendedBlockStorage(section);
            }
            return legacyCompat;
        }

        public static BlockState getBlockState(LevelChunkSection section, int x, int y, int z) {
            if (section == null) {
                return null;
            }
            return section.m_62982_(x, y, z);
        }

        public static void setBlockState(LevelChunkSection section, int x, int y, int z, BlockState state) {
            if (section != null) {
                section.m_62986_(x, y, z, state);
            }
        }

        public static int getIndexFromWorldY(int y) {
            if (y < -64) {
                return 0;
            }
            if (y > 319) {
                return 23;
            }
            return y + 64 >> 4;
        }

        public static int getWorldYFromIndex(int idx) {
            if (idx < 0) {
                return -64;
            }
            if (idx > 23) {
                return 319;
            }
            return (idx << 4) - 64;
        }

        public static class ExtendedBlockStorage {
            private final LevelChunkSection levelChunkSection;

            public ExtendedBlockStorage(LevelChunkSection pLevelChunkSection) {
                this.levelChunkSection = pLevelChunkSection;
            }

            public BlockState get(int x, int y, int z) {
                return ChunkStorageCompat.getBlockState(this.levelChunkSection, x, y, z);
            }

            public void set(int x, int y, int z, BlockState state) {
                ChunkStorageCompat.setBlockState(this.levelChunkSection, x, y, z, state);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class RadiationEventHandlers {
        private static final ResourceLocation RADIATION_CAP_KEY = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"chunk_radiation");
        static boolean iteratingDirty;
        static Set<BlockPos> dirtyChunks;
        static Set<BlockPos> dirtyChunks2;
        public static final int FRAME_COUNT = 13;
        public static final ResourceLocation[] FRAMES;
        static Map<BlockPos, Integer> activePositions;

        @SubscribeEvent
        public static void attachChunkRadiation(AttachCapabilitiesEvent<LevelChunk> event) {
            LevelChunk chunk = (LevelChunk)event.getObject();
            ChunkRadiationStorage storage = new ChunkRadiationStorage(chunk);
            event.addCapability(RADIATION_CAP_KEY, (ICapabilityProvider)storage);
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload e) {
            if (e.getLevel().m_5776_()) {
                return;
            }
            ((LevelChunk)e.getChunk()).getCapability(CHUNK_RAD_CAPABILITY).ifPresent(IChunkRadiation::unload);
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load e) {
            if (e.getLevel().m_5776_()) {
                return;
            }
            LevelChunk chunk = (LevelChunk)e.getChunk();
            if (RadiationSystemChunksNT.getChunkStorage((LevelChunk)chunk).instance.wasInitialized()) {
                return;
            }
            ServerLevel level = (ServerLevel)e.getLevel();
            if (level.m_7654_().m_6982_()) {
                try {
                    level.m_7654_().execute((Runnable)new InitializeChunkTask(level, chunk));
                }
                catch (Exception ex) {
                    HBM.LOGGER.error("failed to execute initialize chunk task: ", (Throwable)ex);
                }
            } else {
                BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
                int baseX = chunk.m_7697_().m_45604_();
                int baseZ = chunk.m_7697_().m_45605_();
                LevelChunkSection[] sections = chunk.m_7103_();
                for (int i = 0; i < sections.length; ++i) {
                    LevelChunkSection section = sections[i];
                    if (section == null || section.m_188008_()) continue;
                    int sectionBaseY = (i << 4) - 64;
                    for (int lx = 0; lx < 16; ++lx) {
                        int wx = baseX + lx;
                        for (int ly = 0; ly < 16; ++ly) {
                            int wy = sectionBaseY + ly;
                            for (int lz = 0; lz < 16; ++lz) {
                                int wz = baseZ + lz;
                                Block block = section.m_62982_(lx, ly, lz).m_60734_();
                                if (!(block instanceof HazardBlock)) continue;
                                HazardBlock hb = (HazardBlock)block;
                                mPos.m_122178_(wx, wy, wz);
                                hb.onGenerated(level, (BlockPos)mPos);
                            }
                        }
                    }
                }
                RadiationSystemChunksNT.getChunkStorage((LevelChunk)chunk).instance.setInitialized();
            }
        }

        public static void markChunkForRebuild(Level level, BlockPos pos) {
            BlockPos chunkPos = new BlockPos(pos.m_123341_() >> 4, ChunkStorageCompat.getIndexFromWorldY(pos.m_123342_()), pos.m_123343_() >> 4);
            if (iteratingDirty) {
                dirtyChunks2.add(chunkPos);
            } else {
                dirtyChunks.add(chunkPos);
            }
        }

        private static void rebuildDirty(Level level) {
            boolean hadDirty = false;
            iteratingDirty = true;
            for (BlockPos dirtyChunkPos : dirtyChunks) {
                RadiationSystemChunksNT.rebuildChunkPockets(level.m_6325_(dirtyChunkPos.m_123341_(), dirtyChunkPos.m_123343_()), dirtyChunkPos.m_123342_());
                hadDirty = true;
            }
            iteratingDirty = false;
            dirtyChunks.clear();
            dirtyChunks.addAll(dirtyChunks2);
            dirtyChunks2.clear();
        }

        @SubscribeEvent
        public static void onUpdate(TickEvent.ServerTickEvent e) {
            if (e.phase == TickEvent.Phase.END && ++ticks % 20 == 17) {
                long mil = System.nanoTime();
                RadiationSystemChunksNT.updateRadiation();
                for (ServerLevel level : e.getServer().m_129785_()) {
                    RadiationSystemChunksNT.updateEntities(level);
                    if (level.f_46441_.m_188503_(1000000) != 0) continue;
                    GeigerCounterItem.jmp = true;
                }
            }
            for (ServerLevel level : e.getServer().m_129785_()) {
                RadiationEventHandlers.rebuildDirty((Level)level);
            }
        }

        @SubscribeEvent
        public static void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor level = event.getLevel();
            if (!level.m_5776_()) {
                activePositions = RadiationEventHandlers.loadMapFromJson((ServerLevel)level, "data/hbm/rad_vectors.json");
                for (Map.Entry<BlockPos, Integer> nxt : activePositions.entrySet()) {
                    LevelChunk chunk = ((ServerLevel)level).m_46745_(nxt.getKey());
                    RadiationSystemChunksNT.rebuildChunkPockets(chunk, ChunkStorageCompat.getIndexFromWorldY(nxt.getKey().m_123342_()));
                    RadiationSystemChunksNT.setRadForCoord((ServerLevel)level, nxt.getKey(), nxt.getValue().intValue());
                }
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(PlayerEvent.PlayerLoggedOutEvent event) throws IOException {
            Level level = event.getEntity().m_9236_();
            if (!level.m_5776_()) {
                activePositions.clear();
                for (RadPocket p : activePockets) {
                    activePositions.put(p.parent.getBlock(p.index), Math.round(p.radiation));
                }
                RadiationEventHandlers.saveMapToJson((ServerLevel)level, activePositions, "data/hbm/rad_vectors.json");
            }
        }

        public static void saveMapToJson(ServerLevel level, Map<BlockPos, Integer> map, String fileName) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            HashMap<CallSite, Integer> jsonMap = new HashMap<CallSite, Integer>();
            for (Map.Entry<BlockPos, Integer> entry : map.entrySet()) {
                jsonMap.put((CallSite)((Object)(entry.getKey().m_123341_() + ":" + entry.getKey().m_123342_() + ":" + entry.getKey().m_123343_())), entry.getValue());
            }
            Path path = level.m_7654_().m_129843_(LevelResource.f_78182_).resolve(fileName);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                if (activePositions.isEmpty()) {
                    Files.deleteIfExists(path);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    gson.toJson(jsonMap, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public static Map<BlockPos, Integer> loadMapFromJson(ServerLevel level, String fileName) {
            HashMap<BlockPos, Integer> hashMap;
            block10: {
                Gson gson = new Gson();
                Type mapType = new TypeToken<Map<String, Integer>>(){}.getType();
                Path path = level.m_7654_().m_129843_(LevelResource.f_78182_).resolve(fileName);
                if (!Files.exists(path, new LinkOption[0])) {
                    return new HashMap<BlockPos, Integer>();
                }
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    Map jsonMap = (Map)gson.fromJson((Reader)reader, mapType);
                    HashMap<BlockPos, Integer> result = new HashMap<BlockPos, Integer>();
                    for (Map.Entry entry : jsonMap.entrySet()) {
                        String[] strA = ((String)entry.getKey()).split(":");
                        BlockPos vecR = new BlockPos(Integer.parseInt(strA[0]), Integer.parseInt(strA[1]), Integer.parseInt(strA[2]));
                        result.put(vecR, (Integer)entry.getValue());
                    }
                    hashMap = result;
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return new HashMap<BlockPos, Integer>();
                    }
                }
                ((Reader)reader).close();
            }
            return hashMap;
        }

        static {
            dirtyChunks = new HashSet<BlockPos>();
            dirtyChunks2 = new HashSet<BlockPos>();
            FRAMES = new ResourceLocation[13];
            for (int i = 0; i < 13; ++i) {
                RadiationEventHandlers.FRAMES[i] = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)("textures/gui/jmpscr/frame_" + String.format("%02d", i) + ".png"));
            }
            activePositions = new HashMap<BlockPos, Integer>();
        }

        private static class InitializeChunkTask
        implements Runnable {
            final ServerLevel level;
            final LevelChunk chunk;

            InitializeChunkTask(ServerLevel level, LevelChunk chunk) {
                this.level = level;
                this.chunk = chunk;
            }

            @Override
            public void run() {
                try {
                    BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
                    int baseX = this.chunk.m_7697_().m_45604_();
                    int baseZ = this.chunk.m_7697_().m_45605_();
                    LevelChunkSection[] sections = this.chunk.m_7103_();
                    for (int i = 0; i < sections.length; ++i) {
                        LevelChunkSection section = sections[i];
                        if (section == null || section.m_188008_()) continue;
                        int sectionBaseY = (i << 4) - 64;
                        for (int lx = 0; lx < 16; ++lx) {
                            int wx = baseX + lx;
                            for (int ly = 0; ly < 16; ++ly) {
                                int wy = sectionBaseY + ly;
                                for (int lz = 0; lz < 16; ++lz) {
                                    int wz = baseZ + lz;
                                    Block block = section.m_62982_(lx, ly, lz).m_60734_();
                                    if (!(block instanceof HazardBlock)) continue;
                                    HazardBlock hb = (HazardBlock)block;
                                    mPos.m_122178_(wx, wy, wz);
                                    hb.onGenerated(this.level, (BlockPos)mPos);
                                }
                            }
                        }
                    }
                    RadiationSystemChunksNT.getChunkStorage((LevelChunk)this.chunk).instance.setInitialized();
                }
                catch (Exception e) {
                    HBM.LOGGER.error("failed to initialize chunk: ", (Throwable)e);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModSetup {
        @SubscribeEvent
        public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
            event.register(IChunkRadiation.class);
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
        }
    }
}

