/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.handler;

import com.hbm.nucleartech.AdvancementManager;
import com.hbm.nucleartech.capability.HbmCapabilities;
import com.hbm.nucleartech.damagesource.RegisterDamageSources;
import com.hbm.nucleartech.entity.HbmEntities;
import com.hbm.nucleartech.entity.custom.NuclearCreeperEntity;
import com.hbm.nucleartech.handler.RadiationWorldHandler;
import com.hbm.nucleartech.interfaces.IEntityCapabilityBase;
import com.hbm.nucleartech.util.ContaminationUtil;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="hbm")
public class RadiationSystemNT {
    static MinecraftServer server;
    private static int worldDestructionCooldown;
    private static final int TICKS_PER_SECOND = 20;
    private static final int MIN_SECONDS_BETWEEN_EVENTS = 0;
    private static final int MAX_SECONDS_BETWEEN_EVENTS = 4;

    public static void init(MinecraftServer pServer) {
        server = pServer;
    }

    @Deprecated(forRemoval=true, since="1.8.21")
    private static void updateEntityContamination(Level world, boolean updateData) {
        if (world != null && !world.f_46443_) {
            HashSet<ChunkPos> processedChunks = new HashSet<ChunkPos>();
            for (Player playerI : world.m_6907_()) {
                ChunkPos playerChunkPos = new ChunkPos(playerI.m_20183_());
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        ChunkPos chunkPos = new ChunkPos(playerChunkPos.f_45578_ + dx, playerChunkPos.f_45579_ + dz);
                        if (!processedChunks.add(chunkPos) || !world.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) continue;
                        LevelChunk chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                        AABB chunkAABB = RadiationSystemNT.getAabb(world, chunkPos);
                        List entities = world.m_45976_(LivingEntity.class, chunkAABB);
                        for (Entity e : entities) {
                            double eRad;
                            if (!(e instanceof LivingEntity)) continue;
                            LivingEntity entity = (LivingEntity)e;
                            ContaminationUtil.setEntityENV(entity, world);
                            if (entity instanceof ServerPlayer) {
                                ServerPlayer player = (ServerPlayer)entity;
                                double receivedRadiation = ContaminationUtil.getNoNeutronPlayerRads((LivingEntity)player) * 4.0E-5 - 8.0E-4;
                                float neutronRads = ContaminationUtil.getPlayerNeutronRads((Player)player);
                                if (neutronRads > 0.0f) {
                                    ContaminationUtil.contaminate((LivingEntity)player, ContaminationUtil.HazardType.NEUTRON, ContaminationUtil.ContaminationType.CREATIVE, neutronRads * 0.05f);
                                } else {
                                    HbmCapabilities.getData((Entity)player).setValue(IEntityCapabilityBase.Type.NEUTRON, 0.0);
                                }
                                if (receivedRadiation > (double)0.0012f) {
                                    ContaminationUtil.neutronActivateInventory((Player)player, (float)receivedRadiation, 1.0f);
                                    player.f_36096_.m_38946_();
                                }
                                if (player.m_7500_() || player.m_5833_()) continue;
                            }
                            if ((eRad = HbmCapabilities.getData((Entity)entity).getValue(IEntityCapabilityBase.Type.RADIATION)) >= 200.0 && entity.m_21223_() > 0.0f && entity instanceof Creeper) {
                                Creeper creeper = (Creeper)entity;
                                if (world.f_46441_.m_188503_(3) == 0 && creeper != null) {
                                    RadiationSystemNT.replace((LivingEntity)creeper, (Mob)new NuclearCreeperEntity((EntityType<? extends NuclearCreeperEntity>)((EntityType)HbmEntities.NUCLEAR_CREEPER.get()), world), world);
                                    continue;
                                }
                                try {
                                    if (creeper == null) continue;
                                    creeper.m_6469_(RegisterDamageSources.RADIATION, 100.0f);
                                }
                                catch (Exception ignored) {
                                    System.err.println("client had a packet error! e: " + String.valueOf(ignored.getCause()));
                                }
                                continue;
                            }
                            if (eRad >= 500.0 && entity instanceof Cow) {
                                Cow cow = (Cow)entity;
                                if (!(entities instanceof MushroomCow)) {
                                    RadiationSystemNT.replace((LivingEntity)cow, (Mob)new MushroomCow(EntityType.f_20504_, world), world);
                                    continue;
                                }
                            }
                            if (eRad >= 600.0 && entity instanceof Villager) {
                                Villager vill = (Villager)entity;
                                RadiationSystemNT.replace((LivingEntity)vill, (Mob)new ZombieVillager(EntityType.f_20530_, world), world);
                                continue;
                            }
                            if (eRad >= 800.0 && entity instanceof Horse) {
                                Horse horse = (Horse)entity;
                                ZombieHorse zom = new ZombieHorse(EntityType.f_20502_, world);
                                zom.m_146762_(horse.m_146764_());
                                zom.m_30649_(horse.m_30624_());
                                if (horse.m_6254_()) {
                                    zom.m_5853_(null);
                                }
                                zom.m_30651_(horse.m_30614_());
                                zom.m_30586_(horse.m_21805_());
                                zom.m_7564_();
                                RadiationSystemNT.replace((LivingEntity)horse, (Mob)zom, world);
                                continue;
                            }
                            HbmCapabilities.getData((Entity)entity).addValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION, (float)(eRad / 1000000.0));
                            HbmCapabilities.getData((Entity)entity).syncLivingVariables((Entity)entity);
                            if (eRad > 1000000.0) {
                                HbmCapabilities.getData((Entity)entity).setValue(IEntityCapabilityBase.Type.RADIATION, 1000000.0);
                            }
                            double perm_con = HbmCapabilities.getData((Entity)entity).getValue(IEntityCapabilityBase.Type.PERMANENT_CONTAMINATION);
                            HbmCapabilities.getData((Entity)entity).addValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE, perm_con / 200000.0);
                            HbmCapabilities.getData((Entity)entity).syncLivingVariables((Entity)entity);
                            double internal_dam = HbmCapabilities.getData((Entity)entity).getValue(IEntityCapabilityBase.Type.INTERNAL_DAMAGE);
                            if (internal_dam >= 100.0) {
                                try {
                                    entity.m_6469_(RegisterDamageSources.RADIATION, 1000.0f);
                                }
                                catch (Exception ignored) {
                                    System.err.println("client had a packet error!");
                                }
                            } else if (internal_dam >= 80.0) {
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 150, 0, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 2, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 2, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, 3, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 3, true, false));
                                }
                            } else if (internal_dam >= 60.0) {
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 150, 0, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 2, true, false));
                                }
                                if (world.f_46441_.m_188503_(500) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 1, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, 3, true, false));
                                }
                                if (world.f_46441_.m_188503_(400) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 120, 2, true, false));
                                }
                            } else if (internal_dam >= 40.0) {
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 150, 0, true, false));
                                }
                                if (world.f_46441_.m_188503_(500) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0, true, false));
                                }
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1, true, false));
                                }
                                if (world.f_46441_.m_188503_(500) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 2, true, false));
                                }
                                if (world.f_46441_.m_188503_(600) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 80, 1, true, false));
                                }
                            } else if (internal_dam >= 20.0) {
                                if (world.f_46441_.m_188503_(300) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0, true, false));
                                }
                                if (world.f_46441_.m_188503_(500) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0, true, false));
                                }
                                if (world.f_46441_.m_188503_(700) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 2, true, false));
                                }
                                if (world.f_46441_.m_188503_(800) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 80, 0, true, false));
                                }
                            } else if (internal_dam >= 10.0) {
                                if (world.f_46441_.m_188503_(800) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 0, true, false));
                                }
                                if (world.f_46441_.m_188503_(1000) == 0) {
                                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 20, 0, true, false));
                                }
                                if (entity instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)entity;
                                    AdvancementManager.grant(player, "rad_poison");
                                }
                            }
                            AttributeInstance hp = entity.m_21051_(Attributes.f_22276_);
                            int oldRoundedDam = (int)HbmCapabilities.getData((Entity)entity).getValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE);
                            int roundedDam = (int)Math.round(internal_dam);
                            if (hp == null || roundedDam == oldRoundedDam) continue;
                            float currMax = entity.m_21233_();
                            float ogMax = (float)HbmCapabilities.getData((Entity)entity).getValue(IEntityCapabilityBase.Type.OLD_MAX_HEALTH);
                            float newMax = switch (roundedDam) {
                                case 100 -> 1.0f;
                                case 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95 -> ogMax * (1.0f - (float)roundedDam / 100.0f);
                                default -> currMax;
                            };
                            hp.m_22100_((double)newMax);
                            if (entity.m_21223_() > newMax) {
                                entity.m_21153_(newMax);
                            }
                            HbmCapabilities.getData((Entity)entity).setValue(IEntityCapabilityBase.Type.OLD_ROUNDED_DAMAGE, roundedDam);
                            HbmCapabilities.getData((Entity)entity).syncLivingVariables((Entity)entity);
                        }
                    }
                }
            }
        }
    }

    public static void replace(LivingEntity oldEntity, Mob newEntity, Level level) {
        if (level.f_46443_) {
            return;
        }
        if (oldEntity instanceof Villager) {
            Villager vill = (Villager)oldEntity;
            if (newEntity instanceof ZombieVillager) {
                ZombieVillager zom = (ZombieVillager)newEntity;
                zom.m_34375_(vill.m_7141_());
                zom.m_6863_(vill.m_6162_());
            }
        }
        newEntity.m_20219_(oldEntity.m_20182_());
        newEntity.m_5616_(oldEntity.m_6080_());
        newEntity.m_146922_(oldEntity.m_146908_());
        newEntity.m_146926_(oldEntity.m_146909_());
        newEntity.m_6593_(oldEntity.m_7770_());
        newEntity.m_20340_(oldEntity.m_20151_());
        newEntity.m_21530_();
        for (MobEffectInstance instance : oldEntity.m_21220_()) {
            newEntity.m_7292_(instance);
        }
        if (!oldEntity.m_21224_() && !level.m_5776_()) {
            level.m_7967_((Entity)newEntity);
        }
        oldEntity.m_146870_();
    }

    @SubscribeEvent
    public static void onWorldUpdate(TickEvent.LevelTickEvent event) {
        boolean allowUpdate;
        boolean bl = allowUpdate = event.phase == TickEvent.Phase.START;
        if (allowUpdate && --worldDestructionCooldown <= 0) {
            RadiationWorldHandler.handleWorldDestruction(event.level);
            int delaySeconds = event.level.f_46441_.m_188503_(5) + 0;
            worldDestructionCooldown = delaySeconds * 20;
        }
        if (!event.level.m_5776_()) {
            RadiationSystemNT.updateEntityContamination(event.level, allowUpdate);
        }
    }

    @NotNull
    public static AABB getAabb(Level world, ChunkPos chunkPos) {
        int chunkStartX = chunkPos.m_45604_();
        int chunkStartZ = chunkPos.m_45605_();
        int chunkEndX = chunkStartX + 15;
        int chunkEndZ = chunkStartZ + 15;
        int worldMinY = world.m_141937_();
        int worldMaxY = world.m_151558_();
        return new AABB((double)chunkStartX, (double)worldMinY, (double)chunkStartZ, (double)(chunkEndX + 1), (double)worldMaxY, (double)(chunkEndZ + 1));
    }

    static {
        worldDestructionCooldown = 0;
    }
}

