/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.handler;

import com.hbm.nucleartech.handler.AsyncChunkProcessor;
import com.hbm.nucleartech.handler.RadiationSystemChunksNT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class RadiationWorldHandler {
    private static final int MAX_CHUNKS_PER_TICK = 2;
    private static final Random random = ThreadLocalRandom.current();

    public static void handleWorldDestruction(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        Set<RadiationSystemChunksNT.RadPocket> active = RadiationSystemChunksNT.getActivePockets();
        if (active.isEmpty()) {
            return;
        }
        int threshold = 5;
        List<RadiationSystemChunksNT.RadPocket> pockets = RadiationWorldHandler.getPocketsAboveThreshold(active, world, threshold);
        if (pockets.isEmpty()) {
            return;
        }
        List<RadiationSystemChunksNT.RadPocket> theChosenONESSSSS = RadiationWorldHandler.choosePocketsFromList(pockets, world, 2);
        if (theChosenONESSSSS.isEmpty()) {
            return;
        }
        int processed = 0;
        for (RadiationSystemChunksNT.RadPocket pocket : theChosenONESSSSS) {
            if (processed >= 2) break;
            RadiationSystemChunksNT.SubChunkRadiationStorage sc = pocket.parent;
            if (sc == null || sc.parentChunk == null || sc.parentChunk.chunk == null) continue;
            LevelChunk chunk = sc.parentChunk.chunk;
            int sectionY = RadiationSystemChunksNT.ChunkStorageCompat.getIndexFromWorldY(sc.yLevel);
            AsyncChunkProcessor.queueChunkForProcessing(world, chunk, sectionY, pocket);
            ++processed;
        }
    }

    private static List<RadiationSystemChunksNT.RadPocket> choosePocketsFromList(List<RadiationSystemChunksNT.RadPocket> pockets, ServerLevel world, int i) {
        ArrayList<RadiationSystemChunksNT.RadPocket> list = new ArrayList<RadiationSystemChunksNT.RadPocket>();
        for (int j = 0; j < i; ++j) {
            list.add(pockets.get(world.f_46441_.m_188503_(pockets.size())));
        }
        return list;
    }

    private static List<RadiationSystemChunksNT.RadPocket> getPocketsAboveThreshold(Collection<RadiationSystemChunksNT.RadPocket> pockets, ServerLevel world, int threshold) {
        if (pockets == null || pockets.isEmpty()) {
            return List.of();
        }
        ArrayList<RadiationSystemChunksNT.RadPocket> snapshot = new ArrayList<RadiationSystemChunksNT.RadPocket>(pockets);
        ArrayList<RadiationSystemChunksNT.RadPocket> result = new ArrayList<RadiationSystemChunksNT.RadPocket>(Math.min(snapshot.size(), 16));
        for (RadiationSystemChunksNT.RadPocket pocket : snapshot) {
            if (pocket == null || Float.isNaN(pocket.radiation) || !(pocket.radiation >= (float)threshold)) continue;
            result.add(pocket);
        }
        if (result.size() > 1) {
            for (int i = result.size() - 1; i > 0; --i) {
                int index = random.nextInt(i + 1);
                RadiationSystemChunksNT.RadPocket temp = (RadiationSystemChunksNT.RadPocket)result.get(index);
                result.set(index, (RadiationSystemChunksNT.RadPocket)result.get(i));
                result.set(i, temp);
            }
        }
        return result;
    }

    public static void shutdown() {
        AsyncChunkProcessor.shutdown();
    }
}

