/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.hazard;

import com.hbm.nucleartech.interfaces.IItemHazard;
import com.hbm.nucleartech.modules.ItemHazardModule;
import com.hbm.nucleartech.util.ContaminationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.TickPriority;

public class HazardBlock
extends DropExperienceBlock
implements IItemHazard {
    ItemHazardModule module;
    private double radIn = 0.0;
    private double rad3d = 0.0;
    private ExtDisplayEffect extEffect = null;
    private boolean beaconable = false;
    private final IntProvider xpRange;

    public HazardBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
        this.xpRange = null;
        this.module = new ItemHazardModule();
    }

    public HazardBlock(BlockBehaviour.Properties pProperties, double rad) {
        super(pProperties);
        this.xpRange = null;
        this.module = new ItemHazardModule();
        this.rad3d = rad;
        this.radIn = rad;
    }

    public HazardBlock(BlockBehaviour.Properties pProperties, IntProvider pXpRange, double rad) {
        super(pProperties);
        this.xpRange = pXpRange;
        this.module = new ItemHazardModule();
        this.rad3d = rad;
        this.radIn = rad;
    }

    public HazardBlock(BlockBehaviour.Properties pProperties, IntProvider pXpRange, SoundType pSoundType) {
        super(pProperties.m_60918_(pSoundType));
        this.xpRange = pXpRange;
    }

    public HazardBlock(BlockBehaviour.Properties pProperties, SoundType pSoundType) {
        super(pProperties.m_60918_(pSoundType));
        this.xpRange = null;
    }

    public HazardBlock setDisplayEffect(ExtDisplayEffect extEffect) {
        this.extEffect = extEffect;
        return this;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (this.extEffect == null) {
            return;
        }
        switch (this.extEffect) {
            case RADFOG: {
                break;
            }
            case SCHRAB: {
                break;
            }
            case FLAMES: {
                this.sPart(pLevel, pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_(), pRandom);
                break;
            }
            case SPARKS: {
                break;
            }
            case LAVAPOP: {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)((float)pPos.m_123341_() + pRandom.m_188501_()), (double)(pPos.m_123342_() + 1), (double)((float)pPos.m_123343_() + pRandom.m_188501_()), 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    private void sPart(Level pLevel, int x, int y, int z, RandomSource rand) {
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN && this.extEffect == ExtDisplayEffect.FLAMES || pLevel.m_8055_(new BlockPos(x + dir.m_122429_(), y + dir.m_122430_(), z + dir.m_122431_())).m_61147_() != Blocks.f_50016_.m_49966_()) continue;
            double ix = (double)((float)x + 0.5f + (float)dir.m_122429_()) + rand.m_188500_() * 3.0 - 1.5;
            double iy = (double)((float)x + 0.5f + (float)dir.m_122430_()) + rand.m_188500_() * 3.0 - 1.5;
            double iz = (double)((float)x + 0.5f + (float)dir.m_122431_()) + rand.m_188500_() * 3.0 - 1.5;
            if (dir.m_122429_() != 0) {
                ix = (double)((float)x + 0.5f + (float)dir.m_122429_() * 0.5f) + rand.m_188500_() * (double)dir.m_122429_();
            }
            if (dir.m_122430_() != 0) {
                iy = (double)((float)x + 0.5f + (float)dir.m_122430_() * 0.5f) + rand.m_188500_() * (double)dir.m_122430_();
            }
            if (dir.m_122431_() != 0) {
                iz = (double)((float)x + 0.5f + (float)dir.m_122431_() * 0.5f) + rand.m_188500_() * (double)dir.m_122431_();
            }
            if (this.extEffect == ExtDisplayEffect.RADFOG) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123757_, ix, iy, iz, 0.0, 0.0, 0.0);
            }
            if (this.extEffect == ExtDisplayEffect.SCHRAB) {
                // empty if block
            }
            if (this.extEffect != ExtDisplayEffect.FLAMES) continue;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, ix, iy, iz, 0.0, 0.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, ix, iy, iz, 0.0, 0.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, ix, iy, iz, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemHazardModule getModule() {
        return this.module;
    }

    @Override
    public IItemHazard addRadiation(double radiation) {
        this.getModule().addRadiation(radiation);
        this.radIn = radiation * (double)0.1f;
        return this;
    }

    public HazardBlock makeBeaconable() {
        this.beaconable = true;
        return this;
    }

    public HazardBlock addRad3d(int rad3d) {
        this.rad3d = rad3d;
        return this;
    }

    public boolean isBeaconable() {
        return this.beaconable;
    }

    public void onGenerated(ServerLevel level, BlockPos worldPosition) {
        level.m_186464_(worldPosition, this.toBlock(), this.tickRate((Level)level), TickPriority.HIGH);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        if (this.rad3d > 0.0) {
            ContaminationUtil.radiate(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 32.0, (float)this.rad3d, 0.0f, this.module.fire * 5000, 0.0f, 0.0, pPos);
            pLevel.m_186464_(pPos, this.toBlock(), this.tickRate((Level)pLevel), TickPriority.HIGH);
        }
    }

    public int tickRate(Level level) {
        if (this.rad3d > 0.0) {
            return 1;
        }
        return 10;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        if (this.radIn > 0.0 || this.rad3d > 0.0) {
            pLevel.m_186460_(pPos, this.toBlock(), this.tickRate(pLevel));
        }
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        super.m_141947_(pLevel, pPos, pState, pEntity);
        if (pEntity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)pEntity;
            this.module.applyEffects(e, 0.5f, 0, false, InteractionHand.MAIN_HAND);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.m_7892_(pState, pLevel, pPos, pEntity);
        if (pEntity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)pEntity;
            this.module.applyEffects(e, 0.5f, 0, false, InteractionHand.MAIN_HAND);
        }
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        if (this.xpRange != null) {
            return silkTouchLevel == 0 ? this.xpRange.m_214085_(randomSource) : 0;
        }
        return 0;
    }

    public static enum ExtDisplayEffect {
        RADFOG,
        SPARKS,
        SCHRAB,
        FLAMES,
        LAVAPOP;

    }
}

