/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.hazard;

import com.hbm.nucleartech.hazard.modifier.HazardModifier;
import com.hbm.nucleartech.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;

public class HazardEntry {
    ContaminationUtil.HazardType type;
    float baseLevel;
    List<HazardModifier> mods = new ArrayList<HazardModifier>();

    public HazardEntry(ContaminationUtil.HazardType type) {
        this(type, 1.0f);
    }

    public HazardEntry(ContaminationUtil.HazardType type, float level) {
        this.type = type;
        this.baseLevel = level;
    }

    public HazardEntry addMod(HazardModifier mod) {
        this.mods.add(mod);
        return this;
    }

    public ContaminationUtil.HazardType getType() {
        return this.type;
    }

    public HazardEntry clone() {
        return this.clone(1.0f);
    }

    public HazardEntry clone(float mult) {
        HazardEntry clone = new HazardEntry(this.type, this.baseLevel * mult);
        clone.mods.addAll(this.mods);
        return clone;
    }

    public float getBaseLevel() {
        return this.baseLevel;
    }

    public void setBaseLevel(float lvl) {
        this.baseLevel = lvl;
    }
}

