/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.hazard;

import com.hbm.nucleartech.hazard.HazardData;
import com.hbm.nucleartech.hazard.HazardEntry;
import com.hbm.nucleartech.hazard.modifier.HazardModifier;
import com.hbm.nucleartech.util.ContaminationUtil;
import com.hbm.nucleartech.util.RecipesCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class HazardSystem {
    public static final HashMap<String, HazardData> oreMap = new HashMap();
    public static final HashMap<Item, HazardData> itemMap = new HashMap();
    public static final HashMap<RecipesCommon.ComparableStack, HazardData> stackMap = new HashMap();
    public static final HashSet<RecipesCommon.ComparableStack> stackBlacklist = new HashSet();
    public static final HashSet<String> dictBlacklist = new HashSet();
    public static final HashMap<String, HazardData> fluidMap = new HashMap();

    public static void registerFluid(String o, HazardData data) {
        if (o != null) {
            fluidMap.put(o, data);
        }
    }

    public static void register(Object o, HazardData data) {
        if (o instanceof String) {
            oreMap.put((String)o, data);
        }
        if (o instanceof Item) {
            itemMap.put((Item)o, data);
        }
        if (o instanceof Block) {
            itemMap.put(((Block)o).m_5456_(), data);
        }
        if (o instanceof ItemStack) {
            stackMap.put(new RecipesCommon.ComparableStack((ItemStack)o), data);
        }
        if (o instanceof RecipesCommon.ComparableStack) {
            stackMap.put((RecipesCommon.ComparableStack)o, data);
        }
    }

    public static void blacklist(Object o) {
        if (o instanceof ItemStack) {
            stackBlacklist.add(new RecipesCommon.ComparableStack((ItemStack)o).makeSingular());
        } else if (o instanceof String) {
            dictBlacklist.add((String)o);
        }
    }

    public static boolean isItemBlacklisted(ItemStack stack) {
        if (stackBlacklist.contains(new RecipesCommon.ComparableStack(stack).makeSingular())) {
            return true;
        }
        Set tags = ForgeRegistries.ITEMS.getHolder((Object)stack.m_41720_()).stream().flatMap(holder -> holder.m_203616_().map(TagKey::f_203868_)).collect(Collectors.toSet());
        for (ResourceLocation loc : tags) {
            String name;
            if (!ForgeRegistries.ITEMS.containsKey(loc) || !dictBlacklist.contains(name = ((Item)ForgeRegistries.ITEMS.getValue(loc)).m_5524_())) continue;
            return true;
        }
        return false;
    }

    public static List<HazardEntry> getHazardsFromFluid(String f) {
        ArrayList<HazardEntry> chronological = new ArrayList<HazardEntry>();
        if (fluidMap.containsKey(f)) {
            chronological.addAll(HazardSystem.fluidMap.get((Object)f).entries);
        }
        return chronological;
    }

    public static List<HazardEntry> getHazardsFromStack(ItemStack stack) {
        RecipesCommon.ComparableStack comp;
        if (stack == null || stack.m_41619_() || HazardSystem.isItemBlacklisted(stack)) {
            return new ArrayList<HazardEntry>();
        }
        ArrayList<HazardData> chronological = new ArrayList<HazardData>();
        Set tags = ForgeRegistries.ITEMS.getHolder((Object)stack.m_41720_()).stream().flatMap(holder -> holder.m_203616_().map(TagKey::f_203868_)).collect(Collectors.toSet());
        for (ResourceLocation loc : tags) {
            String name;
            if (!ForgeRegistries.ITEMS.containsKey(loc) || !oreMap.containsKey(name = ((Item)ForgeRegistries.ITEMS.getValue(loc)).m_5524_())) continue;
            chronological.add(oreMap.get(name));
        }
        if (itemMap.containsKey(stack.m_41720_())) {
            chronological.add(itemMap.get(stack.m_41720_()));
        }
        if (stackMap.containsKey(comp = new RecipesCommon.ComparableStack(stack).makeSingular())) {
            chronological.add(stackMap.get(comp));
        }
        ArrayList<HazardEntry> entries = new ArrayList<HazardEntry>();
        int mutex = 0;
        for (HazardData data : chronological) {
            if (data.doesOverride) {
                entries.clear();
            }
            if ((data.getMutex() & mutex) != 0) continue;
            entries.addAll(data.entries);
            mutex |= data.getMutex();
        }
        return entries;
    }

    public static float getHazardLevelFromStack(ItemStack stack, ContaminationUtil.HazardType hazard) {
        List<HazardEntry> entries = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry entry : entries) {
            if (entry.type != hazard) continue;
            return HazardModifier.evalAllModifiers(stack, null, entry.baseLevel, entry.mods);
        }
        return 0.0f;
    }

    public static float getRawRadsFromBlock(Block b) {
        return HazardSystem.getHazardLevelFromStack(new ItemStack((ItemLike)b.m_5456_()), ContaminationUtil.HazardType.RADIATION);
    }

    public static float getRawRadsFromStack(ItemStack stack) {
        return HazardSystem.getHazardLevelFromStack(stack, ContaminationUtil.HazardType.RADIATION);
    }

    public static float getTotalRadsFromStack(ItemStack stack) {
        return HazardSystem.getHazardLevelFromStack(stack, ContaminationUtil.HazardType.RADIATION) + ContaminationUtil.getNeutronRads(stack);
    }
}

