/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.item.custom;

import com.hbm.nucleartech.capability.HbmCapabilities;
import com.hbm.nucleartech.capability.energy.ItemBatteryProvider;
import com.hbm.nucleartech.capability.energy.WattHourStorage;
import com.hbm.nucleartech.interfaces.IWattHourStorage;
import com.hbm.nucleartech.item.custom.base.EnergyItem;
import com.hbm.nucleartech.util.FloatingLong;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends EnergyItem {
    private final FloatingLong capacity;
    private final FloatingLong maxReceive;
    private final FloatingLong maxExtract;
    private final FloatingLong startEnergy;

    public BatteryItem(Item.Properties properties, FloatingLong capacity, FloatingLong chargeRate, FloatingLong dischargeRate, FloatingLong initialCharge) {
        super(properties.setNoRepair().m_41487_(1), true, true);
        this.capacity = capacity;
        this.maxReceive = chargeRate;
        this.maxExtract = dischargeRate;
        this.startEnergy = initialCharge;
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        double energy = BatteryItem.getEnergyStored(stack).doubleValue();
        double max = BatteryItem.getMaxEnergyStored(stack).doubleValue();
        if (max <= 0.0) {
            return 0;
        }
        double frac = energy / max;
        frac = Math.max(0.0, Math.min(1.0, frac));
        return (int)Math.round(frac * 13.0);
    }

    public static String formatWattHoursStored(ItemStack stack) {
        return stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).map(IWattHourStorage::formatWattHoursStored).orElse(null);
    }

    public static String formatMaxWattHoursStored(ItemStack stack) {
        return stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).map(IWattHourStorage::formatMaxWattHoursStored).orElse(null);
    }

    public static String formatWattsCharge(ItemStack stack) {
        return stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).map(IWattHourStorage::formatWattsCharge).orElse(null);
    }

    public static String formatWattsDischarge(ItemStack stack) {
        return stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).map(IWattHourStorage::formatWattsDischarge).orElse(null);
    }

    public static FloatingLong getEnergyStored(ItemStack stack) {
        CompoundTag t;
        LazyOptional cap = stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE);
        if (cap.isPresent()) {
            return cap.map(IWattHourStorage::getWattageStored).orElse(FloatingLong.ZERO);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("WattHourStorage") && (t = stack.m_41783_().m_128469_("WattHourStorage")).m_128441_("Stored")) {
            return FloatingLong.create(t.m_128461_("Stored"));
        }
        return ((BatteryItem)stack.m_41720_()).startEnergy;
    }

    public static FloatingLong getMaxEnergyStored(ItemStack stack) {
        CompoundTag t;
        LazyOptional cap = stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE);
        if (cap.isPresent()) {
            return cap.map(IWattHourStorage::getMaxWattageStored).orElse(FloatingLong.ZERO);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("WattHourStorage") && (t = stack.m_41783_().m_128469_("WattHourStorage")).m_128441_("Capacity")) {
            return FloatingLong.create(t.m_128461_("Capacity"));
        }
        return ((BatteryItem)stack.m_41720_()).capacity;
    }

    public static FloatingLong addEnergy(ItemStack stack, FloatingLong amount, boolean simulate) {
        AtomicReference<FloatingLong> val = new AtomicReference<FloatingLong>(FloatingLong.ZERO);
        stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).ifPresent(cap -> val.set(cap.receiveWattage(amount, simulate)));
        return val.get();
    }

    public static FloatingLong removeEnergy(ItemStack stack, FloatingLong amount, boolean simulate) {
        AtomicReference<FloatingLong> val = new AtomicReference<FloatingLong>(FloatingLong.ZERO);
        stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).ifPresent(cap -> val.set(cap.extractWattage(amount, simulate)));
        return val.get();
    }

    public static boolean canExtract(ItemStack stack) {
        return stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).map(IWattHourStorage::canExtract).orElse(false);
    }

    public static boolean canReceive(ItemStack stack) {
        return stack.getCapability(HbmCapabilities.WATT_HOUR_STORAGE).map(IWattHourStorage::canReceive).orElse(false);
    }

    public int m_142159_(ItemStack pStack) {
        return 65280;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        FloatingLong start = nbt != null && nbt.m_128441_("WattHourStorage") ? FloatingLong.create(nbt.m_128469_("WattHourStorage").m_128461_("Stored")) : this.startEnergy;
        WattHourStorage storage = new WattHourStorage(this.capacity, this.maxReceive, this.maxExtract, start);
        return new ItemBatteryProvider(stack, storage);
    }
}

