/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.item.custom;

import com.hbm.nucleartech.capability.HbmCapabilities;
import com.hbm.nucleartech.handler.RadiationSystemChunksNT;
import com.hbm.nucleartech.interfaces.IEntityCapabilityBase;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.sound.RegisterSounds;
import com.hbm.nucleartech.util.ContaminationUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class GeigerCounterItem
extends Item {
    public static final Map<Integer, SoundEvent> soundMap = new HashMap<Integer, SoundEvent>();
    public static boolean jmp = false;

    public GeigerCounterItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
    }

    public static void initSoundMap() {
        soundMap.put(1, (SoundEvent)RegisterSounds.GEIGER_1.get());
        soundMap.put(2, (SoundEvent)RegisterSounds.GEIGER_2.get());
        soundMap.put(3, (SoundEvent)RegisterSounds.GEIGER_3.get());
        soundMap.put(4, (SoundEvent)RegisterSounds.GEIGER_4.get());
        soundMap.put(5, (SoundEvent)RegisterSounds.GEIGER_5.get());
        soundMap.put(6, (SoundEvent)RegisterSounds.GEIGER_6.get());
        soundMap.put(7, (SoundEvent)RegisterSounds.GEIGER_7.get());
        soundMap.put(8, (SoundEvent)RegisterSounds.GEIGER_8.get());
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!(pEntity instanceof LivingEntity) || pLevel.f_46443_) {
            return;
        }
        float x = GeigerCounterItem.getRad((LivingEntity)pEntity);
        if (pLevel.m_46467_() % 5L == 0L) {
            if ((double)x > 1.0E-5) {
                int r;
                ArrayList<Integer> list = new ArrayList<Integer>();
                if (x < 1.0f) {
                    list.add(0);
                }
                if (x < 5.0f) {
                    list.add(0);
                }
                if (x < 10.0f) {
                    list.add(1);
                }
                if (x > 5.0f && x < 15.0f) {
                    list.add(2);
                }
                if (x > 10.0f && x < 20.0f) {
                    list.add(3);
                }
                if (x > 15.0f && x < 25.0f) {
                    list.add(4);
                }
                if (x > 20.0f && x < 30.0f) {
                    list.add(5);
                }
                if (x > 25.0f && x < 55.0f) {
                    list.add(6);
                }
                if (x > 40.0f && x < 80.0f) {
                    list.add(7);
                }
                if (x > 60.0f) {
                    list.add(8);
                }
                if ((r = ((Integer)list.get(pLevel.f_46441_.m_188503_(list.size()))).intValue()) > 0) {
                    SoundEvent sound = soundMap.get(r);
                    if (sound == null) {
                        System.err.println("[Error] Missing geiger sound for level " + r);
                    } else {
                        pLevel.m_5594_(null, pEntity.m_20097_().m_7918_(0, 1, 0), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            } else if (pLevel.f_46441_.m_188503_(50) == 0) {
                pLevel.m_5594_(null, pEntity.m_20097_().m_7918_(0, 1, 0), soundMap.get(1 + pLevel.f_46441_.m_188503_(1)), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public static void setFloat(ItemStack stack, float i, String name) {
        stack.m_41784_().m_128350_(name, i);
    }

    public static float getFloat(ItemStack stack, String name) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(name)) {
            return stack.m_41783_().m_128457_(name);
        }
        return 0.0f;
    }

    public static int check(Level level, int x, int y, int z) {
        return (int)Math.ceil(RadiationSystemChunksNT.getRadForCoord(level, new BlockPos(x, y, z)));
    }

    public static float getRad(LivingEntity pEntity) {
        return (float)(HbmCapabilities.getData((Entity)pEntity).getValue(IEntityCapabilityBase.Type.RADENV) + HbmCapabilities.getData((Entity)pEntity).getValue(IEntityCapabilityBase.Type.NEUTRON));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.m_5776_()) {
            pLevel.m_5594_(null, pPlayer.m_20097_().m_7918_(0, 1, 0), (SoundEvent)RegisterSounds.TECH_BOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            ContaminationUtil.printGeigerData(pPlayer);
        }
        return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pUsedHand));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public class CustomHudOverlay {
        private static final ResourceLocation RAD_COUNTER = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"textures/misc/overlay_misc.png");
        private static long lastRadSurvey;
        public static int ticks;
        public static long oldgt;
        public static float radiation;
        public static float radPS;

        @SubscribeEvent
        public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && !mc.f_91066_.f_92062_) {
                boolean hasItem = false;
                for (ItemStack stack : mc.f_91074_.m_150109_().f_35974_) {
                    if (stack.m_41720_() != RegisterItems.GEIGER_COUNTER.get()) continue;
                    hasItem = true;
                    break;
                }
                if (hasItem) {
                    GuiGraphics gui = event.getGuiGraphics();
                    if (mc.f_91074_ == null || mc.f_91066_.f_92062_) {
                        return;
                    }
                    if (System.currentTimeMillis() >= lastRadSurvey + 1000L) {
                        lastRadSurvey = System.currentTimeMillis();
                        radPS = GeigerCounterItem.getRad((LivingEntity)mc.f_91074_);
                        radiation = (float)HbmCapabilities.getData((Entity)mc.f_91074_).getValue(IEntityCapabilityBase.Type.RADIATION);
                    }
                    int screenHeight = mc.m_91268_().m_85446_();
                    int posX = 3;
                    int posY = screenHeight - 20;
                    int maxRad = 1000;
                    int barLength = (int)(74.0f * Math.min(radiation / (float)maxRad, 1.0f));
                    gui.m_280218_(RAD_COUNTER, posX, posY, 0, 0, 94, 18);
                    gui.m_280218_(RAD_COUNTER, posX + 1, posY + 1, 1, 19, barLength, 16);
                    if (radiation >= 25.0f) {
                        gui.m_280218_(RAD_COUNTER, posX + 94 + 2, posY, 36, 36, 18, 18);
                    } else if (radiation >= 10.0f) {
                        gui.m_280218_(RAD_COUNTER, posX + 94 + 2, posY, 18, 36, 18, 18);
                    } else if ((double)radiation >= 2.5) {
                        gui.m_280218_(RAD_COUNTER, posX + 94 + 2, posY, 0, 36, 18, 18);
                    }
                    if (radPS > 1000.0f) {
                        gui.m_280430_(mc.f_91062_, (Component)Component.m_237113_((String)">1000 RAD/s"), posX, posY - 10, 0xFF0000);
                    } else if (radPS >= 1.0f) {
                        gui.m_280430_(mc.f_91062_, (Component)Component.m_237113_((String)(Math.round(radPS) + " RAD/s")), posX, posY - 10, 0xFFFF00);
                    } else if (radPS > 0.0f) {
                        gui.m_280430_(mc.f_91062_, (Component)Component.m_237113_((String)"<1 RAD/s"), posX, posY - 10, 65280);
                    }
                }
            }
            if (mc.f_91074_ == null) {
                return;
            }
            if (jmp) {
                if (mc.f_91073_.m_46467_() != oldgt) {
                    BlockPos pos = mc.f_91074_.m_20097_().m_7918_(0, 1, 0);
                    if (ticks == 0) {
                        System.out.println("0, playing sound");
                        mc.f_91073_.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)RegisterSounds.JMP_SCR.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                    }
                    ++ticks;
                    oldgt = mc.f_91073_.m_46467_();
                }
                GuiGraphics guiGraphics = event.getGuiGraphics();
                int screenWidth = mc.m_91268_().m_85445_();
                int screenHeight = mc.m_91268_().m_85446_();
                int frame = ticks % 13;
                ResourceLocation texture = RadiationSystemChunksNT.RadiationEventHandlers.FRAMES[frame];
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                guiGraphics.m_280163_(texture, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
                RenderSystem.disableBlend();
                if (ticks == 13) {
                    jmp = false;
                    ticks = 0;
                }
            }
        }

        static {
            ticks = 0;
            oldgt = 0L;
            radiation = 0.0f;
            radPS = 0.0f;
        }
    }
}

