/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.item.custom;

import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.item.custom.base.GasmaskItem;
import com.hbm.nucleartech.render.armor.HazmatGreyRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HazmatHeadGreyItem
extends GasmaskItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HazmatHeadGreyItem(Item.Properties s, ArmorMaterial material) {
        super(s, material, "hbm:textures/item/armor/hazmat_grey.png", null, "animation.hazmat_grey.no_filter", "animation.hazmat_grey.filter");
    }

    @Override
    public boolean isCompleteSet(List<ArmorItem> set) {
        for (ArmorItem item : set) {
            switch (item.m_266204_()) {
                case HELMET: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_HELMET_GREY.get())) break;
                    return false;
                }
                case CHESTPLATE: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_CHESTPLATE_GREY.get())) break;
                    return false;
                }
                case LEGGINGS: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_LEGGINGS_GREY.get())) break;
                    return false;
                }
                case BOOTS: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_BOOTS_GREY.get())) break;
                    return false;
                }
            }
        }
        return true;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new HazmatGreyRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

