/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.item.custom;

import com.hbm.nucleartech.handler.ArmorModHandler;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.item.special.ItemArmorMod;
import com.hbm.nucleartech.render.armor.HazmatRedRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HazmatRedItem
extends ItemArmorMod
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HazmatRedItem(Item.Properties s, ArmorMaterial material, ArmorItem.Type type) {
        super(s, material, type, type == ArmorModHandler.helmet_only, type == ArmorModHandler.plate_only, type == ArmorModHandler.legs_only, type == ArmorModHandler.boots_only);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "hbm:textures/item/armor/hazmat_red.png";
    }

    @Override
    public boolean isCompleteSet(List<ArmorItem> set) {
        for (ArmorItem item : set) {
            switch (item.m_266204_()) {
                case HELMET: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_HELMET_RED.get())) break;
                    return false;
                }
                case CHESTPLATE: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_CHESTPLATE_RED.get())) break;
                    return false;
                }
                case LEGGINGS: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_LEGGINGS_RED.get())) break;
                    return false;
                }
                case BOOTS: {
                    if (item.m_7968_().m_150930_((Item)RegisterItems.HAZMAT_BOOTS_RED.get())) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new HazmatRedRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 0, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

