/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.item.custom;

import com.hbm.nucleartech.capability.energy.WattHourStorage;
import com.hbm.nucleartech.item.custom.base.EnergyItem;
import net.minecraft.world.item.Item;

public class SelfChargingBatteryItem
extends EnergyItem {
    protected final double dischargeRate;

    public SelfChargingBatteryItem(Item.Properties pProperties, double dischargeRate) {
        super(pProperties.m_41487_(1), false, true);
        this.dischargeRate = dischargeRate;
    }

    public double getDischargeRate() {
        return this.dischargeRate;
    }

    public String formatWattsDischarge() {
        int unitIndex;
        double value = WattHourStorage.translateWattHours(this.dischargeRate / 3.6);
        if (value < 1000.0) {
            return (float)value + "W";
        }
        String[] units = new String[]{"W", "kW", "MW", "GW", "TW", "PW", "EW", "ZW", "YW", "RW", "QW", "?W"};
        for (unitIndex = 0; value >= 1000.0 && unitIndex < units.length - 1; value /= 1000.0, ++unitIndex) {
        }
        String formatted = String.format("%.1f", Float.valueOf((float)value));
        return formatted + units[unitIndex];
    }
}

