/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.item.custom.base;

import com.hbm.nucleartech.handler.ArmorModHandler;
import com.hbm.nucleartech.interfaces.IGasMask;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.item.special.ItemArmorMod;
import com.hbm.nucleartech.util.ArmorRegistry;
import com.hbm.nucleartech.util.ArmorUtil;
import com.hbm.nucleartech.util.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GasmaskItem
extends ItemArmorMod
implements IGasMask,
GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private String tex;
    private String tex_mono;
    private String no_filter;
    private String filter;

    public GasmaskItem(Item.Properties s, ArmorMaterial material, String tex, @Nullable String tex_mono, String no_filter, String filter) {
        super(s, material, ArmorModHandler.helmet_only, true, false, false, false);
        this.tex = tex;
        this.tex_mono = tex_mono;
        this.no_filter = no_filter;
        this.filter = filter;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.tex;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        list.add((Component)Component.m_237119_());
        ArmorUtil.addGasMaskTooltip(stack, worldIn, list, flagIn);
        ArrayList<ArmorRegistry.HazardClass> haz = this.getBlacklist(stack);
        if (!haz.isEmpty()) {
            list.add((Component)Component.m_237113_((String)("\u00a7c" + I18nUtil.resolveKey("hazard.never_protects", new Object[0]))));
            for (ArmorRegistry.HazardClass clazz : haz) {
                list.add((Component)Component.m_237113_((String)("\u00a74 -" + I18nUtil.resolveKey(clazz.lang, new Object[0]))));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addDesc(List<Component> list, ItemStack stack, ItemStack armor) {
        list.add((Component)Component.m_237113_((String)("\u00a7a  " + String.valueOf(stack.m_41611_()) + " (gas protection)")));
        ArmorUtil.addGasMaskTooltip(stack, null, list, (TooltipFlag)TooltipFlag.f_256752_);
    }

    @Override
    public ArrayList<ArmorRegistry.HazardClass> getBlacklist(ItemStack stack) {
        if (this.m_5524_().equals(((Item)RegisterItems.M65_MASK.get()).m_5524_())) {
            return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_CORROSIVE, ArmorRegistry.HazardClass.NERVE_AGENT));
        }
        return new ArrayList<ArmorRegistry.HazardClass>();
    }

    @Override
    public ItemStack getFilter(ItemStack stack) {
        return ArmorUtil.getGasMaskFilter(stack);
    }

    @Override
    public void installFilter(ItemStack stack, ItemStack filter) {
        ArmorUtil.installGasMaskFilter(stack, filter);
    }

    @Override
    public void damageFilter(ItemStack stack, int damage) {
        ArmorUtil.damageGasMaskFilter(stack, damage);
    }

    @Override
    public boolean isFilterApplicable(ItemStack stack, ItemStack filter) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack;
        ItemStack filter;
        if (pPlayer.m_6047_() && (filter = this.getFilter(stack = pPlayer.m_21120_(pUsedHand))) != null) {
            ArmorUtil.removeFilter(stack);
            if (!pPlayer.m_150109_().m_36054_(filter)) {
                pPlayer.m_7197_(filter, true, false);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 0, state -> {
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (!(entity instanceof LivingEntity) || ArmorUtil.getGasMaskFilterRecursively(((LivingEntity)entity).m_6844_(EquipmentSlot.HEAD)).m_41619_()) {
                state.setAnimation(RawAnimation.begin().thenLoop(this.no_filter));
            } else {
                state.setAnimation(RawAnimation.begin().thenLoop(this.filter));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

