/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.modules;

import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.lib.Library;
import com.hbm.nucleartech.util.ArmorRegistry;
import com.hbm.nucleartech.util.ArmorUtil;
import com.hbm.nucleartech.util.ContaminationUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemHazardModule {
    public double radiation;
    public double digamma;
    public int fire;
    public int cryogenic;
    public int toxic;
    public boolean blinding;
    public int asbestos;
    public int coal;
    public boolean hydro;
    public float explosive;
    public float tempMod = 1.0f;

    public void setMod(float tempMod) {
        this.tempMod = tempMod;
    }

    public boolean isRadioactive() {
        return this.radiation > 0.0;
    }

    public void addRadiation(double radiation) {
        this.radiation = radiation;
    }

    public void addDigamma(double digamma) {
        this.digamma = digamma;
    }

    public void addFire(int fire) {
        this.fire = fire;
    }

    public void addCryogenic(int cryogenic) {
        this.cryogenic = cryogenic;
    }

    public void addToxic(int toxiclvl) {
        this.toxic = toxiclvl;
    }

    public void addCoal(int coal) {
        this.coal = coal;
    }

    public void addAsbestos(int asbestos) {
        this.asbestos = asbestos;
    }

    public void addBlinding() {
        this.blinding = true;
    }

    public void addHydroReactivity() {
        this.hydro = true;
    }

    public void addExplosive(float bang) {
        this.explosive = bang;
    }

    public void applyEffects(LivingEntity entity, float mod, int slot, boolean currentItem, InteractionHand hand) {
        boolean reacher = false;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            reacher = Library.checkForHeld(player, (Item)RegisterItems.REACHER.get());
        }
        if (this.radiation * (double)this.tempMod > 0.0) {
            double rad = this.radiation * (double)this.tempMod * (double)mod / 20.0;
            if (reacher) {
                rad = Math.min(Math.sqrt(rad), rad);
            }
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, (float)rad);
        }
        if ((float)this.toxic * this.tempMod > 0.0f) {
            boolean hasToxFilter = false;
            boolean hasHazmat = false;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (ArmorRegistry.hasProtection((LivingEntity)player, EquipmentSlot.HEAD, ArmorRegistry.HazardClass.NERVE_AGENT)) {
                    ArmorUtil.damageGasMaskFilter((LivingEntity)player, 1);
                    hasToxFilter = true;
                }
                hasHazmat = ArmorUtil.checkForHazmat(entity);
            }
            if (!hasToxFilter && !hasHazmat) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 110, this.toxic - 1, true, false));
                if (this.toxic > 2) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 110, Math.min(4, this.toxic - 1), true, false));
                }
                if (this.toxic > 4) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 110, this.toxic, true, false));
                }
                if (this.toxic > 6 && entity.m_9236_().f_46441_.m_188503_(2000 / this.toxic) == 0) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 110, this.toxic - 4, true, false));
                }
            }
            if (!hasHazmat || !hasToxFilter) {
                if (this.toxic > 8) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 110, this.toxic - 6, true, false));
                }
                if (this.toxic > 16) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 110, this.toxic - 16, true, false));
                }
            }
        }
    }

    public static double getNewValue(double radiation) {
        if (radiation < 1000000.0) {
            return radiation;
        }
        if (radiation < 1.0E9) {
            return radiation * 1.0E-6;
        }
        return radiation * 1.0E-9;
    }

    public static String getSuffix(double radiation) {
        if (radiation < 1000000.0) {
            return "";
        }
        if (radiation < 1.0E9) {
            return "M";
        }
        return "B";
    }

    public void addInformation(ItemStack stack, List<Component> list, TooltipFlag flagIn) {
        if (this.radiation * (double)this.tempMod > 0.0) {
            list.add((Component)Component.m_237113_((String)"\u00a7a[Radioactive]"));
            double itemRad = this.radiation * (double)this.tempMod;
            list.add((Component)Component.m_237113_((String)("\u00a7e" + Library.roundDouble(ItemHazardModule.getNewValue(itemRad), 3) + ItemHazardModule.getSuffix(itemRad) + " RAD/s")));
            if (stack.m_41613_() > 1) {
                double stackRad = this.radiation * (double)this.tempMod * (double)stack.m_41613_();
                list.add((Component)Component.m_237113_((String)("\u00a7eStack: " + Library.roundDouble(ItemHazardModule.getNewValue(stackRad), 3) + ItemHazardModule.getSuffix(stackRad) + " RAD/s")));
            }
        }
        if ((float)this.toxic * this.tempMod > 0.0f) {
            if (this.toxic > 16) {
                list.add((Component)Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"adjective.extreme")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"trait.toxic")).m_130946_("]").m_130940_(ChatFormatting.GREEN));
            } else if (this.toxic > 8) {
                list.add((Component)Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"adjective.very_high")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"trait.toxic")).m_130946_("]").m_130940_(ChatFormatting.GREEN));
            } else if (this.toxic > 4) {
                list.add((Component)Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"adjective.high")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"trait.toxic")).m_130946_("]").m_130940_(ChatFormatting.GREEN));
            } else if (this.toxic > 2) {
                list.add((Component)Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"adjective.medium")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"trait.toxic")).m_130946_("]").m_130940_(ChatFormatting.GREEN));
            } else {
                list.add((Component)Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"adjective.low")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"trait.toxic")).m_130946_("]").m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    public boolean onEntityItemUpdate(ItemEntity item) {
        if (!item.m_9236_().f_46443_) {
            if (this.hydro && item.m_20070_()) {
                item.m_142687_(Entity.RemovalReason.KILLED);
                item.m_9236_().m_254849_((Entity)item, item.m_20182_().f_82479_, item.m_20182_().f_82480_, item.m_20182_().f_82481_, 2.0f, Level.ExplosionInteraction.TNT);
                return true;
            }
            if (this.explosive > 0.0f && item.m_6060_()) {
                item.m_142687_(Entity.RemovalReason.KILLED);
                item.m_9236_().m_254849_((Entity)item, item.m_20182_().f_82479_, item.m_20182_().f_82480_, item.m_20182_().f_82481_, this.explosive, Level.ExplosionInteraction.TNT);
                return true;
            }
            if (this.isRadioactive()) {
                ContaminationUtil.radiate((ServerLevel)item.m_9236_(), item.m_20097_().m_123341_(), item.m_20097_().m_123342_() + 1, item.m_20097_().m_123343_(), 32.0, (float)(this.radiation * 4.0E-5 - 8.0E-4), item.m_20097_().m_7918_(0, 1, 0));
            }
        }
        return false;
    }
}

