/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.network.packet;

import com.hbm.nucleartech.block.entity.BurnerPressEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundBurnerPressPacket {
    public final BlockPos pos;
    public final boolean stamping;
    public final int progress;
    public final int maxProgress;
    public final int heat;
    public final int maxHeat;
    public final int fuel;
    public final int maxFuel;
    public final float speedMod;
    public final boolean stamped;
    public final ItemStack displayStack;

    public ClientboundBurnerPressPacket(int x, int y, int z, boolean stamping, int progress, int maxProgress, int heat, int maxHeat, int fuel, int maxFuel, float speedMod, boolean stamped, ItemStack displayStack) {
        this.pos = new BlockPos(x, y, z);
        this.stamping = stamping;
        this.progress = progress;
        this.maxProgress = maxProgress;
        this.heat = heat;
        this.maxHeat = maxHeat;
        this.fuel = fuel;
        this.maxFuel = maxFuel;
        this.speedMod = speedMod;
        this.stamped = stamped;
        this.displayStack = displayStack;
    }

    public static void encode(ClientboundBurnerPressPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.pos.m_123341_());
        buf.writeInt(msg.pos.m_123342_());
        buf.writeInt(msg.pos.m_123343_());
        buf.writeBoolean(msg.stamping);
        buf.writeInt(msg.progress);
        buf.writeInt(msg.maxProgress);
        buf.writeInt(msg.heat);
        buf.writeInt(msg.maxHeat);
        buf.writeInt(msg.fuel);
        buf.writeInt(msg.maxFuel);
        buf.writeFloat(msg.speedMod);
        buf.writeBoolean(msg.stamped);
        buf.writeItemStack(msg.displayStack, false);
    }

    public static ClientboundBurnerPressPacket decode(FriendlyByteBuf buf) {
        return new ClientboundBurnerPressPacket(buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readFloat(), buf.readBoolean(), buf.m_130267_());
    }

    public static void handle(ClientboundBurnerPressPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity e;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (e = level.m_7702_(msg.pos)) instanceof BurnerPressEntity) {
                BurnerPressEntity burnerPress = (BurnerPressEntity)e;
                burnerPress.stamping = msg.stamping;
                burnerPress.progress = msg.progress;
                burnerPress.maxProgress = msg.maxProgress;
                burnerPress.heat = msg.heat;
                burnerPress.maxHeat = msg.maxHeat;
                burnerPress.fuel = msg.fuel;
                burnerPress.maxFuel = msg.maxFuel;
                burnerPress.speedMod = msg.speedMod;
                burnerPress.stamped = msg.stamped;
                burnerPress.setDisplayStack(msg.displayStack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

