/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;
    private final ResourceLocation id;

    public PressRecipe(NonNullList<Ingredient> ingredients, ItemStack result, ResourceLocation id) {
        this.ingredients = ingredients;
        this.result = result;
        this.id = id;
    }

    public boolean matches(@NotNull SimpleContainer pContainer, Level pLevel) {
        if (pLevel.f_46443_) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(pContainer.m_8020_(1)) && ((Ingredient)this.ingredients.get(1)).test(pContainer.m_8020_(2));
    }

    public String toString() {
        return "PressRecipe{ingredients=" + String.valueOf(this.ingredients) + ", result=" + String.valueOf(this.result) + ", id=" + String.valueOf(this.id) + "}";
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<PressRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"press");

        public PressRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new PressRecipe((NonNullList<Ingredient>)inputs, result, pRecipeId);
        }

        @Nullable
        public PressRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack result = pBuffer.m_130267_();
            return new PressRecipe((NonNullList<Ingredient>)inputs, result, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PressRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<PressRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "press";
    }
}

