/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.nucleartech.datagen.ModRecipeProvider;
import com.hbm.nucleartech.util.FloatingLong;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShredderRecipe
implements Recipe<SimpleContainer> {
    private final Ingredient ingredient;
    private final NonNullList<Pair<Item, ModRecipeProvider.MetaData>> results;
    private final int ticks;
    private final FloatingLong powerConsumption;
    private final ResourceLocation id;

    public ShredderRecipe(Ingredient ingredient, NonNullList<Pair<Item, ModRecipeProvider.MetaData>> results, int ticks, FloatingLong powerConsumption, ResourceLocation id) {
        this.ingredient = ingredient;
        this.results = results;
        this.ticks = ticks;
        this.powerConsumption = powerConsumption;
        this.id = id;
    }

    public boolean matches(@NotNull SimpleContainer pContainer, Level pLevel) {
        if (pLevel.f_46443_) {
            return false;
        }
        return this.ingredient.test(pContainer.m_8020_(0));
    }

    public String toString() {
        return "ShredderRecipe{ingredient=" + String.valueOf(this.ingredient) + ", results=" + String.valueOf(this.results) + ", ticks=" + this.ticks + ", powerConsumption=" + String.valueOf(this.powerConsumption) + ", id=" + String.valueOf(this.id) + "}";
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.results.isEmpty() ? ItemStack.f_41583_ : ((Item)((Pair)this.results.get(0)).left()).m_7968_().m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.results.isEmpty() ? ItemStack.f_41583_ : ((Item)((Pair)this.results.get(0)).left()).m_7968_().m_41777_();
    }

    public NonNullList<Pair<Item, ModRecipeProvider.MetaData>> getResults() {
        return this.results;
    }

    public int getTicks() {
        return this.ticks;
    }

    public FloatingLong getPowerConsumption() {
        return this.powerConsumption;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList result = NonNullList.m_182647_((int)1);
        result.add(0, (Object)this.ingredient);
        return result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ShredderRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"shredder");

        public ShredderRecipe fromJson(ResourceLocation pRecipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            NonNullList results = NonNullList.m_122779_();
            JsonArray arr = GsonHelper.m_13933_((JsonObject)json, (String)"results");
            for (JsonElement e : arr) {
                JsonObject obj = e.getAsJsonObject();
                Item left = GsonHelper.m_13909_((JsonObject)obj, (String)"item");
                JsonObject metadata = GsonHelper.m_13930_((JsonObject)obj, (String)"metadata");
                int minAmount = GsonHelper.m_13927_((JsonObject)metadata, (String)"min_amount");
                int maxAmount = GsonHelper.m_13927_((JsonObject)metadata, (String)"max_amount");
                int chance = GsonHelper.m_13927_((JsonObject)metadata, (String)"chance");
                ModRecipeProvider.MetaData right = new ModRecipeProvider.MetaData(minAmount, maxAmount, chance);
                results.add((Object)Pair.of((Object)left, (Object)right));
            }
            int ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
            FloatingLong powerConsumption = FloatingLong.create(GsonHelper.m_13906_((JsonObject)json, (String)"power_consumption"));
            return new ShredderRecipe(input, (NonNullList<Pair<Item, ModRecipeProvider.MetaData>>)results, ticks, powerConsumption, pRecipeId);
        }

        @Nullable
        public ShredderRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int count = buf.m_130242_();
            NonNullList results = NonNullList.m_122780_((int)count, (Object)Pair.of(null, null));
            for (int i = 0; i < count; ++i) {
                results.set(i, (Object)Pair.of((Object)buf.m_130267_().m_41720_(), (Object)new ModRecipeProvider.MetaData(buf.readInt(), buf.readInt(), buf.readInt())));
            }
            int ticks = buf.readInt();
            FloatingLong powerConsumption = FloatingLong.create(buf.m_130277_());
            return new ShredderRecipe(input, (NonNullList<Pair<Item, ModRecipeProvider.MetaData>>)results, ticks, powerConsumption, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf buf, ShredderRecipe recipe) {
            recipe.ingredient.m_43923_(buf);
            buf.m_130130_(recipe.results.size());
            for (Pair stack : recipe.results) {
                buf.m_130055_(((Item)stack.left()).m_7968_());
                buf.writeInt(((ModRecipeProvider.MetaData)stack.right()).getMinCount());
                buf.writeInt(((ModRecipeProvider.MetaData)stack.right()).getMaxCount());
                buf.writeInt(((ModRecipeProvider.MetaData)stack.right()).getChance());
            }
            buf.writeInt(recipe.ticks);
            buf.m_130070_(recipe.powerConsumption.toString());
        }
    }

    public static class Type
    implements RecipeType<ShredderRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "shredder";
    }
}

