/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.render.amlfrom1710;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;

public class Vec3 {
    public double xCoord;
    public double yCoord;
    public double zCoord;

    public static Vec3 createVectorHelper(double p_72443_0_, double p_72443_2_, double p_72443_4_) {
        return new Vec3(p_72443_0_, p_72443_2_, p_72443_4_);
    }

    public static Vec3 createVectorHelper(Entity e) {
        return new Vec3(e.m_20185_(), e.m_20186_(), e.m_20189_());
    }

    public Vec3(net.minecraft.world.phys.Vec3 vec) {
        this.xCoord = vec.f_82479_;
        this.yCoord = vec.f_82480_;
        this.zCoord = vec.f_82481_;
    }

    public Vec3(BlockPos vec) {
        this.xCoord = vec.m_123341_();
        this.yCoord = vec.m_123342_();
        this.zCoord = vec.m_123343_();
    }

    public Vec3(double p_i1108_1_, double p_i1108_3_, double p_i1108_5_) {
        if (p_i1108_1_ == -0.0) {
            p_i1108_1_ = 0.0;
        }
        if (p_i1108_3_ == -0.0) {
            p_i1108_3_ = 0.0;
        }
        if (p_i1108_5_ == -0.0) {
            p_i1108_5_ = 0.0;
        }
        this.xCoord = p_i1108_1_;
        this.yCoord = p_i1108_3_;
        this.zCoord = p_i1108_5_;
    }

    public Vec3 setComponents(double p_72439_1_, double p_72439_3_, double p_72439_5_) {
        this.xCoord = p_72439_1_;
        this.yCoord = p_72439_3_;
        this.zCoord = p_72439_5_;
        return this;
    }

    public Vec3 set(Vec3 other) {
        return this.setComponents(other.xCoord, other.yCoord, other.zCoord);
    }

    public Vec3 subtract(Vec3 other) {
        return Vec3.createVectorHelper(this.xCoord - other.xCoord, this.yCoord - other.yCoord, this.zCoord - other.zCoord);
    }

    public Vec3 subtract(double x, double y, double z) {
        return new Vec3(this.xCoord - x, this.yCoord - y, this.zCoord - z);
    }

    public Vec3 normalize() {
        double d0 = Mth.m_14116_((float)((float)(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord)));
        return d0 < 1.0E-4 ? Vec3.createVectorHelper(0.0, 0.0, 0.0) : Vec3.createVectorHelper(this.xCoord / d0, this.yCoord / d0, this.zCoord / d0);
    }

    public double dotProduct(Vec3 p_72430_1_) {
        return this.xCoord * p_72430_1_.xCoord + this.yCoord * p_72430_1_.yCoord + this.zCoord * p_72430_1_.zCoord;
    }

    public Vec3 crossProduct(Vec3 p_72431_1_) {
        return Vec3.createVectorHelper(this.yCoord * p_72431_1_.zCoord - this.zCoord * p_72431_1_.yCoord, this.zCoord * p_72431_1_.xCoord - this.xCoord * p_72431_1_.zCoord, this.xCoord * p_72431_1_.yCoord - this.yCoord * p_72431_1_.xCoord);
    }

    public Vec3 addVector(double p_72441_1_, double p_72441_3_, double p_72441_5_) {
        return Vec3.createVectorHelper(this.xCoord + p_72441_1_, this.yCoord + p_72441_3_, this.zCoord + p_72441_5_);
    }

    public Vec3 add(Vec3 other) {
        return new Vec3(this.xCoord + other.xCoord, this.yCoord + other.yCoord, this.zCoord + other.zCoord);
    }

    public double distanceTo(Vec3 p_72438_1_) {
        double d0 = p_72438_1_.xCoord - this.xCoord;
        double d1 = p_72438_1_.yCoord - this.yCoord;
        double d2 = p_72438_1_.zCoord - this.zCoord;
        return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    public double distanceTo(double x, double y, double z) {
        double d0 = x - this.xCoord;
        double d1 = y - this.yCoord;
        double d2 = z - this.zCoord;
        return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    public double distanceTo(Entity e) {
        double d0 = e.m_20185_() - this.xCoord;
        double d1 = e.m_20186_() - this.yCoord;
        double d2 = e.m_20189_() - this.zCoord;
        return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    public double squareDistanceTo(Vec3 p_72436_1_) {
        double d0 = p_72436_1_.xCoord - this.xCoord;
        double d1 = p_72436_1_.yCoord - this.yCoord;
        double d2 = p_72436_1_.zCoord - this.zCoord;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double squareDistanceTo(double p_72445_1_, double p_72445_3_, double p_72445_5_) {
        double d3 = p_72445_1_ - this.xCoord;
        double d4 = p_72445_3_ - this.yCoord;
        double d5 = p_72445_5_ - this.zCoord;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double lengthVector() {
        return Mth.m_14116_((float)((float)(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord)));
    }

    public double lengthSquared() {
        return this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord;
    }

    public Vec3 getIntermediateWithXValue(Vec3 p_72429_1_, double p_72429_2_) {
        double d1 = p_72429_1_.xCoord - this.xCoord;
        double d2 = p_72429_1_.yCoord - this.yCoord;
        double d3 = p_72429_1_.zCoord - this.zCoord;
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (p_72429_2_ - this.xCoord) / d1;
        return d4 >= 0.0 && d4 <= 1.0 ? Vec3.createVectorHelper(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4) : null;
    }

    public Vec3 getIntermediateWithYValue(Vec3 p_72435_1_, double p_72435_2_) {
        double d1 = p_72435_1_.xCoord - this.xCoord;
        double d2 = p_72435_1_.yCoord - this.yCoord;
        double d3 = p_72435_1_.zCoord - this.zCoord;
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (p_72435_2_ - this.yCoord) / d2;
        return d4 >= 0.0 && d4 <= 1.0 ? Vec3.createVectorHelper(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4) : null;
    }

    public Vec3 getIntermediateWithZValue(Vec3 p_72434_1_, double p_72434_2_) {
        double d1 = p_72434_1_.xCoord - this.xCoord;
        double d2 = p_72434_1_.yCoord - this.yCoord;
        double d3 = p_72434_1_.zCoord - this.zCoord;
        if (d3 * d3 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (p_72434_2_ - this.zCoord) / d3;
        return d4 >= 0.0 && d4 <= 1.0 ? Vec3.createVectorHelper(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4) : null;
    }

    public String toString() {
        return "(" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + ")";
    }

    public void rotateAroundX(float p_72440_1_) {
        float f1 = Mth.m_14089_((float)p_72440_1_);
        float f2 = Mth.m_14031_((float)p_72440_1_);
        double d0 = this.xCoord;
        double d1 = this.yCoord * (double)f1 + this.zCoord * (double)f2;
        double d2 = this.zCoord * (double)f1 - this.yCoord * (double)f2;
        this.setComponents(d0, d1, d2);
    }

    public void rotateAroundY(float p_72442_1_) {
        float f1 = Mth.m_14089_((float)p_72442_1_);
        float f2 = Mth.m_14031_((float)p_72442_1_);
        double d0 = this.xCoord * (double)f1 + this.zCoord * (double)f2;
        double d1 = this.yCoord;
        double d2 = this.zCoord * (double)f1 - this.xCoord * (double)f2;
        this.setComponents(d0, d1, d2);
    }

    public void rotateAroundZ(float p_72446_1_) {
        float f1 = Mth.m_14089_((float)p_72446_1_);
        float f2 = Mth.m_14031_((float)p_72446_1_);
        double d0 = this.xCoord * (double)f1 + this.yCoord * (double)f2;
        double d1 = this.yCoord * (double)f1 - this.xCoord * (double)f2;
        double d2 = this.zCoord;
        this.setComponents(d0, d1, d2);
    }

    public Vec3 interpolate(Vec3 other, double inter) {
        return Vec3.createVectorHelper(this.xCoord + (other.xCoord - this.xCoord) * inter, this.yCoord + (other.yCoord - this.yCoord) * inter, this.zCoord + (other.zCoord - this.zCoord) * inter);
    }

    public Vec3 mult(float mult) {
        return Vec3.createVectorHelper(this.xCoord * (double)mult, this.yCoord * (double)mult, this.zCoord * (double)mult);
    }

    public Vec3 multd(double mult) {
        return Vec3.createVectorHelper(this.xCoord * mult, this.yCoord * mult, this.zCoord * mult);
    }

    public Vec3 negate() {
        return new Vec3(-this.xCoord, -this.yCoord, -this.zCoord);
    }

    public Matrix3f outerProduct(Vec3 other) {
        Matrix3f mat = new Matrix3f((float)(this.xCoord * other.xCoord), (float)(this.xCoord * other.yCoord), (float)(this.xCoord * other.zCoord), (float)(this.yCoord * other.xCoord), (float)(this.yCoord * other.yCoord), (float)(this.yCoord * other.zCoord), (float)(this.zCoord * other.xCoord), (float)(this.zCoord * other.yCoord), (float)(this.zCoord * other.zCoord));
        return mat;
    }

    public Vec3 matTransform(Matrix3f mat) {
        double x = (double)mat.m00 * this.xCoord + (double)mat.m01 * this.yCoord + (double)mat.m02 * this.zCoord;
        double y = (double)mat.m10 * this.xCoord + (double)mat.m11 * this.yCoord + (double)mat.m12 * this.zCoord;
        double z = (double)mat.m20 * this.xCoord + (double)mat.m21 * this.yCoord + (double)mat.m22 * this.zCoord;
        return new Vec3(x, y, z);
    }

    public Vec3 copy() {
        return new Vec3(this.xCoord, this.yCoord, this.zCoord);
    }

    public net.minecraft.world.phys.Vec3 toVec3d() {
        return new net.minecraft.world.phys.Vec3(this.xCoord, this.yCoord, this.zCoord);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(Mth.m_14107_((double)this.xCoord), Mth.m_14107_((double)this.yCoord), Mth.m_14107_((double)this.zCoord));
    }

    public Vec3 max(double d) {
        return new Vec3(Math.max(this.xCoord, d), Math.max(this.yCoord, d), Math.max(this.zCoord, d));
    }

    public Vec3 min(double d) {
        return new Vec3(Math.min(this.xCoord, d), Math.min(this.yCoord, d), Math.min(this.zCoord, d));
    }
}

