/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.screen;

import com.hbm.nucleartech.block.RegisterBlocks;
import com.hbm.nucleartech.block.entity.BurnerPressEntity;
import com.hbm.nucleartech.screen.RegisterMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class BurnerPressMenu
extends AbstractContainerMenu {
    public final BurnerPressEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 4;

    public BurnerPressMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(7));
    }

    public BurnerPressMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)RegisterMenuTypes.BURNER_PRESS_MENU.get(), pContainerId);
        BurnerPressMenu.m_38869_((Container)inv, (int)4);
        this.blockEntity = (BurnerPressEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 0, 26, 53));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 1, 80, 17));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 2, 80, 53));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 3, 140, 35));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledPressProgress() {
        float progress = this.data.m_6413_(0);
        float maxProgress = this.data.m_6413_(1);
        int STAMP_HEIGHT = 16;
        if (maxProgress <= 0.0f) {
            return 0;
        }
        float phase = progress / maxProgress % 1.0f;
        if (phase < 0.0f) {
            phase += 1.0f;
        }
        float triangular = phase <= 0.5f ? phase * 2.0f : (1.0f - phase) * 2.0f;
        return Math.round(triangular * 16.0f);
    }

    public int getScaledFuelProgress() {
        int fuel = this.data.m_6413_(4);
        int maxFuel = this.data.m_6413_(5);
        int fireStampSize = 14;
        if (fuel <= 0 || maxFuel <= 0) {
            return 0;
        }
        return fuel * fireStampSize / maxFuel;
    }

    public int getHeatGaugeProgress() {
        int heat = this.data.m_6413_(2);
        int maxHeat = this.data.m_6413_(3);
        int idxSize = 12;
        if (heat <= 0 || maxHeat <= 0) {
            return 0;
        }
        return heat * idxSize / maxHeat;
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 40, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 40) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return BurnerPressMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)RegisterBlocks.BURNER_PRESS.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

