/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.screen;

import com.hbm.nucleartech.block.RegisterBlocks;
import com.hbm.nucleartech.block.entity.ShredderEntity;
import com.hbm.nucleartech.screen.RegisterMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class ShredderMenu
extends AbstractContainerMenu {
    public final ShredderEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 30;

    public ShredderMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(7));
    }

    public ShredderMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)RegisterMenuTypes.SHREDDER_MENU.get(), pContainerId);
        ShredderMenu.m_38869_((Container)inv, (int)30);
        this.blockEntity = (ShredderEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 0, 8, 80));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 1, 44, 80));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 2, 80, 80));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 3, 44, -10));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 4, 62, -10));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 5, 80, -10));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 6, 44, 8));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 7, 62, 8));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 8, 80, 8));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 9, 44, 26));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 10, 62, 26));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 11, 80, 26));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 12, 116, -10));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 13, 134, -10));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 14, 152, -10));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 15, 116, 8));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 16, 134, 8));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 17, 152, 8));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 18, 116, 26));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 19, 134, 26));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 20, 152, 26));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 21, 116, 44));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 22, 134, 44));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 23, 152, 44));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 24, 116, 62));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 25, 134, 62));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 26, 152, 62));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 27, 116, 80));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 28, 134, 80));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 29, 152, 80));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledShredderProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(6);
        int LENGTH = 33;
        return progress * 33 / maxProgress;
    }

    public int getScaledEnergyProgress() {
        return this.data.m_6413_(1);
    }

    public int[] getBladeDurability(byte side) {
        switch (side) {
            case 0: {
                int[] intAr = new int[]{this.data.m_6413_(2), this.data.m_6413_(4)};
                return intAr;
            }
            case 1: {
                int[] intAr = new int[]{this.data.m_6413_(3), this.data.m_6413_(5)};
                return intAr;
            }
        }
        return new int[]{-1, -1};
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 66, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 66) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return ShredderMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)RegisterBlocks.SHREDDER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 28));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 170));
        }
    }
}

