/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.screen;

import com.hbm.nucleartech.screen.ShredderMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ShredderScreen
extends AbstractContainerScreen<ShredderMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm", (String)"textures/gui/shredder_gui.png");

    public ShredderScreen(ShredderMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - (this.f_97727_ + 56)) / 2;
        pGuiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_ + 56);
        this.f_97729_ = this.f_97727_ / 2 - 105;
        this.f_97731_ = (this.f_97727_ + 56) / 2 - 11;
        this.renderShredProgress(pGuiGraphics, x, y);
        this.renderPowerBar(pGuiGraphics, x, y);
        this.renderLeftBlade(pGuiGraphics, x, y);
        this.renderRightBlade(pGuiGraphics, x, y);
    }

    private void renderRightBlade(GuiGraphics pGuiGraphics, int x, int y) {
        int vOffset;
        int uOffset;
        int[] durability = ((ShredderMenu)this.f_97732_).getBladeDurability((byte)1);
        if (durability[0] >= durability[1]) {
            uOffset = 196;
            vOffset = 37;
        } else if (durability[0] >= durability[1] / 2) {
            uOffset = 196;
            vOffset = 19;
        } else if (durability[0] >= 0 || durability[0] == -2) {
            uOffset = 196;
            vOffset = 1;
        } else {
            return;
        }
        pGuiGraphics.m_280218_(TEXTURE, x + 81, y + 72, uOffset, vOffset, 14, 15);
    }

    private void renderLeftBlade(GuiGraphics pGuiGraphics, int x, int y) {
        int vOffset;
        int uOffset;
        int[] durability = ((ShredderMenu)this.f_97732_).getBladeDurability((byte)0);
        if (durability[0] >= durability[1]) {
            uOffset = 178;
            vOffset = 37;
        } else if (durability[0] >= durability[1] / 2) {
            uOffset = 178;
            vOffset = 19;
        } else if (durability[0] >= 0 || durability[0] == -2) {
            uOffset = 178;
            vOffset = 1;
        } else {
            return;
        }
        pGuiGraphics.m_280218_(TEXTURE, x + 45, y + 72, uOffset, vOffset, 14, 15);
    }

    private void renderShredProgress(GuiGraphics pGuiGraphics, int x, int y) {
        if (((ShredderMenu)this.f_97732_).isCrafting()) {
            pGuiGraphics.m_280218_(TEXTURE, x + 64, y + 89, 177, 54, ((ShredderMenu)this.f_97732_).getScaledShredderProgress(), 13);
        }
    }

    private void renderPowerBar(GuiGraphics pGuiGraphics, int x, int y) {
        int filled = ((ShredderMenu)this.f_97732_).getScaledEnergyProgress();
        int yOffset = 18 + (88 - filled);
        int height = filled;
        int srcY = 72 + (88 - filled);
        pGuiGraphics.m_280218_(TEXTURE, x + 8, y + yOffset, 176, srcY, 16, height);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        if (ShredderScreen.isMouseOverGuiArea(pMouseX, pMouseY, 8, -10, this.f_97735_, this.f_97736_, 16, 88)) {
            String storedDisplay = ((ShredderMenu)this.f_97732_).blockEntity.formatWattHoursStored() + "/" + ((ShredderMenu)this.f_97732_).blockEntity.formatMaxWattHoursStored();
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            lines.add(Component.m_237113_((String)storedDisplay));
            String discharge = ((ShredderMenu)this.f_97732_).blockEntity.formatWattsDischarge();
            if (!Objects.equals(discharge, "0.0W")) {
                lines.add(Component.m_237110_((String)"ui.hbm.power_draw", (Object[])new Object[]{discharge}));
            }
            pGuiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, lines, pMouseX, pMouseY);
        }
    }

    public static boolean isMouseOverGuiArea(int mouseX, int mouseY, int relX, int relY, int leftPos, int topPos, int width, int height) {
        int gx = leftPos + relX;
        int gy = topPos + relY;
        return mouseX >= gx && mouseY >= gy && mouseX < gx + width && mouseY < gy + height;
    }
}

