/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.util;

import com.hbm.nucleartech.handler.ArmorModHandler;
import com.hbm.nucleartech.interfaces.IGasMask;
import com.hbm.nucleartech.util.ArmorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorRegistry {
    public static HashMap<Item, ArrayList<HazardClass>> hazardClasses = new HashMap();

    public static void registerHazard(Item item, HazardClass ... hazards) {
        hazardClasses.put(item, new ArrayList<HazardClass>(Arrays.asList(hazards)));
    }

    public static boolean hasAllProtection(LivingEntity entity, EquipmentSlot slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.m_6844_(slot));
        return list.containsAll(Arrays.asList(clazz));
    }

    public static boolean hasAnyProtection(LivingEntity entity, EquipmentSlot slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.m_6844_(slot));
        if (list == null) {
            return false;
        }
        for (HazardClass haz : clazz) {
            if (!list.contains((Object)haz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProtection(LivingEntity entity, EquipmentSlot slot, HazardClass clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.m_6844_(slot));
        if (list == null) {
            return false;
        }
        return list.contains((Object)clazz);
    }

    public static List<HazardClass> getProtectionFromItem(ItemStack stack) {
        IGasMask mask;
        ItemStack filter;
        ArrayList<HazardClass> prot = new ArrayList<HazardClass>();
        Item item = stack.m_41720_();
        if (hazardClasses.containsKey(item)) {
            prot.addAll((Collection)hazardClasses.get(item));
        }
        if (item instanceof IGasMask && (filter = (mask = (IGasMask)item).getFilter(stack)) != null && !filter.m_41619_()) {
            List filProt = hazardClasses.get(filter.m_41720_());
            for (HazardClass c : mask.getBlacklist(stack)) {
                filProt.remove((Object)c);
            }
            prot.addAll(filProt);
        }
        if (ArmorModHandler.hasMods(stack)) {
            ItemStack[] mods;
            for (ItemStack mod : mods = ArmorModHandler.pryMods(stack)) {
                if (mod == null) continue;
                prot.addAll(ArmorRegistry.getProtectionFromItem(mod));
            }
        }
        return prot;
    }

    public static enum HazardClass {
        GAS_CHLORINE("hazard.gas_chlorine"),
        GAS_MONOXIDE("hazard.gas_monoxide"),
        GAS_INERT("hazard.gas_inert"),
        PARTICLE_COARSE("hazard.particle_coarse"),
        PARTICLE_FINE("hazard.particle_fine"),
        BACTERIA("hazard.bacteria"),
        NERVE_AGENT("hazard.nerve_agent"),
        GAS_CORROSIVE("hazard.corrosive"),
        SAND("hazard.sand"),
        LIGHT("hazard.light"),
        RAD_GAS("hazard.radGas");

        public final String lang;

        private HazardClass(String lang) {
            this.lang = lang;
        }
    }
}

