/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.util;

import com.hbm.nucleartech.handler.ArmorModHandler;
import com.hbm.nucleartech.handler.HazmatRegistry;
import com.hbm.nucleartech.interfaces.IGasMask;
import com.hbm.nucleartech.item.RegisterItems;
import com.hbm.nucleartech.lib.Library;
import com.hbm.nucleartech.util.ArmorRegistry;
import com.hbm.nucleartech.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class ArmorUtil {
    public static final String[] metals = new String[]{"chainmail", "iron", "silver", "gold", "platinum", "tin", "lead", "liquidator", "schrabidium", "euphemium", "steel", "cmb", "titanium", "alloy", "copper", "bronze", "electrum", "t45", "bj", "starmetal", "hazmat", "rubber", "hev", "ajr", "rpa", "spacesuit"};
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    public static final String FILTER_KEY = "hfrFilter";

    public static void register() {
        ArmorRegistry.registerHazard((Item)RegisterItems.GAS_MASK_FILTER.get(), ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA);
        ArmorRegistry.registerHazard((Item)RegisterItems.GAS_MASK_FILTER_MONO.get(), ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_MONOXIDE);
        ArmorRegistry.registerHazard((Item)RegisterItems.GAS_MASK_FILTER_COMBO.get(), ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.NERVE_AGENT);
        ArmorRegistry.registerHazard((Item)RegisterItems.GAS_MASK_FILTER_RADON.get(), ArmorRegistry.HazardClass.RAD_GAS, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.NERVE_AGENT);
        ArmorRegistry.registerHazard((Item)RegisterItems.M65_MASK.get(), ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard((Item)RegisterItems.HAZMAT_HELMET.get(), ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard((Item)RegisterItems.HAZMAT_HELMET_RED.get(), ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard((Item)RegisterItems.HAZMAT_HELMET_GREY.get(), ArmorRegistry.HazardClass.SAND);
    }

    public static boolean checkForFaraday(Player player) {
        NonNullList armor = player.m_150109_().f_35975_;
        if (((ItemStack)armor.get(0)).m_41619_() || ((ItemStack)armor.get(1)).m_41619_() || ((ItemStack)armor.get(2)).m_41619_() || ((ItemStack)armor.get(3)).m_41619_()) {
            return false;
        }
        return ArmorUtil.isFaradayArmor((ItemStack)armor.get(0)) && ArmorUtil.isFaradayArmor((ItemStack)armor.get(1)) && ArmorUtil.isFaradayArmor((ItemStack)armor.get(2)) && ArmorUtil.isFaradayArmor((ItemStack)armor.get(3));
    }

    public static boolean isFaradayArmor(ItemStack item) {
        String name = item.m_41778_();
        if (HazmatRegistry.getCladding(item) > 0.0) {
            return true;
        }
        for (String metal : metals) {
            if (!name.toLowerCase().contains(metal)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkArmorNull(LivingEntity player, EquipmentSlot slot) {
        return player.m_6844_(slot).m_41619_();
    }

    public static void damageSuit(Player player, int slot, int amount) {
        ((ItemStack)player.m_150109_().f_35975_.get(slot)).m_41622_(amount, (LivingEntity)player, p_32290_ -> p_32290_.m_21166_(ARMOR_SLOTS[slot]));
    }

    public static boolean checkForHazmat(LivingEntity player) {
        return ArmorUtil.checkArmorPieces(player, new Item[]{(Item)RegisterItems.HAZMAT_HELMET.get(), (Item)RegisterItems.HAZMAT_HELMET_RED.get(), (Item)RegisterItems.HAZMAT_HELMET_GREY.get()}, EquipmentSlot.HEAD) || ArmorUtil.checkArmorPieces(player, new Item[]{(Item)RegisterItems.HAZMAT_CHESTPLATE.get(), (Item)RegisterItems.HAZMAT_CHESTPLATE_RED.get(), (Item)RegisterItems.HAZMAT_CHESTPLATE_GREY.get()}, EquipmentSlot.CHEST) || ArmorUtil.checkArmorPieces(player, new Item[]{(Item)RegisterItems.HAZMAT_LEGGINGS.get(), (Item)RegisterItems.HAZMAT_LEGGINGS_RED.get(), (Item)RegisterItems.HAZMAT_LEGGINGS_GREY.get()}, EquipmentSlot.LEGS) || ArmorUtil.checkArmorPieces(player, new Item[]{(Item)RegisterItems.HAZMAT_BOOTS.get(), (Item)RegisterItems.HAZMAT_BOOTS_RED.get(), (Item)RegisterItems.HAZMAT_BOOTS_GREY.get()}, EquipmentSlot.FEET);
    }

    public static boolean checkArmor(LivingEntity player, Item helm, Item chest, Item leg, Item shoe) {
        return player.m_6844_(EquipmentSlot.FEET).m_41720_() == shoe && player.m_6844_(EquipmentSlot.LEGS).m_41720_() == leg && player.m_6844_(EquipmentSlot.CHEST).m_41720_() == chest && player.m_6844_(EquipmentSlot.HEAD).m_41720_() == helm;
    }

    public static boolean checkArmorPieces(LivingEntity player, Item[] armors, EquipmentSlot slot) {
        for (Item armor : armors) {
            if (!ArmorUtil.checkArmorPiece(player, armor, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkArmorPiece(LivingEntity player, Item armor, EquipmentSlot slot) {
        return player.m_6844_(slot).m_41720_() == armor;
    }

    public static void damageGasMaskFilter(LivingEntity entity, int damage) {
        ItemStack[] mods;
        ItemStack mask = entity.m_6844_(EquipmentSlot.HEAD);
        if (mask.m_41619_()) {
            return;
        }
        if (!(mask.m_41720_() instanceof IGasMask) && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[ArmorModHandler.helmet_only.ordinal()] != null && mods[ArmorModHandler.helmet_only.ordinal()].m_41720_() instanceof IGasMask) {
            mask = mods[ArmorModHandler.helmet_only.ordinal()];
        }
        if (mask != null) {
            ArmorUtil.damageGasMaskFilter(mask, damage);
        }
    }

    public static void damageGasMaskFilter(ItemStack mask, int damage) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(mask);
        if (filter == null && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[ArmorModHandler.helmet_only.ordinal()] != null && mods[ArmorModHandler.helmet_only.ordinal()].m_41720_() instanceof IGasMask) {
            filter = ArmorUtil.getGasMaskFilter(mods[ArmorModHandler.helmet_only.ordinal()]);
        }
        if (filter == null || filter.m_41776_() == 0) {
            return;
        }
        filter.m_41721_(filter.m_41773_() + damage);
        if (filter.m_41773_() > filter.m_41776_()) {
            ArmorUtil.removeFilter(mask);
        } else {
            ArmorUtil.installGasMaskFilter(mask, filter);
        }
    }

    public static void installGasMaskFilter(ItemStack mask, ItemStack filter) {
        if (mask.m_41619_() || filter.m_41619_()) {
            return;
        }
        CompoundTag maskTag = mask.m_41784_();
        CompoundTag filterTag = new CompoundTag();
        filter.m_41739_(filterTag);
        maskTag.m_128365_(FILTER_KEY, (Tag)filterTag);
    }

    public static void removeFilter(ItemStack mask) {
        if (mask.m_41619_()) {
            return;
        }
        CompoundTag maskTag = mask.m_41783_();
        if (maskTag == null || !maskTag.m_128441_(FILTER_KEY)) {
            return;
        }
        maskTag.m_128473_(FILTER_KEY);
        if (maskTag.m_128456_()) {
            mask.m_41751_(null);
        }
    }

    public static ItemStack getGasMaskFilter(ItemStack mask) {
        if (mask.m_41619_()) {
            return ItemStack.f_41583_;
        }
        CompoundTag maskTag = mask.m_41783_();
        if (maskTag == null || !maskTag.m_128425_(FILTER_KEY, 10)) {
            return ItemStack.f_41583_;
        }
        CompoundTag filterTag = maskTag.m_128469_(FILTER_KEY);
        ItemStack filter = ItemStack.m_41712_((CompoundTag)filterTag);
        return filter.m_41619_() ? ItemStack.f_41583_ : filter;
    }

    public static ItemStack getGasMaskFilterRecursively(ItemStack mask) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(mask);
        if ((filter == null || filter.m_41619_()) && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[ArmorModHandler.helmet_only.ordinal()] != null && mods[ArmorModHandler.helmet_only.ordinal()].m_41720_() instanceof IGasMask) {
            filter = ((IGasMask)mods[ArmorModHandler.helmet_only.ordinal()].m_41720_()).getFilter(mods[ArmorModHandler.helmet_only.ordinal()]);
        }
        return filter;
    }

    public static void addGasMaskTooltip(ItemStack mask, Level world, List<Component> list, TooltipFlag flagIn) {
        if (mask == null || !(mask.m_41720_() instanceof IGasMask)) {
            return;
        }
        ItemStack filter = ((IGasMask)mask.m_41720_()).getFilter(mask);
        if (filter.m_41619_()) {
            list.add((Component)Component.m_237113_((String)("\u00a7c" + I18nUtil.resolveKey("desc.nofilter", new Object[0]))));
            return;
        }
        list.add((Component)Component.m_237113_((String)("\u00a76" + I18nUtil.resolveKey("desc.infilter", new Object[0]))));
        int meta = filter.m_41773_();
        int max = filter.m_41776_();
        Object append = "";
        Object dur = "";
        if (max > 0) {
            append = " (" + Library.getPercentage((double)(max - meta) / (double)max) + "%)";
            dur = max - meta + "/" + max;
        }
        ArrayList lore = new ArrayList();
        list.add((Component)Component.m_237113_((String)("  " + filter.m_41611_().getString().replace("[", "").replace("]", "") + (String)append)));
        list.add((Component)Component.m_237113_((String)("  " + (String)dur)));
        filter.m_41720_().m_7373_(filter, world, lore, flagIn);
        ForgeEventFactory.onItemTooltip((ItemStack)filter, null, lore, (TooltipFlag)flagIn);
        lore.forEach(x -> list.add((Component)Component.m_237113_((String)"\u00a7e  ").m_7220_(x)));
    }
}

